<circuit access="public">

	<fuseaction name="home">
		<smt.assign name="title" value='"$storeName"' />
		<do action="Menu" contentvariable="menucontent" />
		<do action="vStore.home" contentvariable="pagecontent" />
		<set name="isHomepage" value="true" />
	</fuseaction>

	<fuseaction name="ContactUs">
		<smt.assign name="title" value='"$storeName - Contact Us"' />
		<do action="Menu" contentvariable="menucontent" />
	
		<do action="vStore.ContactUs" contentvariable="pagecontent" />
	</fuseaction>
	
	<fuseaction name="viewCart">
		<smt.assign name="title" value='"$storeName - Cart Contents"' />
		<do action="Menu" contentvariable="menucontent" />
		
		<do action="mStore.GetCartInfo" />
		<loop from="0" to="(count($CartInfo)-1)" index="i">
			<set name="product_id" value="{$CartInfo[$i]['product_id']}" />
			<set name="productPrice[$product_id]" value="{$CartInfo[$i]['price']}" />
		</loop>
		<smt.assign name="CartInfo" value="$CartInfo" />
		<smt.assign name="subTotalCost" value="$subTotalCost" />
		<smt.assign name="totalWeight"  value="$totalWeight" />
		<smt.assign name="additional_handling" value="$additional_handling" />
		
		<do action="mStore.GetShippingAndHandling" />
		<smt.assign name="totalHandlingCost" value="$totalHandlingCost" />
		<smt.assign name="shippingCost" value="$shippingCost" />
		<smt.assign name="weightExceeded" value="$weightExceeded" />
		<smt.assign name="totalCost" value="$totalHandlingCost + $shippingCost + $subTotalCost" />
		<set name="session_shipping_amount" value="$shippingCost" />
		<set name="session_handling_amount" value="$totalHandlingCost" />
		
		<smt.assign name="xfa_doRemoveSubmit" value="'Store.RemoveProducts'" />
		<smt.assign name="xfa_doCheckoutSubmit" value="'Checkout.ProvideInfo'" />
		<smt.assign name="PHPSESSID" value="$PHPSESSID" />
		
		<do action="vStore.viewCart" contentvariable="pagecontent" />
	</fuseaction>
	
	<fuseaction name="RemoveProducts">
	
		<do action="mStore.RemoveProducts" />
		
		<relocate url="index.php?fuseaction=Store.viewCart" />
	</fuseaction>
	
	<fuseaction name="Product">
		<do action="mStore.GetProduct" />
	
		<smt.assign name="title" value='"$storeName - " . $Product[0]["name"]' />
		<do action="Menu" contentvariable="menucontent" />
		
		<smt.assign name="xfa_doSubmit" value="'Store.submitProduct'" />
		<smt.assign name="Product" value="$Product" />
		<do action="vStore.Product" contentvariable="pagecontent" />
	
	</fuseaction>
	
	<fuseaction name="submitProduct">
		<set name="productList[$product_id]" value="$quantity" />
		
		<relocate url="index.php?fuseaction=Store.viewCart" />
	</fuseaction>

	<fuseaction name="InitSettings" access="internal">
		<do action="mStore.InitSettings" />
		<smt.assign name="settings" value="$settings" />
	</fuseaction>
	
	<fuseaction name="Menu" access="internal">
		<do action="mStore.GetCategoriesList" />
		<smt.assign name="CategoriesList" value="$CategoriesList" />
		
		<do action="mStore.GetProductsList" />
		<smt.assign name="ProductsList" value="$ProductsList" />
		
		<smt.assign name="has_cart_contents" value="count($productList)" />
		
		<smt.assign name="xfa_onContactUsClick" value="'Store.ContactUs'" />
		<smt.assign name="xfa_onViewCartClick" value="'Store.viewCart'" />
		<smt.assign name="xfa_onProductClick" value="'Store.Product'" />
		
		<do action="vStore.menu" />
	</fuseaction>
	
	
</circuit>
