unit TravCyl;
(****************************************************************************
This program will read a TravCyl Report, parse the data, and create a DXF
file based on the criteria specified in the GUI. The program is based on the
ideas of Jason Bailey & Darren Aklestad. The purpose of this program is to
simplify the job of the well planner who is tasked with creating the anti-
collision diagram.
NOTES TO SELF:
	Subject Well = Reference Well = Planned Well
	Object Wells = Offset Wells   =	Other Wells
*****************************************************************************)
interface
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, ExtCtrls, StdCtrls, ComCtrls, DoubleLinkedList, Math;
type
// Form components
  TFMain = class(TForm)
	  GBFileInformation: TGroupBox;
	  lblTCylFile: TLabel;
	  eTCylFile: TEdit;
	  OpenDialog1: TOpenDialog;
    lblDXFFile: TLabel;
	  eDXFFile: TEdit;
	  RGInputType: TRadioGroup;
	  SBTCylFile: TSpeedButton;
	  CBDesignCadYes: TCheckBox;
    GBHeader: TGroupBox;
	  LMapNum: TLabel;
    EMapNum: TEdit;
 	  LPlanNum: TLabel;
	  EPlanNum: TEdit;
	  LScale: TLabel;
	  EScale: TEdit;
    LClient: TLabel;
    EClient: TEdit;
	  StatusBar1: TStatusBar;
	  BBConvert: TBitBtn;
    lblWell: TLabel;
	  EWell: TEdit;
	  lblField: TLabel;
    EField: TEdit;
	  lblRig: TLabel;
	  ERig: TEdit;
	  EFrom: TEdit;
	  lblFrom: TLabel;
	  ETo: TEdit;
	  lblTo: TLabel;
    MSurveyProgram: TMemo;
    lblSvyPrgm: TLabel;
    GBDrawingOptions: TGroupBox;
    CBTics: TComboBox;
    CBCircles: TComboBox;
    lblTics: TLabel;
    Label1: TLabel;
    CBScale: TComboBox;
    lblScale: TLabel;
// Function Prototype
   function  ReadCompStations(Sender: TObject; WellName: String; var WellList: TCWell): boolean;
   function  ReadCompassData(Sender: TObject; myWell: TCWell): boolean;
   function  ReadData(Sender: TObject; myWell : TCWell): boolean;
   function  WriteCirFile(Sender: TObject; WellList: TCWell): boolean;
   function  MakeDW2File(Sender: TObject): boolean;
	procedure BBConvertClick(Sender: TObject);
	procedure SBTCylFileClick(Sender: TObject);
//   function  WriteCirles(Sender: TObject; WellList: TCWell): boolean;
//   function  WritePath(Sender: TObject; WellList: TCWell): boolean;

 	private
    { Private declarations }
    TCylFile, DXFFile, DW2File: TextFile;
  public
    { Public declarations }
    myScale : real;
end;
var
  FMain: TFMain;
implementation
{$R *.DFM}
/////////////////////////////////////////////////////////////////////////////
function TFMain.ReadData(Sender: TObject; myWell : TCWell): boolean;
{------------------------------------------------------------------------------
This procedure checks that files actually exist. Then sends the program to
appropriate parsing routine. Currently, I only have the Compass parser written.
------------------------------------------------------------------------------}
begin
  StatusBar1.Panels[0].Text := 'Status: Reading TravCyl Report';
  if (eTCylFile.Text <> '') AND FileExists(eTCylFile.Text) then
  begin
    AssignFile (TCylFile, eTCylFile.Text);
    AssignFile (DXFFile, eDXFFile.Text);
    AssignFile (DW2File, copy(eTCylFile.Text, 1, length(eTCylFile.Text)-3) + 'bla');
      try
        Reset (TCylFile);
 //       Rewrite (DXFFile);
     	case RGInputType.ItemIndex of
       	0: if not (ReadCompassData(Sender,myWell)=true)then StatusBar1.Panels[0].Text := 'Status: TravCyl Report bad';
       	1: ShowMessage('This feature has yet to be implemented. Sorry!');
     	end;  {Case}
      finally
  	 	CloseFile (TCylFile);
//  	 	CloseFile (DXFFile);
      end;    //try
      result := true;
  end      // if FileExists
  else
  	begin
        ShowMessage('Input File not found. Please try again.');
      result := false;
    end
end;
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
function TFMain.ReadCompStations(Sender: TObject; WellName: String; var WellList: TCWell): boolean;
{------------------------------------------------------------------------------
This procedure only reads the data and loads it into the actual Linked Lists.
The sole purpose of this function is to tidy up the code of ReadCompassData
since this code *could* just sit in the loop that calls it.
------------------------------------------------------------------------------}
var
	myWell		: TCWell;
  myString	: variant;
  junk			: String[130];
  i					: integer;
  errCount  : integer;
  sMD,sTVD,oMD,oTVD,aziTN,aziHS,ctr2ctr, allowDev : real;
Begin
	try
  // DW2File is only being used for troubleshooting
(*  AssignFile (DW2File, 'blah.txt');
  Rewrite (DW2File);
  CloseFile (DW2File);  // *)
  errCount := 0;
  if WellName <> StatusBar1.Panels[1].Text then  // add well
    begin
      myWell:=TCWell.create;
      WellList.next := myWell;
      myWell.name := WellName;
      WellList := myWell;
    end
  else
    begin
      myWell := WellList;
    end;
  myString := '';
  while myString <> 'Site:' do
 	begin
   	readln (TCylFile, junk);
    if junk <> '' then
    begin
	    myString := '';
  		for i := 3 to 7 do myString := myString + junk[i];
			// only look at data rows
      if (length(trim(junk)) > 107) AND (myString <> 'Compa') AND (myString <> 'Refer') AND (myString <> '    M') AND (myString <> 'Site:') then
      begin
//      	ShowMessage (junk); // for troubleshooting my criteria above.
		    myString := '';
      	for i := 3 to 11 do myString := myString + junk[i];
        trim(myString);
        sMD := myString;
		    myString := '';
      	for i := 12 to 21 do myString := myString + junk[i];
        trim(myString);
        sTVD:=myString;
		    myString := '';
      	for i := 22 to 30 do myString := myString + junk[i];
        trim(myString);
        oMD:=myString;
		    myString := '';
      	for i := 31 to 40 do myString := myString + junk[i];
        trim(myString);
        oTVD:=myString;
		    myString := '';
      	for i := 58 to 64 do myString := myString + junk[i];
        trim(myString);
        aziTN:=myString;
		    myString := '';
      	for i := 65 to 72 do myString := myString + junk[i];
        trim(myString);
	      aziHS:=myString;
		    myString := '';
      	for i := 81 to 90 do myString := myString + junk[i];
        trim(myString);
        ctr2ctr:=myString;
		    myString := '';
      	for i := 98 to 107 do myString := myString + junk[i];
        if myString <>'          ' then
        	begin
          	trim(myString);
            allowDev:=myString;
          end
        else
        	begin
          	myString := '';
            for i := 108 to 129 do myString := myString + junk[i];
            trim(myString);
            if (errCount = 0) then
              begin
                ShowMessage('Warning: '+myWell.name+'>>'+myString);
                errCount := 1
              end;
          	allowDev := -9999.9;
          end;
//        writeln(DXFFile, junk);  // for Troubleshooting
        myWell.AddStation(Sender,sMD,sTVD,oMD,oTVD,aziTN,aziHS,ctr2ctr,allowDev)
      end;

//      else ShowMessage (junk); // for troubleshooting IF statement
    end;
   	if EOF(TCylFile) then break; // kill loop if end of file reached.
  end; {while}
  result   := true;
  finally end;
End;
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
function TFMain.ReadCompassData(Sender: TObject; myWell: TCWell): boolean;
{------------------------------------------------------------------------------
This procedure parses the Compass trav cyl report and performs and feeds the
data into a few linked lists
------------------------------------------------------------------------------}
var
	RCDWell : TCWell;
	myString : variant;
	junk :string[130];
  i : integer;
begin
  RCDWell := myWell;
  StatusBar1.Panels[0].Text := 'Status: Parsing Compass TravCyl Report';
  for i := 0 to 19 do readln (TCylFile, junk); // skip over data we don't need
  myString := junk;
  while junk <> '' do
  begin
    readln (TCylFile, junk);
  	myString := myString+ char(13) +junk;
  end;
  MSurveyProgram.Lines.Text := myString;
  while not EOF(TCylFile) do
  begin
	  while myString <> 'Wellpath:' do
  	begin
    	readln (TCylFile, junk);
	    myString := '';
	  	for i := 3 to 11 do myString := myString + junk[i];
      if EOF(TCylFile) then break; // kill loop if end of file reached.
	  end;
    if not EOF(TCylFile) then
    begin
    	myString := '';
	    for i := 13 to 82 do myString := myString + junk[i];
  	  myString := trim(myString);
  	  ReadCompStations(Sender, myString, RCDWell);
		  StatusBar1.Panels[1].text := myString;
    end;
  end; // while not EOF(TCylFile) do
	result := true;
end;
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
function TFMain.WriteCirFile(Sender: TObject;WellList: TCWell): boolean;
{------------------------------------------------------------------------------
This procedure writes the DXF file based on the data gathered from TCyl report
I will have to verify exactly which DXF version I am basing this file upon.
However, since I'm only making lines, circles and text there should not be too
much a difference between version.
UPDATE: I had too many problems decyphering DXF and my funding was cut. I need
to complete this project as quickly as possible and will just use the CIR file.
------------------------------------------------------------------------------}
var
  myWell : TCWell;
  mySrvy : TCSurveyRpt;
  myCirc : array[1..300,1..4]of real;
  myTic  : array[1..300,1..6]of real;
  myPath : array[1..300,1..2]of real;
  rAzi,x,y,x0,y0,md0,rad0,ratio  : real;
  tcount,Count,CCount,i : integer;
begin
	myWell := WellList;
  myScale := 20.0;
  StatusBar1.Panels[0].Text := 'Status: Writing CIR File';
  if (eDXFFile.Text <> '') then
  	try
	  begin
  		AssignFile (DXFFile, eDXFFile.Text);
      Rewrite (DXFFile);
      Rewrite (DW2File);
      writeln (DXFFile, '$SurvProg');
      writeln (DXFFile, MSurveyProgram.text);
      writeln (DXFFile, '$Head');
      writeln (DXFFile, '"',EClient.text,'","', EWell.text,'","',EField.text,'","',ERig.text,'"');
      writeln (DXFFile, '"',EMapNum.text,'","',EPlanNum.text,'"');
      writeln (DXFFile, '"',EScale.text,'","2"');
      writeln (DXFFile, '"', EFrom.text,'","',ETo.text,'"');
//      writeln(DXFFile, '0', chr(13), chr(10), 'SECTION', chr(13), chr(10), '2', chr(13), chr(10), 'ENTITIES');
      while (myWell <> nil) do
      begin
      	mySrvy := myWell.head;
        CCount := 1;
        tcount := 1;
        Count  := 1;
        // the following is for testing interpolation....comment it out when creating my CS490 datafile
        writeln(DW2File, '');
        while (mySrvy <> nil) do
        begin
          rAzi := DegToRad(90.0 - mySrvy.AziTN);
          x := mySrvy.ctr2ctr/myScale * cos(rAzi);
          y := mySrvy.ctr2ctr/myScale * sin(rAzi);
          // the following is for my CS490 datafile....comment it out when testing interpolation
//          writeln(DW2File, FloatToStrF(x,ffFixed,4,6),' ',FloatToStrF(y,ffFixed,4,6),' ',FloatToStrF((mySrvy.sMD/20.0),ffFixed,4,6) ,' ',FloatToStrF((mySrvy.ctr2ctr - mySrvy.allowDev),ffFixed,4,6),' ',FloatToStrF(mySrvy.allowDev,ffFixed,4,6));
          if(mySrvy.allowDev < myScale*16.5) then
          begin
	          myCirc[CCount][1] := x;
  	        myCirc[CCount][2] := y;
    	      myCirc[CCount][3] := (mySrvy.ctr2ctr - mySrvy.allowDev)/myScale;
            myCirc[CCount][4] := mySrvy.sMD;
            md0 := (Trunc(mySrvy.sMD-50) div 100) *100.0;
            if (CCount > 1) AND (mySrvy.sMD > 100)  then
            begin
              if myCirc[CCount-1][4] = myCirc[CCount][4] then ratio := (md0-myCirc[CCount-1][4])/(myCirc[CCount-1][1]-myCirc[CCount][1]);
              if myCirc[CCount-1][1] = myCirc[CCount][1] then x0    := myCirc[CCount-1][1] else x0   := ratio * (myCirc[CCount-1][1] - myCirc[CCount][1]) + myCirc[CCount-1][1];
              if myCirc[CCount-1][2] = myCirc[CCount][2] then y0    := myCirc[CCount-1][2] else y0   := ratio * (myCirc[CCount-1][2] - myCirc[CCount][2]) + myCirc[CCount-1][2];
              if myCirc[CCount-1][3] = myCirc[CCount][3] then rad0  := myCirc[CCount-1][3] else rad0 := ratio * (myCirc[CCount-1][3] - myCirc[CCount][3]) + myCirc[CCount-1][3];
           // the following is for testing interpolation....comment it out when creating my CS490 datafile
              writeln(DW2File, FloatToStrF(x0,ffFixed,4,3),' ',FloatToStrF(y0,ffFixed,4,3),' ',FloatToStrF(rad0,ffFixed,4,3), ' ', FloatToStrF(md0,ffFixed,4,2), ' ', FloatToStrF(myCirc[CCount][4],ffFixed,4,2));
            end
            else if CCount=1 then
            begin
              x0   := myCirc[CCount][1];
              y0   := myCirc[CCount][2];
              rad0 := myCirc[CCount][3];
           // the following is for testing interpolation....comment it out when creating my CS490 datafile
              writeln(DW2File, FloatToStrF(x0,ffFixed,4,3),' ',FloatToStrF(y0,ffFixed,4,3),' ',FloatToStrF(rad0,ffFixed,4,3), ' 0.00 ', FloatToStrF(mySrvy.sMD,ffFixed,4,2));
            end;
            inc(CCount);
          end; //if
          if(mySrvy.ctr2ctr < myScale*16) then
          begin
	          myPath[count][1]:=x;
  	        myPath[count][2]:=y;
            if myCirc[ccount-1][4] > 500.0 then
            begin
              myTic[tcount][1]:=x;
    	        myTic[tcount][2]:=y;
      	      myTic[tcount][3]:=x+0.08;
  	          myTic[tcount][4]:=y+0.08;
    	        myTic[tcount][5]:=0.00;
    	        myTic[tcount][6]:=mySrvy.sMD;
              inc (tcount);
            end;
            inc(count);
          end; //if
          mySrvy :=	 mySrvy.next;
        end; //while
				////////////////////////////

      if (myWell.Head <> nil) then
      begin
        ////////// Put on the circles
        writeln(DXFFile, '$Circle');
        writeln(DXFFile, ccount-1, ',"All Circles"');
        for i:=1 to CCount - 1 do
        begin
	        writeln(DXFFile, FloatToStrF(myCirc[i][1],ffFixed,4,6) , ',' , FloatToStrF(myCirc[i][2],ffFixed,4,6), ',' , FloatToStrF(myCirc[i][3],ffFixed,4,6));
        end; // do
        ////////// Put the wellbore in
        writeln(DXFFile, '$Well');
        writeln(DXFFile, count-1, ',"', myWell.Name , '"');
        for i:=1 to count -1 do
        begin
	        writeln(DXFFile, FloatToStrF(myPath[i][1],ffFixed,4,6), ',', FloatToStrF(myPath[i][2],ffFixed,4,6));
        end; //do
        ////////// Put in the tics
        writeln(DXFFile, '$Tics');
        writeln(DXFFile, tcount-1);
        for i:=1 to tcount-1 do
        begin
          writeln(DXFFile, FloatToStrF(myTic[i][1],ffFixed,4,6), ',', FloatToStrF(myTic[i][2],ffFixed,4,6), ',', FloatToStrF(myTic[i][3],ffFixed,4,6), ',', FloatToStrF(myTic[i][4],ffFixed,4,6), ',', FloatToStrF(myTic[i][5],ffFixed,4,6), ',', FloatToStrF(myTic[i][6],ffFixed,4,6));
        end; // do
      end; // if
      myWell := myWell.next;
    end;//do
    CloseFile (DXFFile);
    CloseFile (DW2File);
    result := true;
  	end //try

    finally end
  else
  result := false;
end;
/////////////////////////////////////////////////////////////////////////////
function TFMain.MakeDW2File(Sender: TObject): boolean;
{------------------------------------------------------------------------------
Opens DXF in DesignCAD, then performs OLE operations to finish off the drawing.
-------------------------------------------------------------------------------}
begin
  StatusBar1.Panels[0].Text := 'Status: Invoking DesignCAD';
  result := true;
end;
/////////////////////////////////////////////////////////////////////////////
procedure TFMain.BBConvertClick(Sender: TObject);
var myWell: TCWell;
begin
	myWell:=TCWell.create;
  StatusBar1.Panels[0].Text := 'Status: Starting...';
  if(ReadData(sender,myWell)=true) then
  	begin
	  	StatusBar1.Panels[0].Text := 'Status: Good Stuff';
		  if (WriteCirFile(Sender,myWell)=true) then
  			StatusBar1.Panels[0].Text := 'Status: Good Stuff, too'
		  else
      	begin
		  		StatusBar1.Panels[0].Text := 'Status: Output File dunna bad, bad thing, again!';
  	    	ShowMessage('Output File could not be created. Please try again.');
        end
	   end
  else
	  begin
  		StatusBar1.Panels[0].Text := 'Status: Input File dunna bad, bad thing!';
    end
end;
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
procedure TFMain.SBTCylFileClick(Sender: TObject);
{------------------------------------------------------------------------------
Browses to data file, reads header, fills in as much header data as it can, and
puts the filename & path into the appropriate text box in the form.
------------------------------------------------------------------------------}
var
	junk :string[130]; myString : variant;
  i : integer;
begin
	if OpenDialog1.Execute then eTCylFile.Text := OpenDialog1.Filename;
  if (eTCylFile.Text <> '') AND FileExists(eTCylFile.Text) then
  Begin
  	eDXFFile.Text := copy(eTCylFile.Text, 1, length(eTCylFile.Text)-3) + 'cir';
    AssignFile (TCylFile, eTCylFile.Text);
		try
      Reset (TCylFile);	// Read header and fill in as much "Header Data" as you can from this file
      for i := 0 to 9 do readln (TCylFile, junk); // skip over data we don't need
      myString := ''; // initialize string variable
      for i := 21 to length(junk) do myString := myString + junk[i]; // read data in appropriate column
 	    EField.text := trim(myString); // get rid of unnecessary whitespace
      for i := 0 to 1 do readln (TCylFile, junk);
      myString := '';
      for i := 21 to 63 do myString := myString + junk[i];
 	    EWell.text := trim(myString);
      for i := 0 to 4 do readln (TCylFile, junk);
      myString := '';
      for i := 19 to 27 do myString := myString + junk[i];
 	    EFrom.text := trim(myString);
      myString := '';
      for i := 32 to 40 do myString := myString + junk[i];
 	    ETo.text := trim(myString); // end of header scan, close file and exit subroutine.
    finally
      CloseFile(TCylFile);
    end;
  End
  else
    StatusBar1.Panels[0].Text := 'Status: File Does Not Exist!';
end;
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////


end.
