using System;
using System.Configuration;
using System.Drawing;
using System.Windows.Forms;
using Microsoft.DirectX;
using Microsoft.DirectX.Direct3D;

namespace SimonBlocks
{
	/// <summary>
	/// The main selection screen for the game
	/// </summary>
	public class PlayerUIScreen : UIScreen, IDisposable
	{
		private Texture buttonTextures = null;
		private Texture messageTexture = null;

		private UIButton oneButton = null;
		private UIButton twoButton = null;

		// Events
		public event EventHandler OnePlayer;
		public event EventHandler TwoPlayer;

		public PlayerUIScreen(Device device, int width, int height) : base(device, width, height)
		{
			messageTexture = TextureLoader.FromFile(device, GameMain.MediaPath + "SimonMainMenu.png");
			// Mark the background texture as centered
			StoreTexture(messageTexture, width, height, false);

			buttonTextures = TextureLoader.FromFile(device, GameMain.MediaPath + "playerbuttons1.png");

			oneButton = new UIButton(renderSprite, buttonTextures, buttonTextures,new Rectangle(0,LargeButtonHeight * 1,
				LargeButtonWidth, LargeButtonHeight), new Rectangle(0,0,LargeButtonWidth, LargeButtonHeight), 
				new Point((width - LargeButtonWidth) / 2,(height - (LargeButtonHeight * 4)) / 2));

			twoButton = new UIButton(renderSprite, buttonTextures, buttonTextures, new Rectangle(0,LargeButtonHeight * 3,
				LargeButtonWidth, LargeButtonHeight), new Rectangle(0,LargeButtonHeight * 2,LargeButtonWidth, LargeButtonHeight), 
				new Point((width - LargeButtonWidth) / 2,(height - (LargeButtonHeight * 2)) / 2));

			oneButton.Click += new EventHandler(OnOneButton);
			twoButton.Click += new EventHandler(OnTwoButton);
		}

		public override void Draw()
		{
			// Start rendering sprites
			base.BeginSprite();
			// Draw the background
			base.Draw();

			// Now the buttons
			oneButton.Draw();
			twoButton.Draw();

			// You're done rendering sprites
			base.EndSprite();
		}

		private void OnOneButton(object sender, EventArgs e)
		{
			if (OnePlayer != null)
				OnePlayer(this, e);
		}

		private void OnTwoButton(object sender, EventArgs e)
		{
			if (TwoPlayer != null)
				TwoPlayer(this, e);
		}

		public void OnMouseMove(int x, int y)
		{
			oneButton.OnMouseMove(x, y);
			twoButton.OnMouseMove(x, y);
		}

		public void OnMouseClick(int x, int y)
		{
			oneButton.OnMouseClick(x, y);
			twoButton.OnMouseClick(x, y);
		}

		public void OnKeyPress(System.Windows.Forms.Keys key)
		{
			switch(key)
			{
				case Keys.NumPad1: //exit game
					OnOneButton(this, EventArgs.Empty);
					break;
				case Keys.NumPad2: //start new game
					OnTwoButton(this, EventArgs.Empty);
					break;
			}
		}

		#region IDisposable Members
		/// <summary>
		/// Cleanup in case dispose isn't called
		/// </summary>
		~PlayerUIScreen()
		{
			Dispose();
		}
		/// <summary>
		/// Cleanup any resources
		/// </summary>
		public override void Dispose()
		{
			GC.SuppressFinalize(this);
			if (messageTexture != null)
			{
				messageTexture.Dispose();
			}
			if (buttonTextures != null)
			{
				buttonTextures.Dispose();
			}
			buttonTextures = null;
			messageTexture = null;
			base.Dispose();
		}

		#endregion
	}
}
