//Code based on code provided by Beginning 3D Game Programming by Tom Miller

using System;
using System.Configuration;
using System.Drawing;
using System.Windows.Forms;
using Microsoft.DirectX;
using Microsoft.DirectX.Direct3D;

namespace SimonBlocks
{
	public class UIButton
	{
		private Sprite renderSprite = null;
		private Texture buttonTextureOff = null;
		private Texture buttonTextureOn = null;
		private Rectangle onSource;
		private Rectangle offSource;
		private Vector3 location;
		private bool isButtonOn = false;
		private Rectangle buttonRect;

		// The click event
		public event EventHandler Click;

		public UIButton(Sprite sprite, Texture on, Texture off, 
			Rectangle rectOn, Rectangle rectOff, Point buttonLocation)
		{
			// Store the sprite object
			renderSprite = sprite;

			// Store the textures
			buttonTextureOff = off;
			buttonTextureOn = on;

			// Rectangles
			onSource = rectOn;
			offSource = rectOff;

			// Location
			location = new Vector3(buttonLocation.X, buttonLocation.Y, 0);

			// Create a rectangle based on the location and size
			buttonRect = new Rectangle((int)location.X, (int)location.Y, 
				onSource.Width, onSource.Height);

		}

		public void OnMouseMove(int x, int y)
		{
			// Determine if the button is on or not
			isButtonOn = buttonRect.Contains(x, y);
		}

		public void OnMouseClick(int x, int y)
		{
			// Determine if the button is pressed
			if(buttonRect.Contains(x, y))
			{
				if (Click != null)
					Click(this, EventArgs.Empty);
			}
		}

		public void Draw()
		{
			if (isButtonOn)
			{
				renderSprite.Draw(buttonTextureOn, onSource, UIScreen.ObjectCenter, 
					location, UIScreen.SpriteColor);
			}
			else
			{
				renderSprite.Draw(buttonTextureOff, offSource, UIScreen.ObjectCenter, 
					location, UIScreen.SpriteColor);
			}
		}
	}
}
