//{{{ GPL Notice
/*
 *  ProColPlugin.java
 *  :tabSize=4:indentSize=4:noTabs=false:
 *  :folding=explicit:collapseFolds=1:
 *
 *  part of the ProCol plugin for the jEdit text editor
 *  Copyright (C) 2003-2004 Justin Dieters
 *  enderak@yahoo.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//}}}

package com.enderak.procol;

//{{{ Imports
import com.enderak.procol.client.gui.ConnectFrame;
import com.enderak.procol.client.gui.ProColClientDockable;
import com.enderak.procol.client.net.ProColClient;
import com.enderak.procol.server.RunProColServer;
import javax.swing.JOptionPane;
//}}}

/**
 *  The main ProCol plugin class
 *
 *@author    Justin Dieters
 */
public class ProColPlugin extends org.gjt.sp.jedit.EditPlugin {
	//{{{ Data members
	/**  Name used for properties */
	public final static String NAME           = "procol";
	/**  Prefix used for options properties */
	public final static String OPTION_PREFIX  = "options.procol.";
	private static ProColClient proColClient  = null;
	//}}}

	//{{{ Accessor methods
	/**
	 *  Gets the ProCol client instance
	 *
	 *@return    The Client
	 */
	public static ProColClient getClient() {
		return proColClient;
	}
	//}}}

	//{{{ Menu actions
	/**  Connects or disconnects the client from the server */
	public static void connectToServer() {
		if (proColClient.isConnected()) {
			if (JOptionPane.showConfirmDialog(null, "Are you sure you want to disconnect?", "Disconnect Confirmation", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE) == JOptionPane.YES_OPTION) {
				proColClient.disconnect();
			}
		} else {
			new ConnectFrame();
		}
	}


	/**  Gets the project info from the server during login process */
	public static void getProjectInfo() {
		if (proColClient.isConnected() && proColClient.isAuthenticated()) {
			new com.enderak.procol.client.gui.ProjectInfoFrame();
		} else {
			ProColClientDockable.displayError("Not Connected", "You are not connected to a server!");
		}
	}


	/**  Opens to a new project */
	public static void changeProject() {
		if (proColClient.isConnected() && proColClient.isAuthenticated()) {
			new com.enderak.procol.client.gui.JoinProjectFrame();
		} else {
			ProColClientDockable.displayError("Not Connected", "You are not connected to a server!");
		}
	}
	//}}}

	//{{{ Start and Stop
	/**  Starts the Plugin - starts client and initializes the server */
	public void start() {
		// initialize data members - client, model, etc
		proColClient = new ProColClient();
		RunProColServer.initServer();
	}


	/**  Stops the Plugin - stops the client */
	public void stop() {
		// sync files to server, close network connections, etc
		if (proColClient.isConnected()) {
			proColClient.disconnect();
		}
	}
	//}}}
}

