//{{{ GPL Notice
/*
 *  ConnectFrame.java
 *  :tabSize=4:indentSize=4:noTabs=false:
 *  :folding=explicit:collapseFolds=1:
 *
 *  part of the ProCol plugin for the jEdit text editor
 *  Copyright (C) 2003-2004 Justin Dieters
 *  enderak@yahoo.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//}}}
package com.enderak.procol.client.gui;

//{{{ Imports
import com.enderak.procol.ProColPlugin;
import java.awt.*;
import javax.swing.*;
import org.gjt.sp.jedit.jEdit;
//}}}

/**
 *  Displays a frame for the user to enter the server name/IP and port to
 *  connect to
 *
 *@author    Justin Dieters
 */
public class ConnectFrame extends JFrame {
	//{{{ Constructor
	/**  Constructor for the ConnectFrame object */
	public ConnectFrame() {
		Toolkit kit           = Toolkit.getDefaultToolkit();
		Dimension screenSize  = kit.getScreenSize();

		this.setTitle(jEdit.getProperty("procol.client.connect.title"));
		this.getContentPane().add(new ConnectPanel(this));
		this.pack();
		this.setLocation((screenSize.width / 2) - (this.getWidth() / 2), (screenSize.height / 2) - (this.getHeight() / 2));
		this.setVisible(true);
	}
	//}}}

	private class ConnectPanel extends JPanel {
		//{{{ Data members
		private JTextField hostField  = new JTextField(jEdit.getProperty("options.procol.client.default.host"), 10);
		private JTextField portField  = new JTextField(jEdit.getProperty("options.procol.client.default.port"), 5);
		//}}}

		//{{{ Constructors
		/**
		 *  Constructor for the ConnectPanel object
		 *
		 *@param  parentFrame  Description of the Parameter
		 */
		public ConnectPanel(final ConnectFrame parentFrame) {
			//{{{ Button creation
			// OK Button
			JButton okButton      = new JButton(jEdit.getProperty("procol.label.ok"));
			okButton.addActionListener(
				new java.awt.event.ActionListener() {
					public void actionPerformed(java.awt.event.ActionEvent evt) {
						if (ProColPlugin.getClient().connectToServer(hostField.getText(), Integer.parseInt(portField.getText()))) {
							jEdit.setProperty("options.procol.client.default.host", hostField.getText());
							jEdit.setProperty("options.procol.client.default.port", portField.getText());
							parentFrame.dispose();
						}
					}
				});

			// Cancel Button
			JButton cancelButton  = new JButton(jEdit.getProperty("procol.label.cancel"));
			cancelButton.addActionListener(
				new java.awt.event.ActionListener() {
					public void actionPerformed(java.awt.event.ActionEvent evt) {
						parentFrame.dispose();
					}
				});
			//}}}

			//{{{ Layout
			Box hostportBox       = Box.createHorizontalBox();
			Box hostportBoxLeft   = Box.createVerticalBox();
			Box hostportBoxRight  = Box.createVerticalBox();
			JPanel buttonPanel    = new JPanel();
			Box loginBox          = Box.createVerticalBox();

			hostportBoxLeft.add(new JLabel(jEdit.getProperty("procol.client.connect.host")));
			hostportBoxLeft.add(hostField);
			hostportBoxRight.add(new JLabel(jEdit.getProperty("procol.client.connect.port")));
			hostportBoxRight.add(portField);
			hostportBox.add(hostportBoxLeft);
			hostportBox.add(hostportBoxRight);
			buttonPanel.add(okButton);
			buttonPanel.add(cancelButton);

			loginBox.add(hostportBox);
			loginBox.add(buttonPanel);

			this.add(loginBox);

			hostField.selectAll();
			//}}}
		}
		//}}}
	}
}
