//{{{ GPL Notice
/*
 *  GenericListPanel.java
 *  :tabSize=4:indentSize=4:noTabs=false:
 *  :folding=explicit:collapseFolds=1:
 *
 *  part of the ProCol plugin for the jEdit text editor
 *  Copyright (C) 2003-2004 Justin Dieters
 *  enderak@yahoo.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//}}}
package com.enderak.procol.client.gui;

//{{{ Imports
import com.enderak.procol.client.model.*;
import com.enderak.procol.client.net.*;
import com.enderak.procol.common.gui.*;
import com.enderak.procol.common.model.*;
import com.enderak.procol.common.net.*;
import com.enderak.procol.common.util.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.TitledBorder;
import javax.swing.event.*;
import org.gjt.sp.jedit.*;
import org.gjt.sp.jedit.gui.DockableWindowManager;
//}}}

/**
 *  Displays a panel that includes a list and a information display panel
 *
 *@author    Justin Dieters
 */
public class GenericListPanel extends JPanel implements Observer, ListSelectionListener, ActionListener {
	//{{{ Data Members
	protected JPanel messageDisplayPanel, listPanel;
	protected JScrollPane messageDisplayScrollPane, itemListScrollPane;
	protected JEditorPane messageDisplayEditorPane;
	protected String messageDisplay;
	protected Object[] selectedItems;
	protected JList itemList;
	protected JSplitPane splitPane;
	protected boolean isVerticalAlign, floating;
	protected View view;
	protected String position;
	//}}}

	//{{{ Constructors
	/**
	 *  Constructor for the GenericListPanel object
	 *
	 *@param  view      View associated with panel, as specified from jEdit
	 *@param  position  Position of panel, as specified from jEdit
	 *@param  type      The type of panel, used when getting stuff from properties
	 *      file
	 */
	public GenericListPanel(View view, String position, String type) {
		this.view = view;
		this.position = position;
		this.floating = position.equals(DockableWindowManager.FLOATING);

		// determine if panels should have a vertical or horizontal layout
		if (position.equals(DockableWindowManager.TOP) || position.equals(DockableWindowManager.BOTTOM) || floating) {
			this.isVerticalAlign = false;
		} else {
			this.isVerticalAlign = true;
		}

		setLayout(new java.awt.BorderLayout());

		//{{{ messageDisplay
		messageDisplayPanel = new JPanel();
		messageDisplayPanel.setLayout(new java.awt.BorderLayout());
		messageDisplayPanel.setBorder(new javax.swing.border.TitledBorder(jEdit.getProperty("procol.client." + type + ".detailslabel")));

		messageDisplayEditorPane = new JEditorPane();
		messageDisplayEditorPane.setContentType("text/html");
		messageDisplayEditorPane.setEditable(false);

		messageDisplayScrollPane = new JScrollPane(messageDisplayEditorPane);
		//}}}

		//{{{ item list
		listPanel = new JPanel();
		listPanel.setLayout(new BorderLayout());
		listPanel.setBorder(new TitledBorder(jEdit.getProperty("procol.client." + type + ".listlabel")));
		itemList = new JList();
		itemList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		itemListScrollPane = new JScrollPane(itemList);
		itemList.addListSelectionListener(this);
		//}}}

		listPanel.add(itemListScrollPane, java.awt.BorderLayout.CENTER);
		messageDisplayPanel.add(messageDisplayScrollPane, java.awt.BorderLayout.CENTER);
		if (isVerticalAlign) {
			splitPane = new JSplitPane(javax.swing.JSplitPane.VERTICAL_SPLIT, true, listPanel, messageDisplayPanel);
		} else {
			splitPane = new JSplitPane(javax.swing.JSplitPane.HORIZONTAL_SPLIT, true, listPanel, messageDisplayPanel);
		}
		splitPane.setOneTouchExpandable(true);
		splitPane.setResizeWeight(0.5);
		add(splitPane, java.awt.BorderLayout.CENTER);
		splitPane.setDividerLocation(0.3);
	}
	//}}}

	//{{{ Action/Observer Listeners
	//{{{ actionPerformed
	/**
	 *@param  evt  The ActionEvent event
	 */
	public void actionPerformed(java.awt.event.ActionEvent evt) { }
	//}}}

	//{{{ valueChanged(ListSelectionEvent e)
	/**
	 *@param  e  The ListSelectionEvent event
	 */
	public void valueChanged(ListSelectionEvent e) { }
	//}}}

	//{{{ update
	/**
	 *@param  o    Observable that called the update
	 *@param  arg  Object argument
	 */
	public void update(Observable o, Object arg) {
	}
	//}}}
	//}}}
}
