//{{{ GPL Notice
/*
 *  GenericUploadPanel.java
 *  :tabSize=4:indentSize=4:noTabs=false:
 *  :folding=explicit:collapseFolds=1:
 *
 *  part of the ProCol plugin for the jEdit text editor
 *  Copyright (C) 2003-2004 Justin Dieters
 *  enderak@yahoo.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//}}}
package com.enderak.procol.client.gui;

//{{{ Imports
import com.enderak.procol.client.model.*;
import com.enderak.procol.client.net.*;
import com.enderak.procol.common.gui.*;
import com.enderak.procol.common.model.*;
import com.enderak.procol.common.net.*;
import com.enderak.procol.common.util.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.TitledBorder;
import javax.swing.event.*;
import org.gjt.sp.jedit.*;
import org.gjt.sp.jedit.gui.DockableWindowManager;
//}}}

/**
 *  Displays a panel for use with checking in or uploading files to the server.
 *  Allows user to input versioning and changelog information
 *
 *@author    Justin Dieters
 */
public class GenericUploadPanel extends JPanel implements Observer, ListSelectionListener, ActionListener {
	//{{{ Data Members
	protected JPanel buttonPanel, changeLogPanel, newInfoPanel, versionPanel, versionInputPanel, versionOptionsPanel, fileListPanel;
	protected JRadioButton absoluteRadioButton, incrementRadioButton, noChangeRadioButton;
	protected JButton cancelButton, okButton;
	protected ButtonGroup versionOptionsButtonGroup;
	protected JScrollPane changeLogScrollPane, fileListScrollPane;
	protected JTextArea changeLogTextArea;
	protected JSpinner major, minor, revision;
	protected int newMajor, newMinor, newRevision;
	protected String changeLog;
	protected Object[] selectedFiles;
	protected JSplitPane splitPane;
	protected ProColFileJList fileList;
	protected boolean isVerticalAlign, floating;
	protected View view;
	protected String position;
	//}}}

	//{{{ Constructors
	/**
	 *  Constructor for the GenericUploadPanel object
	 *
	 *@param  view      View associated with panel, as specified from jEdit
	 *@param  position  Position of panel, as specified from jEdit
	 *@param  type      The type of panel, used when getting stuff from properties
	 *      file
	 */
	public GenericUploadPanel(View view, String position, String type) {
		this.view = view;
		this.position = position;
		this.floating = position.equals(DockableWindowManager.FLOATING);

		// determine if panels should have a vertical or horizontal layout
		if (position.equals(DockableWindowManager.TOP) || position.equals(DockableWindowManager.BOTTOM) || floating) {
			this.isVerticalAlign = false;
		} else {
			this.isVerticalAlign = true;
		}

		setLayout(new java.awt.BorderLayout());

		newInfoPanel = new JPanel();
		newInfoPanel.setLayout(new BorderLayout());
		newInfoPanel.setBorder(new TitledBorder("(" + jEdit.getProperty("procol.client.nofilesselected") + ")"));

		//{{{ Version settings
		versionPanel = new JPanel();
		versionPanel.setLayout(new BoxLayout(versionPanel, javax.swing.BoxLayout.Y_AXIS));
		versionPanel.setBorder(new TitledBorder(jEdit.getProperty("procol.label.newversion")));

		versionInputPanel = new JPanel();
		versionInputPanel.setLayout(new javax.swing.BoxLayout(versionInputPanel, javax.swing.BoxLayout.X_AXIS));

		//int[] versionArray = theFile.getVersionAsArray();

		major = new JSpinner();
		((SpinnerNumberModel)major.getModel()).setMinimum(new Integer(0));
		//major.setValue(new Integer(versionArray[0]));
		major.setToolTipText(jEdit.getProperty("procol.label.majorversion"));

		minor = new JSpinner();
		((SpinnerNumberModel)minor.getModel()).setMinimum(new Integer(0));
		//minor.setValue(new Integer(versionArray[1]));
		minor.setToolTipText(jEdit.getProperty("procol.label.minorversion"));

		revision = new JSpinner();
		((SpinnerNumberModel)revision.getModel()).setMinimum(new Integer(0));
		//revision.setValue(new Integer(versionArray[2]+1));
		revision.setToolTipText(jEdit.getProperty("procol.label.revision"));

		// versionInputPanel.add(Box.createHorizontalGlue());
		versionInputPanel.add(new JLabel("v. "));
		versionInputPanel.add(major);
		versionInputPanel.add(new JLabel(" . "));
		versionInputPanel.add(minor);
		versionInputPanel.add(new JLabel(" . "));
		versionInputPanel.add(revision);
		// versionInputPanel.add(Box.createHorizontalGlue());
		//}}}

		//{{{ Version options
		versionOptionsPanel = new JPanel();
		versionOptionsPanel.setLayout(new javax.swing.BoxLayout(versionOptionsPanel, javax.swing.BoxLayout.X_AXIS));

		versionOptionsButtonGroup = new ButtonGroup();

		incrementRadioButton = new JRadioButton(jEdit.getProperty("procol.label.increment"), true);
		incrementRadioButton.setActionCommand("increment");
		incrementRadioButton.addActionListener(this);

		absoluteRadioButton = new JRadioButton(jEdit.getProperty("procol.label.absolute"), true);
		absoluteRadioButton.setActionCommand("absolute");
		absoluteRadioButton.addActionListener(this);

		noChangeRadioButton = new JRadioButton(jEdit.getProperty("procol.label.nochange"), true);
		noChangeRadioButton.setActionCommand("nochange");
		noChangeRadioButton.addActionListener(this);

		versionOptionsPanel.add(incrementRadioButton);
		versionOptionsPanel.add(absoluteRadioButton);
		versionOptionsPanel.add(noChangeRadioButton);
		versionOptionsButtonGroup.add(incrementRadioButton);
		versionOptionsButtonGroup.add(absoluteRadioButton);
		versionOptionsButtonGroup.add(noChangeRadioButton);

		incrementRadioButton.setSelected(true);
		//}}}

		//{{{ Changelog
		changeLogPanel = new JPanel();
		changeLogPanel.setLayout(new java.awt.BorderLayout());
		changeLogPanel.setBorder(new javax.swing.border.TitledBorder(jEdit.getProperty("procol.label.changelog")));

		changeLogTextArea = new JTextArea();
		changeLogScrollPane = new JScrollPane(changeLogTextArea);
		changeLogTextArea.setLineWrap(true);
		changeLogTextArea.setWrapStyleWord(true);
		//}}}

		//{{{ File list
		fileListPanel = new JPanel();
		fileListPanel.setLayout(new BorderLayout());
		fileListPanel.setBorder(new TitledBorder(jEdit.getProperty("procol.label.files")));
		fileList = new ProColFileJList();
		fileListScrollPane = new JScrollPane(fileList);
		fileList.addListSelectionListener(this);
		//}}}
		fileListPanel.add(fileListScrollPane, java.awt.BorderLayout.CENTER);
		versionPanel.add(versionInputPanel);
		versionPanel.add(versionOptionsPanel);
		newInfoPanel.add(versionPanel, java.awt.BorderLayout.NORTH);
		changeLogPanel.add(changeLogScrollPane, java.awt.BorderLayout.CENTER);
		newInfoPanel.add(changeLogPanel, java.awt.BorderLayout.CENTER);
		if (isVerticalAlign) {
			splitPane = new JSplitPane(javax.swing.JSplitPane.VERTICAL_SPLIT, true, fileListPanel, newInfoPanel);
		} else {
			splitPane = new JSplitPane(javax.swing.JSplitPane.HORIZONTAL_SPLIT, true, fileListPanel, newInfoPanel);
		}
		splitPane.setResizeWeight(0.3);
		add(splitPane, java.awt.BorderLayout.CENTER);
	}
	//}}}

	//{{{ Action/Observer Listeners
	//{{{ actionPerformed
	/**
	 *@param  evt  The ActionEvent event
	 */
	public void actionPerformed(java.awt.event.ActionEvent evt) {
	}
	//}}}

	//{{{ valueChanged(ListSelectionEvent e)
	/**
	 *@param  e  The ListSelectionEvent event
	 */
	public void valueChanged(ListSelectionEvent e) {
	}
	//}}}

	//{{{ update
	/**
	 *@param  o    Observable that called the update
	 *@param  arg  Object argument
	 */
	public void update(Observable o, Object arg) {
	}
	//}}}
	//}}}

	//{{{ Misc methods
	//{{{ validateVersionSpinners
	/**
	 *  Resets the version spinners to the default value, based on the current
	 *  version mode selected
	 */
	protected void validateVersionSpinners() {
		int[] currentVersion  = getMaxSelectedVersion();

		if (incrementRadioButton.isSelected()) {
			setSpinners(0, 0, 0, 0, 1, 1, true);
		} else if (absoluteRadioButton.isSelected()) {
			setSpinners(0, currentVersion[0], 0, currentVersion[1], 0, currentVersion[2] + 1, true);
		} else if (noChangeRadioButton.isSelected()) {
			setSpinners(0, currentVersion[0], 0, currentVersion[1], 0, currentVersion[2], false);
		}
	}
	//}}}

	//{{{ getMaxSelectedVersion
	/**
	 *  Gets the maximum version for all selected files
	 *
	 *@return    int array containing maximium major, minor, and revision values
	 */
	protected int[] getMaxSelectedVersion() {
		int[] currentVersion  = new int[3];
		int[] tempVersion     = new int[3];
		currentVersion[0] = 0;
		currentVersion[1] = 0;
		currentVersion[2] = 0;

		// get highest version from selected files
		for (int i = 0; i < selectedFiles.length; i++) {
			tempVersion = ((DownloadFile)selectedFiles[i]).file.getVersionAsArray();
			for (int j = 0; j < 3; j++) {
				if (tempVersion[j] > currentVersion[j]) {
					currentVersion = ((DownloadFile)selectedFiles[i]).file.getVersionAsArray();
					break;
				} else if (tempVersion[j] < currentVersion[j]) {
					break;
				}
			}
		}
		return currentVersion;
	}
	//}}}

	//{{{ setSpinners
	/**
	 *  Sets the values of the version spinners
	 *
	 *@param  majMin   Minimum major version allowed
	 *@param  majVal   Current value for major version
	 *@param  minMin   Minimum minor version allowed
	 *@param  minVal   Current value for minor version
	 *@param  revMin   Minimum revision version allowed
	 *@param  revVal   Current value for revision version
	 *@param  enabled  Enable spinners?
	 */
	protected void setSpinners(int majMin, int majVal, int minMin, int minVal, int revMin, int revVal, boolean enabled) {
		((SpinnerNumberModel)major.getModel()).setMinimum(new Integer(majMin));
		major.setValue(new Integer(majVal));
		major.setEnabled(enabled);
		((SpinnerNumberModel)minor.getModel()).setMinimum(new Integer(minMin));
		minor.setValue(new Integer(minVal));
		minor.setEnabled(enabled);
		((SpinnerNumberModel)revision.getModel()).setMinimum(new Integer(revMin));
		revision.setValue(new Integer(revVal));
		revision.setEnabled(enabled);
	}
	//}}}
	//}}}
}

