//{{{ GPL Notice
/*
 *  JoinProjectFrame.java
 *  :tabSize=4:indentSize=4:noTabs=false:
 *  :folding=explicit:collapseFolds=1:
 *
 *  part of the ProCol plugin for the jEdit text editor
 *  Copyright (C) 2003-2004 Justin Dieters
 *  enderak@yahoo.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//}}}
package com.enderak.procol.client.gui;

//{{{ Imports
import com.enderak.procol.ProColPlugin;
import com.enderak.procol.common.net.*;
import com.enderak.procol.common.util.ProColUtils;
import java.awt.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.TitledBorder;
import javax.swing.event.*;
import org.gjt.sp.jedit.jEdit;
//}}}

/**
 *  Displays a frame with a list of available projects for the user to join.
 *
 *@author    Justin Dieters
 */
public class JoinProjectFrame extends JFrame {
	private JoinProjectPanel joinProjectPanel;
	//{{{ Constructor

	/**  Constructor for the JoinProjectFrame object */
	public JoinProjectFrame() {
		Toolkit kit           = Toolkit.getDefaultToolkit();
		Dimension screenSize  = kit.getScreenSize();

		setTitle("Join Project");
		getContentPane().add(joinProjectPanel = new JoinProjectPanel(this));
		setSize(400, 300);
		setLocation((screenSize.width / 2) - (getWidth() / 2), (screenSize.height / 2) - (getHeight() / 2));
		setVisible(true);
	}
	//}}}

	/**
	 *  Disposes of the frame and deletes this from the IncomingMesageHandler
	 *  observer list
	 */
	public void dispose() {
		super.dispose();
		ProColPlugin.getClient().getIMH().deleteObserver(joinProjectPanel);
	}


	private class JoinProjectPanel extends JPanel implements Observer {
		//{{{ Data Members
		private JSplitPane splitPane;
		private JEditorPane projectInfo;
		private JScrollPane infoScrollPane;
		private JList projectList;
		private JScrollPane listScrollPane;
		//}}}

		//{{{ Constructors
		/**
		 *@param  parentFrame  Description of the Parameter
		 */
		public JoinProjectPanel(final JoinProjectFrame parentFrame) {
			ProColPlugin.getClient().getIMH().addObserver(this);
			setBorder(new TitledBorder(jEdit.getProperty("procol.client.joinproject.title")));
			projectList = new JList(); // populate project list
			projectList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
			listScrollPane = new JScrollPane(projectList);

			//{{{ Selection listener
			ListSelectionListener selectionListener  =
				new ListSelectionListener() {
					public void valueChanged(ListSelectionEvent e) {
						if (!e.getValueIsAdjusting()) {
							ProColPlugin.getClient().getProjectInfo((String)((JList)(e.getSource())).getSelectedValue());
						}
					}
				};
			//}}}

			projectList.addListSelectionListener(selectionListener);
			projectInfo = new JEditorPane("text/html", jEdit.getProperty("procol.client.joinproject.waiting"));
			projectInfo.setEditable(false);
			infoScrollPane = new JScrollPane(projectInfo);

			//{{{ OK Button
			JButton okButton                         = new JButton(jEdit.getProperty("procol.label.ok"));
			okButton.addActionListener(
				new java.awt.event.ActionListener() {
					public void actionPerformed(java.awt.event.ActionEvent evt) {
						if (projectList.getSelectedValue() != null) {
							ProColPlugin.getClient().joinProject((String)(projectList.getSelectedValue()));
						} else {
							ProColPlugin.getClient().joinProject((String)(projectList.getModel().getElementAt(0)));
						}
						parentFrame.dispose();
					}
				});
			//}}}

			//{{{ Cancel Button
			JButton cancelButton                     = new JButton(jEdit.getProperty("procol.label.cancel"));
			cancelButton.addActionListener(
				new java.awt.event.ActionListener() {
					public void actionPerformed(java.awt.event.ActionEvent evt) {
						if (ProColPlugin.getClient().getProject() == null) {
							ProColPlugin.getClient().disconnect();
						}
						parentFrame.dispose();
					}
				});
			//}}}

			setLayout(new BorderLayout());

			splitPane = new JSplitPane(javax.swing.JSplitPane.HORIZONTAL_SPLIT, true, listScrollPane, infoScrollPane);
			splitPane.setOneTouchExpandable(true);
			splitPane.setResizeWeight(0.5);
			add(splitPane, BorderLayout.CENTER);
			splitPane.setDividerLocation(0.20);

			JPanel buttonPanel                       = new JPanel();
			buttonPanel.add(okButton, BorderLayout.WEST);
			buttonPanel.add(cancelButton, BorderLayout.EAST);
			add(buttonPanel, BorderLayout.SOUTH);

			ProColPlugin.getClient().getProjectList();
		}
		//}}}

		//{{{ update
		/**
		 *@param  o    Observable that called the update
		 *@param  arg  Object argument
		 */
		public void update(Observable o, Object arg) {
			ProColIncomingMessage message  = (ProColIncomingMessage)arg;
			if (message.requestCode == RequestType.PROJECT_LIST) {
				projectList.setListData(ProColUtils.dataStringToVector(message.data));
				projectList.setSelectedIndex(0);
			} else if (message.requestCode == RequestType.PROJECT_INFO) {
				projectInfo.setText(new String(message.data));
			}
		}
		//}}}
	}
}
