//{{{ GPL Notice
/*
 *  LoginFrame.java
 *  :tabSize=4:indentSize=4:noTabs=false:
 *  :folding=explicit:collapseFolds=1:
 *
 *  part of the ProCol plugin for the jEdit text editor
 *  Copyright (C) 2003-2004 Justin Dieters
 *  enderak@yahoo.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//}}}
package com.enderak.procol.client.gui;

//{{{ Imports
import com.enderak.procol.ProColPlugin;
import com.enderak.procol.client.gui.*;
import com.enderak.procol.client.model.*;
import com.enderak.procol.client.net.*;
import com.enderak.procol.common.net.*;
import java.awt.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.TitledBorder;
import org.gjt.sp.jedit.jEdit;
//}}}

/**
 *  Displays a frame for the user to enter thetheir username and password
 *
 *@author    Justin Dieters
 */
public class LoginFrame extends JFrame {
	private LoginPanel panel;

	//{{{ Constructor
	/**
	 *  Constructor for the LoginFrame object
	 *
	 *@param  welcomeMessageIn  Description of the Parameter
	 */
	public LoginFrame(String welcomeMessageIn) {
		Toolkit kit           = Toolkit.getDefaultToolkit();
		Dimension screenSize  = kit.getScreenSize();

		this.setTitle(jEdit.getProperty("procol.client.login.title"));
		this.getContentPane().add(panel = new LoginPanel(this, welcomeMessageIn));
		this.setSize(400, 300);
		this.setLocation((screenSize.width / 2) - (this.getWidth() / 2), (screenSize.height / 2) - (this.getHeight() / 2));
		this.setVisible(true);
	}
	//}}}

	/**
	 *  Disposes of the frame and deletes this from the IncomingMesageHandler
	 *  observer list
	 */
	public void dispose() {
		super.dispose();
		ProColPlugin.getClient().getIMH().deleteObserver(panel);
	}


	private class LoginPanel extends JPanel implements Observer {
		//{{{ Data members
		private JEditorPane projectInfo;
		private JScrollPane scrollPane;
		private LoginFrame parentFrame;
		private JTextField userField          = new JTextField(jEdit.getProperty("options.procol.client.default.user"), 8);
		private JPasswordField passwordField  = new JPasswordField("", 7);
		//}}}

		//{{{ Constructors
		/**
		 *@param  parentFrameIn     Description of the Parameter
		 *@param  welcomeMessageIn  Description of the Parameter
		 */
		public LoginPanel(LoginFrame parentFrameIn, String welcomeMessageIn) {
			parentFrame = parentFrameIn;
			ProColPlugin.getClient().getIMH().addObserver(this);
			this.setLayout(new BorderLayout());
			this.setBorder(new TitledBorder(jEdit.getProperty("procol.client.login.title")));
			projectInfo = new JEditorPane("text/html", welcomeMessageIn);
			projectInfo.setEditable(false);

			scrollPane = new JScrollPane(projectInfo);

			//{{{ Button creation
			// OK Button
			JButton okButton      = new JButton("OK");
			okButton.addActionListener(
				new java.awt.event.ActionListener() {
					public void actionPerformed(java.awt.event.ActionEvent evt) {
						ProColPlugin.getClient().authenticateUser(userField.getText(), new String(passwordField.getPassword()));
					}
				});

			// Cancel Button
			JButton cancelButton  = new JButton("Cancel");
			cancelButton.addActionListener(
				new java.awt.event.ActionListener() {
					public void actionPerformed(java.awt.event.ActionEvent evt) {
						ProColPlugin.getClient().disconnect();
						parentFrame.dispose();
					}
				});
			//}}}

			//{{{ Layout
			Box userpassBox       = Box.createHorizontalBox();
			Box userpassBoxLeft   = Box.createVerticalBox();
			Box userpassBoxRight  = Box.createVerticalBox();
			Box loginBox          = Box.createVerticalBox();

			userpassBoxLeft.add(new JLabel("Username"));
			userpassBoxRight.add(new JLabel("Password"));
			userpassBoxLeft.add(userField);
			userpassBoxRight.add(passwordField);
			userpassBox.add(userpassBoxLeft);
			userpassBox.add(userpassBoxRight);

			JPanel buttonPanel    = new JPanel();
			buttonPanel.add(okButton);
			buttonPanel.add(cancelButton);

			loginBox.add(userpassBox);
			loginBox.add(buttonPanel);

			this.add(scrollPane, BorderLayout.CENTER);
			this.add(loginBox, BorderLayout.SOUTH);

			userField.selectAll();
			//}}}
		}
		//}}}

		//{{{ update
		/**
		 *@param  o    Description of the Parameter
		 *@param  arg  Description of the Parameter
		 */
		public void update(Observable o, Object arg) {
			if (arg instanceof ProColIncomingMessage) {
				ProColClient client            = ProColPlugin.getClient();
				ProColIncomingMessage message  = (ProColIncomingMessage)arg;
				switch (message.requestCode) {
					case RequestType.AUTHENTICATION_OK:
						//{{{
						String username                = new String(message.data);
						client.setUser(new ProColClientUser(username));
						jEdit.setProperty("options.procol.client.default.user", username);
						client.getUser().setAuthenticated(true);
						new JoinProjectFrame();
						ProColClientDockable.proColPanel.stopProgress();
						parentFrame.dispose();
						break;
					//}}}
					case RequestType.USER_ALREADY_LOGGED_IN:
						//{{{
						ProColClientDockable.displayError(jEdit.getProperty("procol.client.error.authentication.title"), new String(message.data) + " " + jEdit.getProperty("procol.client.error.authentication.userloggedin"));
						ProColClientDockable.proColPanel.stopProgress();
						break;
					//}}}
					case RequestType.USER_DOES_NOT_EXIST:
						//{{{
						ProColClientDockable.displayError(jEdit.getProperty("procol.client.error.authentication.title"), new String(message.data) + " " + jEdit.getProperty("procol.client.error.authentication.userdoesnotexist"));
						ProColClientDockable.proColPanel.stopProgress();
						break;
					//}}}
					case RequestType.PASSWORD_FAILED:
						//{{{
						ProColClientDockable.displayError(jEdit.getProperty("procol.client.error.authentication.title"), jEdit.getProperty("procol.client.error.authentication.password"));
						ProColClientDockable.proColPanel.stopProgress();
						break;
					//}}}
					case RequestType.AUTHENTICATION_ERROR:
						//{{{
						ProColClientDockable.displayError(jEdit.getProperty("procol.client.error.authentication.title"), jEdit.getProperty("procol.client.error.undefined"));
						ProColClientDockable.proColPanel.stopProgress();
						break;
					//}}}
					default:
				}
			}
		}
		//}}}
	}
}
