//{{{ GPL Notice
/*
 *  PrivateMessageComposer.java
 *  :tabSize=4:indentSize=4:noTabs=false:
 *  :folding=explicit:collapseFolds=1:
 *
 *  part of the ProCol plugin for the jEdit text editor
 *  Copyright (C) 2003-2004 Justin Dieters
 *  enderak@yahoo.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//}}}
package com.enderak.procol.client.gui;

//{{{ Imports
import com.enderak.procol.ProColPlugin;
import com.enderak.procol.common.net.*;
import java.awt.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.TitledBorder;
import org.gjt.sp.jedit.jEdit;
//}}}

/**
 *  Dialog to create or reply to a private message
 *
 *@author    Justin Dieters
 */
public class PrivateMessageComposer extends JFrame {
	private PrivateMessageComposerPanel panel;

	//{{{ Constructor
	/**
	 *  Constructor for the PrivateMessageComposer object
	 *
	 *@param  replyTo         Private message ID replying to, "null" if new message
	 *@param  replyToUser     User to send message to, "null" if no predefined
	 *      recipient
	 *@param  replySubjectIn  Subject of message, "(No Subject)" if no predefined
	 *      subject
	 *@param  userList        List of available recipients
	 */
	public PrivateMessageComposer(String replyTo, String replyToUser, String replySubjectIn, Vector userList) {
		Toolkit kit           = Toolkit.getDefaultToolkit();
		Dimension screenSize  = kit.getScreenSize();

		this.setTitle(jEdit.getProperty("procol.client.messagecomposer.private.title"));
		this.getContentPane().add(panel = new PrivateMessageComposerPanel(this, replyTo, replyToUser, replySubjectIn, userList));
		this.setSize(400, 300);
		this.setLocation((screenSize.width / 2) - (this.getWidth() / 2), (screenSize.height / 2) - (this.getHeight() / 2));
		this.setVisible(true);
	}
	//}}}

	private class PrivateMessageComposerPanel extends JPanel {

		//{{{ Data Members
		private JTextArea messageInput;
		private JScrollPane scrollPane;
		private JTextField subjectInput;
		private JList userList;
		//}}}

		//{{{ Constructors
		/**
		 *@param  parentFrame     Description of the Parameter
		 *@param  replyTo         Description of the Parameter
		 *@param  replyToUser     Description of the Parameter
		 *@param  replySubjectIn  Description of the Parameter
		 *@param  userListIn      Description of the Parameter
		 */
		public PrivateMessageComposerPanel(final PrivateMessageComposer parentFrame, final String replyTo, final String replyToUser, final String replySubjectIn, final Vector userListIn) {
			// this.setBorder(new TitledBorder(jEdit.getProperty("procol.client.messagecomposer.private.title")));
			subjectInput = new JTextField();
			subjectInput.setText(replySubjectIn);
			subjectInput.selectAll();
			messageInput = new JTextArea();
			messageInput.setLineWrap(true);
			messageInput.setWrapStyleWord(true);
			userList = new JList(userListIn);
			userList.setSelectedValue(replyToUser, true);
			scrollPane = new JScrollPane(messageInput);

			// Send Button
			JButton sendButton        = new JButton(jEdit.getProperty("procol.label.send"));
			sendButton.addActionListener(
				new java.awt.event.ActionListener() {
					public void actionPerformed(java.awt.event.ActionEvent evt) {
						Object[] recipients  = userList.getSelectedValues();
						if (recipients.length == 0) {
							ProColClientDockable.displayInfo("Select Recpipient", "At least one recipient must be selected!");
							return;
						}
						for (int i = 0; i < recipients.length; i++) {
							String messageTo  = (String)recipients[i];
							ProColPlugin.getClient().getPacketFactory().addToQueue(RequestType.PRIVATE_MESSAGE_ADD, messageTo + "\n" + replyTo + "\n" + subjectInput.getText() + "\n" + messageInput.getText(), PacketFactory.NORMAL_PRIORITY);
						}
						parentFrame.dispose();
					}
				});
			// Cancel Button
			JButton cancelButton      = new JButton(jEdit.getProperty("procol.label.cancel"));
			cancelButton.addActionListener(
				new java.awt.event.ActionListener() {
					public void actionPerformed(java.awt.event.ActionEvent evt) {
						parentFrame.dispose();
					}
				});

			this.setLayout(new BorderLayout());

			JPanel subjectInputPanel  = new JPanel();
			subjectInputPanel.setLayout(new BorderLayout());
			subjectInputPanel.add(subjectInput, BorderLayout.CENTER);
			subjectInputPanel.setBorder(new TitledBorder(jEdit.getProperty("procol.client.messagecomposer.subject")));
			this.add(subjectInputPanel, BorderLayout.NORTH);

			JPanel messageInputPanel  = new JPanel();
			messageInputPanel.setLayout(new BorderLayout());
			messageInputPanel.add(scrollPane, BorderLayout.CENTER);
			messageInputPanel.setBorder(new TitledBorder(jEdit.getProperty("procol.client.messagecomposer.message")));
			this.add(messageInputPanel, BorderLayout.CENTER);

			JPanel userListPanel      = new JPanel();
			userListPanel.setLayout(new BorderLayout());
			userListPanel.add(userList, BorderLayout.CENTER);
			userListPanel.setBorder(new TitledBorder(jEdit.getProperty("procol.client.messagecomposer.users")));
			this.add(userListPanel, BorderLayout.WEST);

			JPanel buttonPanel        = new JPanel();
			buttonPanel.add(sendButton);
			buttonPanel.add(cancelButton);
			this.add(buttonPanel, BorderLayout.SOUTH);
			ProColPlugin.getClient().getProjectInfo();
		}
		//}}}

	}
}
