//{{{ GPL Notice
/*
 *  ProColTree.java
 *  :tabSize=4:indentSize=4:noTabs=false:
 *  :folding=explicit:collapseFolds=1:
 *
 *  part of the ProCol plugin for the jEdit text editor
 *  Copyright (C) 2003-2004 Justin Dieters
 *  enderak@yahoo.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//}}}
package com.enderak.procol.client.gui;

//{{{ Imports
import com.enderak.procol.common.model.*;
import java.awt.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.tree.*;
//}}}

/**
 *  Overrides the default JTree to display checked-out files in bold and
 *  associate a tooltip with that item
 *
 *@author    Justin Dieters
 */
public class ProColTree extends JTree {
	/**  Constructor for the ProColTree object */
	public ProColTree() {
		super();
		this.setCellRenderer(new ProColTreeCellRenderer());
		ToolTipManager.sharedInstance().registerComponent(this);
	}


	private class ProColTreeCellRenderer extends DefaultTreeCellRenderer {
		private Font plain, bold, italic;


		/** */
		public ProColTreeCellRenderer() {
			super();
		}


		/**
		 *@param  tree      The associated JTree
		 *@param  value     The value selected
		 *@param  sel       is selected?
		 *@param  expanded  is expanded?
		 *@param  leaf      is leaf?
		 *@param  row       row of selected item
		 *@param  hasFocus  has focus?
		 *@return
		 */
		public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
			super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
			DefaultMutableTreeNode tempNode  = (DefaultMutableTreeNode)value;

			if (plain == null) {
				plain = getFont();
				if (plain != null) {
					bold = plain.deriveFont(Font.BOLD);
					italic = plain.deriveFont(Font.ITALIC);
				}
			}

			if (tempNode != null && tempNode.getUserObject() instanceof ProColFile) {
				String owner  = ((ProColFile)(tempNode.getUserObject())).getOwner();

				if (owner == null) {
					setFont(plain);
					setToolTipText(null);
				} else {
					setFont(bold);
					setToolTipText("Owner: " + owner);
				}
			}
			return this;
		}
	}
}
