//{{{ GPL Notice
/*
 *  ProjectInfoFrame.java
 *  :tabSize=4:indentSize=4:noTabs=false:
 *  :folding=explicit:collapseFolds=1:
 *
 *  part of the ProCol plugin for the jEdit text editor
 *  Copyright (C) 2003-2004 Justin Dieters
 *  enderak@yahoo.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//}}}
package com.enderak.procol.client.gui;

//{{{ Imports
import com.enderak.procol.ProColPlugin;
import com.enderak.procol.common.net.*;
import java.awt.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.TitledBorder;
import org.gjt.sp.jedit.jEdit;
//}}}

/**
 *  Displays a dialog with info about a project
 *
 *@author    Justin Dieters
 */
public class ProjectInfoFrame extends JFrame {
	private ProjectInfoPanel panel;

	//{{{ Constructor
	/**  Constructor for the ProjectInfoFrame object */
	public ProjectInfoFrame() {
		Toolkit kit           = Toolkit.getDefaultToolkit();
		Dimension screenSize  = kit.getScreenSize();

		this.setTitle(jEdit.getProperty("procol.client.projectinfo.title"));
		this.getContentPane().add(panel = new ProjectInfoPanel(this));
		this.setSize(400, 300);
		this.setLocation((screenSize.width / 2) - (this.getWidth() / 2), (screenSize.height / 2) - (this.getHeight() / 2));
		this.setVisible(true);
	}
	//}}}

	/**
	 *  Disposes of the frame and deletes this from the IncomingMesageHandler
	 *  observer list
	 */
	public void dispose() {
		super.dispose();
		ProColPlugin.getClient().getIMH().deleteObserver(panel);
	}


	private class ProjectInfoPanel extends JPanel implements Observer {
		//{{{ Data Members
		private JEditorPane projectInfo;
		private JScrollPane scrollPane;
		//}}}

		//{{{ Constructor
		/**
		 *  Constructor for the ProjectInfoPanel object
		 *
		 *@param  parentFrame  Description of the Parameter
		 */
		public ProjectInfoPanel(final ProjectInfoFrame parentFrame) {
			ProColPlugin.getClient().getIMH().addObserver(this);
			this.setBorder(new TitledBorder(jEdit.getProperty("procol.client.projectinfo.title")));
			projectInfo = new JEditorPane("text/html", jEdit.getProperty("procol.client.projectinfo.gettinginfo"));
			projectInfo.setEditable(false);

			scrollPane = new JScrollPane(projectInfo);

			// OK Button
			JButton okButton    = new JButton(jEdit.getProperty("procol.label.ok"));
			okButton.addActionListener(
				new java.awt.event.ActionListener() {
					public void actionPerformed(java.awt.event.ActionEvent evt) {
						parentFrame.dispose();
					}
				});

			this.setLayout(new BorderLayout());
			this.add(scrollPane, BorderLayout.CENTER);
			JPanel buttonPanel  = new JPanel();
			buttonPanel.add(okButton, BorderLayout.CENTER);
			this.add(buttonPanel, BorderLayout.SOUTH);
			ProColPlugin.getClient().getProjectInfo();
		}
		//}}}

		//{{{ update
		/**
		 *@param  o    Observable that called the update
		 *@param  arg  Object argument
		 */
		public void update(Observable o, Object arg) {
			if (arg instanceof ProColIncomingMessage) {
				if (((ProColIncomingMessage)arg).requestCode == RequestType.PROJECT_INFO) {
					projectInfo.setText(new String(((ProColIncomingMessage)arg).data));
				}
			}
		}
		//}}}
	}
}
