//{{{ GPL Notice
/*
 *  PublicMessageComposer.java
 *  :tabSize=4:indentSize=4:noTabs=false:
 *  :folding=explicit:collapseFolds=1:
 *
 *  part of the ProCol plugin for the jEdit text editor
 *  Copyright (C) 2003-2004 Justin Dieters
 *  enderak@yahoo.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//}}}
package com.enderak.procol.client.gui;

//{{{ Imports
import com.enderak.procol.ProColPlugin;
import com.enderak.procol.common.net.*;
import java.awt.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.TitledBorder;
import org.gjt.sp.jedit.jEdit;
//}}}

/**
 *  Dialog to create or reply to a public message
 *
 *@author    Justin Dieters
 */
public class PublicMessageComposer extends JFrame {
	private PublicMessageComposerPanel panel;

	//{{{ Constructor
	/**
	 *  Constructor for the PublicMessageComposer object
	 *
	 *@param  replyTo    Private message ID replying to, "null" if new message
	 *@param  subjectIn  Subject of message, "(No Subject)" if no predefined
	 *      subject
	 */
	public PublicMessageComposer(String replyTo, String subjectIn) {
		Toolkit kit           = Toolkit.getDefaultToolkit();
		Dimension screenSize  = kit.getScreenSize();

		this.setTitle(jEdit.getProperty("procol.client.messagecomposer.public.title"));
		this.getContentPane().add(panel = new PublicMessageComposerPanel(this, replyTo, subjectIn));
		this.setSize(400, 300);
		this.setLocation((screenSize.width / 2) - (this.getWidth() / 2), (screenSize.height / 2) - (this.getHeight() / 2));
		this.setVisible(true);
	}
	//}}}

	private class PublicMessageComposerPanel extends JPanel {
		//{{{ Data Members
		private JTextArea messageInput;
		private JScrollPane scrollPane;
		private JTextField subjectInput;
		//}}}

		//{{{ Constructors
		/**
		 *  Constructor for the PublicMessageComposerPanel object
		 *
		 *@param  parentFrame     The parent of this panel
		 *@param  replyTo         Private message ID replying to, "null" if new
		 *      message
		 *@param  replySubjectIn  Subject of message, "(No Subject)" if no predefined
		 *      subject
		 */
		public PublicMessageComposerPanel(final PublicMessageComposer parentFrame, final String replyTo, final String replySubjectIn) {
			// this.setBorder(new TitledBorder(jEdit.getProperty("procol.client.messagecomposer.public.title")));
			subjectInput = new JTextField();
			subjectInput.setText(replySubjectIn);
			subjectInput.selectAll();
			messageInput = new JTextArea();
			messageInput.setLineWrap(true);
			messageInput.setWrapStyleWord(true);
			scrollPane = new JScrollPane(messageInput);

			// Send Button
			JButton sendButton        = new JButton(jEdit.getProperty("procol.label.send"));
			sendButton.addActionListener(
				new java.awt.event.ActionListener() {
					public void actionPerformed(java.awt.event.ActionEvent evt) {
						ProColPlugin.getClient().getPacketFactory().addToQueue(RequestType.PUBLIC_MESSAGE_ADD, replyTo + "\n" + subjectInput.getText() + "\n" + messageInput.getText(), PacketFactory.NORMAL_PRIORITY);
						parentFrame.dispose();
					}
				});
			// Cancel Button
			JButton cancelButton      = new JButton(jEdit.getProperty("procol.label.cancel"));
			cancelButton.addActionListener(
				new java.awt.event.ActionListener() {
					public void actionPerformed(java.awt.event.ActionEvent evt) {
						parentFrame.dispose();
					}
				});

			this.setLayout(new BorderLayout());

			JPanel subjectInputPanel  = new JPanel();
			subjectInputPanel.setLayout(new BorderLayout());
			subjectInputPanel.add(subjectInput, BorderLayout.CENTER);
			subjectInputPanel.setBorder(new TitledBorder(jEdit.getProperty("procol.client.messagecomposer.subject")));
			this.add(subjectInputPanel, BorderLayout.NORTH);

			JPanel messageInputPanel  = new JPanel();
			messageInputPanel.setLayout(new BorderLayout());
			messageInputPanel.add(scrollPane, BorderLayout.CENTER);
			messageInputPanel.setBorder(new TitledBorder(jEdit.getProperty("procol.client.messagecomposer.message")));
			this.add(messageInputPanel, BorderLayout.CENTER);

			JPanel buttonPanel        = new JPanel();
			buttonPanel.add(sendButton);
			buttonPanel.add(cancelButton);
			this.add(buttonPanel, BorderLayout.SOUTH);
			ProColPlugin.getClient().getProjectInfo();
		}
		//}}}

	}
}
