//{{{ GPL Notice
/*
 *  UserPanel.java
 *  :tabSize=4:indentSize=4:noTabs=false:
 *  :folding=explicit:collapseFolds=1:
 *
 *  part of the ProCol plugin for the jEdit text editor
 *  Copyright (C) 2003-2004 Justin Dieters
 *  enderak@yahoo.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//}}}
package com.enderak.procol.client.gui;

//{{{ Imports
import com.enderak.procol.*;
import com.enderak.procol.common.gui.*;
import java.awt.BorderLayout;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.TitledBorder;
import javax.swing.event.*;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.jEdit;
//}}}

/**
 *  The panel which displays the user list and associated elements
 *
 *@author    Justin Dieters
 */
public class UserPanel extends JPanel implements ActionListener {
//{{{ Data members
	private ButtonPanel userButtonPanel;
	private JScrollPane userScrollPane;
	private JList userList;
	private RolloverOnOffButton privateMessageButton, publicMessageButton, calendarButton, todoListButton, bugListButton;
	//}}}

//{{{ Constructor
	/**
	 *  Constructor for the UserPanel object
	 *
	 *@param  isVerticalAlign  True if vertically aligned (floating or docked
	 *      left/right), false otherwise
	 */
	public UserPanel(boolean isVerticalAlign) {
		super();

		this.setLayout(new BorderLayout());
		this.setBorder(new TitledBorder(jEdit.getProperty("procol.client.users.toplabel")));

		userButtonPanel = new ButtonPanel(isVerticalAlign);
		userScrollPane = new javax.swing.JScrollPane();
		userList = new javax.swing.JList();

		MouseListener mouseListener  =
			new MouseAdapter() {
				public void mouseClicked(MouseEvent e) {
					int index  = userList.locationToIndex(e.getPoint());
					userList.setSelectedIndex(index);
					if (e.getButton() == MouseEvent.BUTTON3) {
						String userSelected  = (String)(userList.getModel().getElementAt(index));
						new UserPopupMenu(userSelected).show((JComponent)e.getSource(), e.getX(), e.getY());
					}
				}
			};
		userList.addMouseListener(mouseListener);

		userScrollPane.setViewportView(userList);

		this.add(userScrollPane, java.awt.BorderLayout.CENTER);

		//{{{ Button creation
		//{{{ Private Messages
		privateMessageButton = userButtonPanel.createRolloverOnOffButton("privatemessages");
		privateMessageButton.addActionListener(this);
		//}}}

		//{{{ Message Board
		publicMessageButton = userButtonPanel.createRolloverOnOffButton("publicmessages");
		publicMessageButton.addActionListener(this);
		//}}}

		//{{{ Todo List
		todoListButton = userButtonPanel.createRolloverOnOffButton("todolist");
		todoListButton.addActionListener(this);
		//}}}

		//{{{ Bug List
		bugListButton = userButtonPanel.createRolloverOnOffButton("buglist");
		bugListButton.addActionListener(this);
		//}}}

		//{{{ Calendar
		// calendarButton = userButtonPanel.createRolloverOnOffButton("calendar");
		// calendarButton.addActionListener(this);
		//}}}
		//}}}

		if (isVerticalAlign) {
			this.add(userButtonPanel, java.awt.BorderLayout.SOUTH);
		} else {
			this.add(userButtonPanel, java.awt.BorderLayout.EAST);
		}
	}
	//}}}

//{{{ Modifier methods
	//{{{ setConnected
	/**
	 *  Sets the connected status of the ProjectPanel
	 *
	 *@param  isConnected  The new connected value
	 */
	public void setConnected(boolean isConnected) {
		privateMessageButton.setEnabled(isConnected);
		publicMessageButton.setEnabled(isConnected);
		todoListButton.setEnabled(isConnected);
		bugListButton.setEnabled(isConnected);
		// calendarButton.setEnabled(isConnected);
		System.out.println(isConnected);
		if (isConnected) {
			if (jEdit.getActiveView().getDockableWindowManager().getDockableWindow("procol.client.dockable.privatemessages") != null) {
				System.out.println("procol.client.dockable.privatemessages");
				((PrivateMessagePanel)jEdit.getActiveView().getDockableWindowManager().getDockableWindow("procol.client.dockable.privatemessages")).initNetworkCommunication();
			}
			if (jEdit.getActiveView().getDockableWindowManager().getDockableWindow("procol.client.dockable.publicmessages") != null) {
				System.out.println("procol.client.dockable.publicmessages");
				((PublicMessagePanel)jEdit.getActiveView().getDockableWindowManager().getDockableWindow("procol.client.dockable.publicmessages")).initNetworkCommunication();
			}
			if (jEdit.getActiveView().getDockableWindowManager().getDockableWindow("procol.client.dockable.todolist") != null) {
				((TodoListPanel)jEdit.getActiveView().getDockableWindowManager().getDockableWindow("procol.client.dockable.todolist")).initNetworkCommunication();
			}
			if (jEdit.getActiveView().getDockableWindowManager().getDockableWindow("procol.client.dockable.buglist") != null) {
				((BugListPanel)jEdit.getActiveView().getDockableWindowManager().getDockableWindow("procol.client.dockable.buglist")).initNetworkCommunication();
			}
			// if (jEdit.getActiveView().getDockableWindowManager().getDockableWindow("procol.client.dockable.calendar") != null) {
			// ((CalendarPanel)jEdit.getActiveView().getDockableWindowManager().getDockableWindow("procol.client.dockable.calendar")).initNetworkCommunication();
			// }
		} else {
			setUserList(new Vector()); // empty user list

			// if (jEdit.getActiveView().getDockableWindowManager().getDockableWindow("procol.client.dockable.privatemessages") != null) {
			// System.out.println("procol.client.dockable.privatemessages");
			// ((PrivateMessagePanel)jEdit.getActiveView().getDockableWindowManager().getDockableWindow("procol.client.dockable.privatemessages")).stopNetworkCommunication();
			// }
			// if (jEdit.getActiveView().getDockableWindowManager().getDockableWindow("procol.client.dockable.publicmessages") != null) {
			// System.out.println("procol.client.dockable.publicmessages");
			// ((PublicMessagePanel)jEdit.getActiveView().getDockableWindowManager().getDockableWindow("procol.client.dockable.publicmessages")).stopNetworkCommunication();
			// }
			// if (jEdit.getActiveView().getDockableWindowManager().getDockableWindow("procol.client.dockable.todolist") != null) {
			// ((TodoListPanel)jEdit.getActiveView().getDockableWindowManager().getDockableWindow("procol.client.dockable.todolist")).initNetworkCommunication();
			// }
			// if (jEdit.getActiveView().getDockableWindowManager().getDockableWindow("procol.client.dockable.buglist") != null) {
			// ((BugListPanel)jEdit.getActiveView().getDockableWindowManager().getDockableWindow("procol.client.dockable.buglist")).initNetworkCommunication();
			// }
			// if (jEdit.getActiveView().getDockableWindowManager().getDockableWindow("procol.client.dockable.calendar") != null) {
			// ((CalendarPanel)jEdit.getActiveView().getDockableWindowManager().getDockableWindow("procol.client.dockable.calendar")).initNetworkCommunication();
			// }
		}
	}
	//}}}

	//{{{ setUserList
	/**
	 *  Sets the user list within the panel
	 *
	 *@param  usersIn  the new list
	 */
	public void setUserList(Vector usersIn) {
		Collections.sort(usersIn);
		userList.setListData(usersIn);
	}
	//}}}

	//{{{ newPrivateMessage
	/**  Turns on the private message indicator */
	public void newPrivateMessage() {
		if (!jEdit.getActiveView().getDockableWindowManager().isDockableWindowVisible("procol.client.dockable.privatemessages")) {
			privateMessageButton.turnOn();
		}
	}
	//}}}

	//{{{ newPublicMessage
	/**  Turns on the public message indicator */
	public void newPublicMessage() {
		if (!jEdit.getActiveView().getDockableWindowManager().isDockableWindowVisible("procol.client.dockable.publicmessages")) {
			publicMessageButton.turnOn();
		}
	}
	//}}}

	//{{{ todoListItem
	/**  Turns on the todo list indicator */
	public void newTodoListItem() {
		if (!jEdit.getActiveView().getDockableWindowManager().isDockableWindowVisible("procol.client.dockable.todolist")) {
			todoListButton.turnOn();
		}
	}
	//}}}

	//{{{ newBugListItem
	/**  Turns on the bug list indicator */
	public void newBugListItem() {
		if (!jEdit.getActiveView().getDockableWindowManager().isDockableWindowVisible("procol.client.dockable.buglist")) {
			bugListButton.turnOn();
		}
	}
	//}}}

	//{{{ newCalendarItem
	// public void newCalendarItem() {
	// if (!jEdit.getActiveView().getDockableWindowManager().isDockableWindowVisible("procol.client.dockable.calendar")) {
	// calendarButton.turnOn();
	// }
	// }
	//}}}
//}}}

//{{{ Action methods
	//{{{ actionPerformed
	/**
	 *  Responds to buttons pressed in this panel
	 *
	 *@param  e  The action event
	 */
	public void actionPerformed(java.awt.event.ActionEvent e) {
		String actionCommand                         = e.getActionCommand();
		String dockable                              = "procol.client.dockable." + actionCommand;
		DockableWindowManager dockableWindowManager  = jEdit.getActiveView().getDockableWindowManager();

		if (!dockableWindowManager.isDockableWindowVisible(dockable)) {
			dockableWindowManager.showDockableWindow(dockable);
		} else {
			dockableWindowManager.hideDockableWindow(dockable);
		}

		((RolloverOnOffButton)(e.getSource())).turnOff();

		if (actionCommand.equals("privatemessages")) {
			if (ProColPlugin.getClient().isConnected()) {
				((PrivateMessagePanel)(dockableWindowManager.getDockableWindow(dockable))).initNetworkCommunication();
			}
		} else if (actionCommand.equals("publicmessages")) {
			if (ProColPlugin.getClient().isConnected()) {
				((PublicMessagePanel)(dockableWindowManager.getDockableWindow(dockable))).initNetworkCommunication();
			}
		} else if (actionCommand.equals("todolist")) {
			if (ProColPlugin.getClient().isConnected()) {
				((TodoListPanel)(dockableWindowManager.getDockableWindow(dockable))).initNetworkCommunication();
			}
		} else if (actionCommand.equals("buglist")) {
			if (ProColPlugin.getClient().isConnected()) {
				((BugListPanel)(dockableWindowManager.getDockableWindow(dockable))).initNetworkCommunication();
			}
			// } else if (actionCommand.equals("calendar")) {
			// if (ProColPlugin.getClient().isConnected()) {
			// ((CalendarPanel)(dockableWindowManager.getDockableWindow(dockable))).initNetworkCommunication();
			// }
		}
	}
	//}}}
//}}}

	/**
	 *  Generates a popup menu based on selected user
	 *
	 *@author    Justin Dieters
	 */
	private class UserPopupMenu extends JPopupMenu {
//{{{ Data members
		private MenuHandler menuHandler  = new MenuHandler();
		private String userSelected;
//}}}

//{{{ Constructors
		/**
		 *  Constructor for the UserPopupMenu object
		 *
		 *@param  userSelectedIn  The username selected
		 */
		public UserPopupMenu(String userSelectedIn) {
			this.userSelected = userSelectedIn;
			add(createMenuItem("privatemessages"));
			add(createMenuItem("userinfo"));
			// addSeparator();
		}
//}}}

//{{{ Misc. Methods
		//{{{ createMenuItem
		private JMenuItem createMenuItem(String name) {
			JMenuItem tempMenuItem  = new JMenuItem(jEdit.getProperty("procol.client." + name + ".label"));
			tempMenuItem.setActionCommand(name);
			tempMenuItem.addActionListener(menuHandler);
			return tempMenuItem;
		}
		//}}}
//}}}

//{{{ ActionHandler class
		private class MenuHandler implements ActionListener {
			//{{{ actionPerformed
			/**
			 *@param  evt  Description of the Parameter
			 */
			public void actionPerformed(ActionEvent evt) {
				String actionCommand  = evt.getActionCommand();
				if (actionCommand.equals("privatemessages")) {
					Vector tempVector  = new Vector();
					tempVector.add(userSelected);
					new PrivateMessageComposer("null", userSelected, "(No Subject)", tempVector);
				} else if (actionCommand.equals("userinfo")) {
					ProColPlugin.getClient().getUserInfo(userSelected);
				}
			} //}}}
		}
//}}}
	}
}
