//{{{ GPL Notice
/*
 *  PrivateMessage.java
 *  :tabSize=4:indentSize=4:noTabs=false:
 *  :folding=explicit:collapseFolds=1:
 *
 *  part of the ProCol plugin for the jEdit text editor
 *  Copyright (C) 2003-2004 Justin Dieters
 *  enderak@yahoo.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//}}}
package com.enderak.procol.client.model;

//{{{ Imports
//}}}

/**
 *  Container class for private message data
 *
 *@author    enderak
 */
public class PrivateMessage {
	//{{{ Data members
	/** */
	public String index    = "null";
	/** */
	public String sender   = "null";
	/** */
	public String date     = "null";
	/** */
	public String subject  = "null";
	/** */
	public String message  = "null";
	//}}}

	//{{{ Constructors
	/**
	 *@param  indexIn    Description of the Parameter
	 *@param  subjectIn  Description of the Parameter
	 *@param  dateIn     Description of the Parameter
	 *@param  senderIn   Description of the Parameter
	 */
	public PrivateMessage(String indexIn, String dateIn, String subjectIn, String senderIn) {
		index = indexIn;
		subject = subjectIn;
		date = dateIn;
		sender = senderIn;
	}
	//}}}

	//{{{ toString
	/**
	 *@return    The private message in a form to display in a list
	 */
	public String toString() {
		if (subject != null) {
			return date + " :: \"" + subject + "\" from " + sender;
		} else {
			return "null";
		}
	}
	//}}}
}
