//{{{ GPL Notice
/*
 *  TodoItem.java
 *  :tabSize=4:indentSize=4:noTabs=false:
 *  :folding=explicit:collapseFolds=1:
 *
 *  part of the ProCol plugin for the jEdit text editor
 *  Copyright (C) 2003-2004 Justin Dieters
 *  enderak@yahoo.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//}}}
package com.enderak.procol.client.model;

/**
 *  Container class for todo item data
 *
 *@author    Justin Dieters
 */
public class TodoItem {
	//{{{ Data members
	/** */
	public String index        = "null";
	/** */
	public String dueDate      = "null";
	/** */
	public String subject      = "null";
	/** */
	public String priority     = "null";
	/** */
	public String complete     = "null";
	/** */
	public String assignedTo   = "null";
	/** */
	public String description  = "null";
	//}}}

	//{{{ Constructors
	/**
	 *@param  indexIn       Index of the item
	 *@param  subjectIn     Subject of the item
	 *@param  dueDateIn     Due date of the item
	 *@param  priorityIn    Priority of the item of the item
	 *@param  completeIn    Completeness of the item
	 *@param  assignedToIn  Assigned user of the item
	 */
	public TodoItem(String indexIn, String subjectIn, String dueDateIn, String priorityIn, String completeIn, String assignedToIn) {
		index = indexIn;
		subject = subjectIn;
		dueDate = dueDateIn;
		priority = priorityIn;
		complete = completeIn;
		assignedTo = assignedToIn;
	}
	//}}}

	//{{{ toString
	/**
	 *@return    The todo item in a form to display in a list
	 */
	public String toString() {
		if (subject != null) {
			return subject + " :: Due: " + dueDate;
		} else {
			return "null";
		}
	}
	//}}}
}

