//{{{ GPL Notice
/*
 *  ClientErrorHandler.java
 *  :tabSize=4:indentSize=4:noTabs=false:
 *  :folding=explicit:collapseFolds=1:
 *
 *  part of the ProCol plugin for the jEdit text editor
 *  Copyright (C) 2003-2004 Justin Dieters
 *  enderak@yahoo.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//}}}
package com.enderak.procol.client.util;

//{{{ Imports
import com.enderak.procol.client.gui.*;
import com.enderak.procol.client.net.*;
import com.enderak.procol.common.net.*;
import com.enderak.procol.common.util.*;
//}}}

/**
 *  Handles error messages received from the server
 *
 *@author    Justin Dieters
 */
public class ClientErrorHandler extends ErrorHandler {
	//{{{ Data members
	ProColClient client;
	//}}}

	//{{{ Constructor
	/**
	 *  Create the ClientErrorHandler
	 *
	 *@param  clientIn  The client this handler is associated
	 */
	public ClientErrorHandler(ProColClient clientIn) {
		super();
		client = clientIn;
	}
	//}}}

	//{{{ handleMessage
	/**
	 *  Handles the error message
	 *
	 *@param  message  The message
	 */
	public void handleMessage(ProColIncomingMessage message) {
		if (message == null) {
			return;
		}
		//System.out.println("Handling error message: " + message.toString());
		switch (message.requestCode) {
			case RequestType.PROTOCOL_TOO_OLD:
				//{{{
				ProColClientDockable.displayError("Connection Failed", "The server does not support your client because it uses an old communication protocol.\nPlease upgrade to a newer client.\nServer protocol: " + new String(message.data) + "\nClient protocol: " + RequestType.PROTOCOL_VERSION);
				client.close();
				break;
			//}}}
			case RequestType.PROTOCOL_TOO_NEW:
				//{{{
				ProColClientDockable.displayError("Connection Failed", "The server does not support your client because it uses a new communication protocol.\nPlease use an older client, or contact the server administrator to upgrade\nto a newer version of the ProCol server.\nServer protocol: " + new String(message.data) + "\nClient protocol: " + RequestType.PROTOCOL_VERSION);
				client.close();
				break;
			//}}}
			case RequestType.CHECK_OUT_ALREADY_CHECKED_OUT:
				//{{{
				ProColClientDockable.displayError("Checkout Error", "File is already checked out by " + new String(message.data) + "!");
				ProColClientDockable.proColPanel.stopProgress();
				break;
			//}}}
			case RequestType.CHECK_OUT_FILE_NOT_FOUND:
				//{{{
				ProColClientDockable.displayError("Checkout Error", "File was not found on server!");
				ProColClientDockable.proColPanel.stopProgress();
				break;
			//}}}
			case RequestType.INVALID:
				//{{{
				ProColClientDockable.displayInfo("Invalid Message", new String("Server encountered an error handling message: " + new String(message.data)));
				break;
			//}}}
			default:
				ProColClientDockable.displayInfo("Unknown error", new String("Unknown error message: " + message));
		}
	}
	//}}}
}
