//{{{ GPL Notice
/*
 *  ProColProgressBar.java
 *  :tabSize=4:indentSize=4:noTabs=false:
 *  :folding=explicit:collapseFolds=1:
 *
 *  part of the ProCol plugin for the jEdit text editor
 *  Copyright (C) 2003-2004 Justin Dieters
 *  enderak@yahoo.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//}}}

package com.enderak.procol.common.gui;

import javax.swing.*;

/**
 *  A network progress bar for use with ProCol
 *
 *@author    Justin Dieters
 */
public class ProColProgressBar extends JProgressBar {
	private String progressString  = "";


	/**  Creates a new progress bar */
	public ProColProgressBar() {
		super();
		setString("");
		setStringPainted(true);
		progressString = "";
	}


	/**  Sets progress bar indeterminate and starts it */
	public void startProgress() {
		setIndeterminate(true);
	}


	/**
	 *  Sets progress bar indeterminate and starts it along with a message
	 *
	 *@param  message  The message
	 */
	public void startProgress(String message) {
		setIndeterminate(true);
		progressString = message;
		setString(progressString);
	}


	/**
	 *  Sets progress bar min and max and sets the value to the min
	 *
	 *@param  min  Minimum value for the bar
	 *@param  max  Maximum value for the bar
	 */
	public void startProgress(int min, int max) {
		setIndeterminate(false);
		setMinimum(min);
		setMaximum(max);
		setProgress(min);
	}


	/**
	 *  Sets progress bar min and max and sets the value to the min, along with a
	 *  message
	 *
	 *@param  min      Minimum value for the bar
	 *@param  max      Maximum value for the bar
	 *@param  message  The message
	 */
	public void startProgress(int min, int max, String message) {
		setIndeterminate(false);
		setMinimum(min);
		setMaximum(max);
		progressString = message;
		setProgress(min, progressString);
	}


	/**  Stops the progres bar */
	public void stopProgress() {
		progressString = "";
		setProgress(0);
		setString(progressString);
		setIndeterminate(false);
	}


	/**
	 *  Sets the bar's value to a specific amount
	 *
	 *@param  amount  The new value
	 */
	public void setProgress(int amount) {
		setValue(amount);
	}


	/**
	 *  Sets the bar's value to a specific amount along with a message
	 *
	 *@param  amount   The new value
	 *@param  message  The message
	 */
	public void setProgress(int amount, String message) {
		setValue(amount);
		progressString = message;
		setStringWithPercent();

	}


	/**  Increments the progress bar value by 1 */
	public void incrementProgress() {
		setValue(getValue() + 1);
		setStringWithPercent();
	}


	/**
	 *  Increments the progress bar value by a specified amount
	 *
	 *@param  incrementAmount  the amount to increment
	 */
	public void incrementProgress(int incrementAmount) {
		setValue(getValue() + incrementAmount);
		setStringWithPercent();
	}


	private void setStringWithPercent() {
		setString(progressString + " (" + Math.floor(getPercentComplete() * 100) + "%)");
	}
	//}}}
}
