//{{{ GPL Notice
/*
 *  RolloverOnOffButton.java
 *  :tabSize=4:indentSize=4:noTabs=false:
 *  :folding=explicit:collapseFolds=1:
 *
 *  part of the ProCol plugin for the jEdit text editor
 *  Copyright (C) 2003-2004 Justin Dieters
 *  enderak@yahoo.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 //}}}
package com.enderak.procol.common.gui;

//{{{ Imports
import java.net.URL;
import javax.swing.ImageIcon;
import org.gjt.sp.jedit.jEdit;
//}}}

/**
 *  Extends jEdit's RolloverButton class to provide functionality for displaying
 *  different icons, text, and tooltips depending on the button's on/off status
 *
 *@author    Justin Dieters
 */
public class RolloverOnOffButton extends org.gjt.sp.jedit.gui.RolloverButton {
	//{{{ Data members
	private ImageIcon buttonImageOff;
	private ImageIcon buttonImageOn;
	private String noImageTextOff;
	private String noImageTextOn;
	private String toolTipTextOff;
	private String toolTipTextOn;

	private boolean isButtonOn;
	//}}}

	//{{{ Constructors
	/**
	 *  Creates a button with explicit settings passed in
	 *
	 *@param  buttonImageOnIn   Image to display when the button is in the on state
	 *@param  buttonImageOffIn  Image to display when the button is in the off
	 *      state
	 *@param  noImageTextOnIn   Text to display when the button is in the on state,
	 *      if there is no image to display
	 *@param  noImageTextOffIn  Text to display when the button is in the off
	 *      state, if there is no image to display
	 *@param  toolTipTextOnIn   Tooltip to display when the button is in the on
	 *      state
	 *@param  toolTipTextOffIn  Tooltip to display when the button is in the off
	 *      state
	 */
	public RolloverOnOffButton(String buttonImageOnIn, String buttonImageOffIn, String noImageTextOnIn, String noImageTextOffIn, String toolTipTextOnIn, String toolTipTextOffIn) {

		//System.out.println(buttonImageOffIn);

		URL imageURLOff  = this.getClass().getResource(buttonImageOffIn);
		URL imageURLOn   = this.getClass().getResource(buttonImageOnIn);

		if (imageURLOff == null) {
			this.buttonImageOff = null;
		} else {
			this.buttonImageOff = new ImageIcon(imageURLOff);
		}

		if (imageURLOn == null) {
			this.buttonImageOn = null;
		} else {
			this.buttonImageOn = new ImageIcon(imageURLOn);
		}

		this.noImageTextOff = noImageTextOffIn;
		this.noImageTextOn = noImageTextOnIn;
		this.toolTipTextOff = toolTipTextOffIn;
		this.toolTipTextOn = toolTipTextOnIn;

		this.turnOff();
	}


	/**
	 *  Creates a button using jEdit's property list. Properties used with this
	 *  function are defined in the ProCol.props file
	 *
	 *@param  buttonPrefix  The prefix for the button properties
	 */
	public RolloverOnOffButton(String buttonPrefix) {
		this(
				jEdit.getProperty("procol.graphics_dir") + jEdit.getProperty(buttonPrefix + ".on.icon"),
				jEdit.getProperty("procol.graphics_dir") + jEdit.getProperty(buttonPrefix + ".off.icon"),
				jEdit.getProperty(buttonPrefix + ".on.text"),
				jEdit.getProperty(buttonPrefix + ".off.text"),
				jEdit.getProperty(buttonPrefix + ".on.tooltip"),
				jEdit.getProperty(buttonPrefix + ".off.tooltip")
				);
	}
	//}}}

	//{{{ Modifier methods
	/**
	 *  Turns the button on or off based on the parameter passed in
	 *
	 *@param  turnOn  true to turn on, false to turn off
	 */
	public void setOnOff(boolean turnOn) {
		if (turnOn) {
			turnOn();
		} else {
			turnOff();
		}
	}


	/**  Turns the button off */
	public void turnOff() {
		if (buttonImageOff == null) {
			this.setText(noImageTextOff);
			this.setIcon(null);
			this.setBorderPainted(false);
		} else {
			this.setText(null);
			this.setIcon(buttonImageOff);
			this.setBorderPainted(false);
		}

		this.setToolTipText(toolTipTextOff);
		isButtonOn = false;
	}


	/**  Turns the button on */
	public void turnOn() {
		if (buttonImageOn == null) {
			this.setText(noImageTextOn);
			this.setIcon(null);
			this.setBorderPainted(false);
		} else {
			this.setText(null);
			this.setIcon(buttonImageOn);
			this.setBorderPainted(false);
		}

		this.setToolTipText(toolTipTextOn);
		isButtonOn = true;
	}


	/**
	 *  Toggles the on/off state of the button. If button is currently on, it will
	 *  be turned off, and vice-versa.
	 */
	public void toggle() {
		setOnOff(isButtonOn = !isButtonOn);
	}
	//}}}
}

