//{{{ GPL Notice
/*
 *  ProColUser.java
 *  :tabSize=4:indentSize=4:noTabs=false:
 *  :folding=explicit:collapseFolds=1:
 *
 *  part of the ProCol plugin for the jEdit text editor
 *  Copyright (C) 2003-2004 Justin Dieters
 *  enderak@yahoo.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//}}}
package com.enderak.procol.common.model;

/**
 *  Description of the Class
 *
 *@author    Justin Dieters
 */
public class ProColUser {
	//{{{ Data members
	protected String name            = "";
	protected String realName        = "";
	protected String project         = "";
	protected boolean authenticated  = false;
	//}}}

	//{{{ Constructors
	/**  Constructor for the ProColUser object */
	public ProColUser() { }


	/**
	 *  Constructor for the ProColUser object
	 *
	 *@param  nameIn  Description of the Parameter
	 */
	public ProColUser(String nameIn) {
		this.name = nameIn;
	}


	/**
	 *@param  nameIn      Description of the Parameter
	 *@param  realNameIn  Description of the Parameter
	 */
	public ProColUser(String nameIn, String realNameIn) {
		this.name = nameIn;
		this.realName = realNameIn;
	}
	//}}}

	/**
	 *@return    the user name
	 */
	public String getName() {
		return name;
	}


	/**
	 *@return    the user info
	 */
	public String getUserInfo() {
		return name + "\n" + realName;
	}


	/**
	 *@return    true if the user is authenticated
	 */
	public boolean isAuthenticated() {
		return authenticated;
	}


	/**
	 *@param  authIn
	 */
	public void setAuthenticated(boolean authIn) {
		this.authenticated = authIn;
	}
	//}}}
}

