/*
 *  MessageFactory.java
 *  :tabSize=4:indentSize=4:noTabs=false:
 *  :folding=explicit:collapseFolds=1:
 *
 *  part of the ProCol plugin for the jEdit text editor
 *  Copyright (C) 2003-2004 Justin Dieters
 *  enderak@yahoo.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package com.enderak.procol.common.net;

//{{{ Imports
import com.enderak.procol.common.*;
import com.enderak.procol.common.util.*;
import java.util.*;
//}}}

/**
 *  Compiles packets into messages
 *
 *@author    Justin Dieters
 */
public class MessageFactory extends EnhancedObservable {
	//{{{ Data Members
	private final static int MAX_PACKET_SIZE   = 2048;
	private final static int HEADER_SIZE       = 16;
	private final static int MAX_DATA_SIZE     = MAX_PACKET_SIZE - HEADER_SIZE;
	private LinkedList messageQueue            = new LinkedList();
	private Hashtable partialMessages          = new Hashtable();
	private ProColIncomingMessage tempMessage;
	//}}}


	/**  Constructor for the MessageFactory object */
	public MessageFactory() {
		super();
	}


	/**
	 *  Adds a packet to the appropriate message
	 *
	 *@param  packetIn
	 */
	public void addPacket(ProColPacket packetIn) {
		synchronized (this) {
			if (packetIn.dataRemaining == packetIn.dataSize) {
				if (partialMessages.containsKey(new Integer(packetIn.messageID))) {
					((ProColIncomingMessage)(partialMessages.get(new Integer(packetIn.messageID)))).appendPacket(packetIn);
					tempMessage = ((ProColIncomingMessage)(partialMessages.remove(new Integer(packetIn.messageID))));
				} else {
					tempMessage = new ProColIncomingMessage(packetIn);
				}
				messageQueue.add(tempMessage); // add message to queue
				this.forceNotify(tempMessage); // notify observers
				this.notifyAll(); // notify threads
			} else {
				if (partialMessages.containsKey(new Integer(packetIn.messageID))) {
					((ProColIncomingMessage)(partialMessages.get(new Integer(packetIn.messageID)))).appendPacket(packetIn);
				} else {
					partialMessages.put(new Integer(packetIn.messageID), new ProColIncomingMessage(packetIn));
				}
			}
		}
		this.forceNotify(packetIn);
	}


	/**
	 *  Gets the next Packet
	 *
	 *@return    The next Packet
	 */
	public ProColIncomingMessage getNext() {
		// System.out.println("$");
		// ProColIncomingMessage tempMessage = (ProColIncomingMessage)messageQueue.removeFirst();
		// System.out.println("%");
		return ((ProColIncomingMessage)messageQueue.removeFirst());
	}


	/**
	 *  Checks the message queue for more messages
	 *
	 *@return    true if there are more messages in the queue
	 */
	public boolean hasNext() {
		return !messageQueue.isEmpty();
	}
}

