/*
 *  ProColIncomingMessage.java
 *  :tabSize=4:indentSize=4:noTabs=false:
 *  :folding=explicit:collapseFolds=1:
 *
 *  part of the ProCol plugin for the jEdit text editor
 *  Copyright (C) 2003-2004 Justin Dieters
 *  enderak@yahoo.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package com.enderak.procol.common.net;

//{{{ Imports
import java.io.*;
//}}}

/**
 *  Holds information for an incoming message
 *
 *@author    Justin Dieters
 */
public class ProColIncomingMessage extends ProColMessage {
	//{{{ Data Members
	/** */
	public byte[] data;
	/** */
	public int location  = 0;
	//}}}

	/**
	 *  Create a new message with an initial packet
	 *
	 *@param  packetIn  The initial packet
	 */

	public ProColIncomingMessage(ProColPacket packetIn) {
		super(packetIn);
		data = new byte[packetIn.dataRemaining];
		appendPacket(packetIn);
	}


	/**
	 *  Appends a packet to this message
	 *
	 *@param  packetIn  The packet to append
	 */
	public final void appendPacket(ProColPacket packetIn) {
		for (int i = 0; i < packetIn.dataSize; i++) {
			data[location + i] = packetIn.data[i];
		}
		location += packetIn.dataSize;
	}
}
