//{{{ GPL Notice
/*
 *  ProColMessage.java
 *  :tabSize=4:indentSize=4:noTabs=false:
 *  :folding=explicit:collapseFolds=1:
 *
 *  part of the ProCol plugin for the jEdit text editor
 *  Copyright (C) 2003-2004 Justin Dieters
 *  enderak@yahoo.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//}}}
package com.enderak.procol.common.net;

//{{{ Imports
import java.io.*;
//}}}

/**
 *  Provides a central class for some some standard operations on SSL sockets
 *
 *@author    Justin Dieters
 */
public class ProColMessage {
	//{{{ Data Members
	/**  The message ID for this message */
	public int messageID    = 0;
	/**  The request code for this message */
	public int requestCode  = 0;
	//}}}

	//{{{ ProColMessage(ProColPacket)
	/**
	 *  Create a new Message with an initial packet
	 *
	 *@param  packetIn  The packet
	 */
	public ProColMessage(ProColPacket packetIn) {
		messageID = packetIn.messageID;
		requestCode = packetIn.requestCode;
	}
	//}}}

	//{{{ ProColMessage(int, int)
	/**
	 *  Create a new message with an initial messageID and requestCode
	 *
	 *@param  messageIDIn    The message ID
	 *@param  requestCodeIn  The request code
	 */
	public ProColMessage(int messageIDIn, int requestCodeIn) {
		messageID = messageIDIn;
		requestCode = requestCodeIn;
	}
	//}}}

	//{{{ isError
	/**
	 *  determine if this message is an error message, (if requestCode is of the
	 *  form 0xF*******)
	 *
	 *@return    true if this is an error message
	 */
	public boolean isError() {
		return ((requestCode & 0xF0000000) == 0xF0000000);
	}
	//}}}

	//{{{ toString
	/**
	 *  Get the String representation of this message4
	 *
	 *@return    This message in string form
	 */
	public String toString() {
		return "" + messageID + "|" + Integer.toHexString(requestCode);
	}
	//}}}
}

