/*
 *  ProColOutgoingMessage.java
 *  :tabSize=4:indentSize=4:noTabs=false:
 *  :folding=explicit:collapseFolds=1:
 *
 *  part of the ProCol plugin for the jEdit text editor
 *  Copyright (C) 2003-2004 Justin Dieters
 *  enderak@yahoo.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package com.enderak.procol.common.net;

//{{{ Imports
import java.io.*;
//}}}

/**
 *  Holds information for an outgoing message
 *
 *@author    Justin Dieters
 */
public class ProColOutgoingMessage extends ProColMessage {
	//{{{ Data Members
	private DataInputStream dataStream  = null;
	private File file                   = null;
	//}}}

	/**
	 *  Creates a new message
	 *
	 *@param  messageIDIn    The message ID
	 *@param  requestCodeIn  The request code
	 *@param  dataStreamIn   The data stream to get data for the data section from
	 */
	public ProColOutgoingMessage(int messageIDIn, int requestCodeIn, DataInputStream dataStreamIn) {
		super(messageIDIn, requestCodeIn);
		dataStream = dataStreamIn;
		file = null;
	}


	/**
	 *  Creates a new message
	 *
	 *@param  messageIDIn    The message ID
	 *@param  requestCodeIn  The request code
	 *@param  fileIn         The file to get data for the data section from
	 */
	public ProColOutgoingMessage(int messageIDIn, int requestCodeIn, File fileIn) {
		super(messageIDIn, requestCodeIn);
		dataStream = null;
		file = fileIn;
	}


	/**
	 *  Creates a new message with both a data stream and a file
	 *
	 *@param  messageIDIn    The message ID
	 *@param  requestCodeIn  The request code
	 *@param  dataStreamIn   The file to get data for the data section from
	 *@param  fileIn         The data stream to get data for the data section from
	 */
	public ProColOutgoingMessage(int messageIDIn, int requestCodeIn, DataInputStream dataStreamIn, File fileIn) {
		super(messageIDIn, requestCodeIn);
		dataStream = dataStreamIn;
		file = fileIn;
	}


	/**
	 *  gets the dataInputStream for this message
	 *
	 *@return    The DataInputStream
	 */
	public DataInputStream getDataInputStream() {
		if (file == null) {
			return dataStream;
		} else {
			if (dataStream == null) {
				try {
					return new DataInputStream(new FileInputStream(file));
				} catch (IOException ioe) {
					System.err.println("Error generating DataInputStream from file in ProColOutgoingMessage: " + ioe);
					return null;
				}
			} else {
				try {
					DataInputStream temp  = new DataInputStream(new SequenceInputStream(dataStream, new FileInputStream(file)));
					return temp;
				} catch (IOException ioe) {
					System.err.println("Error generating DataInputStream from file in ProColOutgoingMessage: " + ioe);
					return null;
				}
			}
		}
	}
}

