//{{{ GPL Notice
/*
 *  ProColPacket.java
 *  :tabSize=4:indentSize=4:noTabs=false:
 *  :folding=explicit:collapseFolds=1:
 *
 *  part of the ProCol plugin for the jEdit text editor
 *  Copyright (C) 2003-2004 Justin Dieters
 *  enderak@yahoo.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//}}}
package com.enderak.procol.common.net;

//{{{ Imports
import javax.net.ssl.*;
//}}}

/**
 *  Represents a ProCol packet that is sent over the network connection
 *
 *@author    Justin Dieters
 */
public class ProColPacket {
	//{{{ Data Members
	/**  The message id this packet is a part of */
	public int messageID      = 0;
	/**  Data remaining in this message */
	public int dataRemaining  = 0;
	/**  Request code for this message */
	public int requestCode    = 0;
	/**  Data size of this message */
	public int dataSize       = 0;
	/**  Data section of this packet */
	public byte[] data;
	//}}}

	//{{{ Constructor
	/**
	 *  Creates a packet from existing data
	 *
	 *@param  messageIDIn      The the message ID this packet is a part of
	 *@param  requestCodeIn    The request code for this packet
	 *@param  dataRemainingIn  The number of bytes remaining in the message,
	 *      including this packet's data
	 *@param  dataSizeIn       The size of the data section of this packet
	 *@param  dataIn           The bytes that make upthe data section of this
	 *      packet
	 */
	public ProColPacket(int messageIDIn, int requestCodeIn, int dataRemainingIn, int dataSizeIn, byte[] dataIn) {
		messageID = messageIDIn;
		requestCode = requestCodeIn;
		dataRemaining = dataRemainingIn;
		dataSize = dataSizeIn;
		data = dataIn;
	}
	//}}}

	//{{{ setPacket
	/**
	 *  Redefines this packet from existing data
	 *
	 *@param  messageIDIn      The the message ID this packet is a part of
	 *@param  requestCodeIn    The request code for this packet
	 *@param  dataRemainingIn  The number of bytes remaining in the message,
	 *      including this packet's data
	 *@param  dataSizeIn       The size of the data section of this packet
	 *@param  dataIn           The bytes that make upthe data section of this
	 *      packet
	 */
	public void setPacket(int messageIDIn, int requestCodeIn, int dataRemainingIn, int dataSizeIn, byte[] dataIn) {
		messageID = messageIDIn;
		requestCode = requestCodeIn;
		dataRemaining = dataRemainingIn;
		dataSize = dataSizeIn;
		data = dataIn;
	}
	//}}}

	//{{{ toString
	/**
	 *  Prints this packet's information
	 *
	 *@return    This packet's data as a string
	 */
	public String toString() {
		return "" + messageID + "|" + Integer.toHexString(requestCode) + "|" + dataRemaining + "|" + dataSize;
	}
	//}}}
}

