//{{{ GPL Notice
/*
 *  RequestType.java
 *  :tabSize=4:indentSize=4:noTabs=false:
 *  :folding=explicit:collapseFolds=1:
 *
 *  part of the ProCol plugin for the jEdit text editor
 *  Copyright (C) 2003-2004 Justin Dieters
 *  enderak@yahoo.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//}}}
package com.enderak.procol.common.net;

/**
 *  Defines standard codes for ProCol communication protocol
 *
 *@author    Justin Dieters
 */
public class RequestType {
	/**  The protocol version for this request type class */
	public final static String PROTOCOL_VERSION                 = "0.1";

	//{{{ Connection codes (0000xxxx)
	/**  Description of the Field */
	public final static int HELLO                               = 0x00000000;
	/**  Description of the Field */
	public final static int PROTOCOL_OK                         = 0x00000001;
	/**  Description of the Field */
	public final static int PROTOCOL_WARN                       = 0x00000002;
	/**  Description of the Field */
	public final static int PROTOCOL_TOO_OLD                    = 0xF0000003;
	/**  Description of the Field */
	public final static int PROTOCOL_TOO_NEW                    = 0xF0000004;
	/**  Description of the Field */
	public final static int AUTHENTICATE                        = 0x00000100;
	/**  Description of the Field */
	public final static int AUTHENTICATION_OK                   = 0x00000101;
	/**  Description of the Field */
	public final static int USER_ALREADY_LOGGED_IN              = 0xF0000102;
	/**  Description of the Field */
	public final static int USER_DOES_NOT_EXIST                 = 0xF0000103;
	/**  Description of the Field */
	public final static int PASSWORD_FAILED                     = 0xF0000104;
	/**  Description of the Field */
	public final static int AUTHENTICATION_ERROR                = 0xF0000105;
	/**  Description of the Field */
	public final static int DISCONNECT                          = 0x00000200;
	/**  Description of the Field */
	public final static int GOODBYE                             = 0x00000201;
	//}}}

	//{{{ User List codes (0001xxxx)
	/**  Description of the Field */
	public final static int GET_USER_LIST                       = 0x00010000;
	/**  Description of the Field */
	public final static int USER_LIST                           = 0x00010001;
	/**  Description of the Field */
	public final static int LIST_ADD_USER                       = 0x00010002;
	/**  Description of the Field */
	public final static int LIST_REMOVE_USER                    = 0x00010003;
	/**  Description of the Field */
	public final static int GET_USER_INFO                       = 0x00010004;
	/**  Description of the Field */
	public final static int USER_INFO                           = 0x00010005;
	/**  Description of the Field */
	public final static int GET_PROJECT_USERS                   = 0x00010100;
	//}}}

	//{{{ Project codes (0002xxxx)
	/**  Description of the Field */
	public final static int GET_PROJECT_LIST                    = 0x00020000;
	/**  Description of the Field */
	public final static int PROJECT_LIST                        = 0x00020001;
	/**  Description of the Field */
	public final static int NO_PROJECTS                         = 0x00020002;
	/**  Description of the Field */
	public final static int OPEN_PROJECT                        = 0x00020003;
	/**  Description of the Field */
	public final static int CLOSE_PROJECT                       = 0x00020004;
	/**  Description of the Field */
	public final static int GET_PROJECT_INFO                    = 0x00020005;
	/**  Description of the Field */
	public final static int SET_PROJECT_INFO                    = 0x00020006;
	/**  Description of the Field */
	public final static int PROJECT_INFO                        = 0x00020007;
	//}}}

	//{{{ File codes (0003xxxx)
	//{{{ File tree (300xx)
	/**  Description of the Field */
	public final static int GET_FILE_TREE                       = 0x00030000;
	/**  Description of the Field */
	public final static int LOAD_TREE                           = 0x00030001;
	/**  Description of the Field */
	public final static int UPDATE_FILE_INFO                    = 0x00030002;
	/**  Description of the Field */
	public final static int TREE_ADD_FILE                       = 0x00030003;
	/**  Description of the Field */
	public final static int TREE_ADD_DIRECTORY                  = 0x00030004;
	/**  Description of the Field */
	public final static int TREE_DEL_FILE                       = 0x00030005;
	/**  Description of the Field */
	public final static int TREE_DEL_DIRECTORY                  = 0x00030006;
	//}}}
	//{{{ Download file (301xx)
	/**  Description of the Field */
	public final static int DOWNLOAD_SNAPSHOT                   = 0x00030100;
	/** */
	public final static int DOWNLOAD_FILE                       = 0x00030101;
	/**  Description of the Field */
	// public final static int DOWNLOAD_START                      = 0x00030102;
	/**  Description of the Field */
	// public final static int DOWNLOAD_STOP                       = 0x00030103;
	/**  Description of the Field */
	public final static int DOWNLOAD_SNAPSHOT_FILE              = 0x00030104;
	//}}}
	//{{{ Upload File (302xx)
	/**  check in file only, don't change version or file data */
	public final static int UPLOAD_FILE                         = 0x00030202;
	/** */
	public final static int UPLOAD_FILE_OK                      = 0x00030203;
	/** */
	public final static int UPLOAD_FILE_INFO                    = 0x00030204;
	/** */
	public final static int UPLOAD_FILE_INFO_OK                 = 0x00030205;
	/** */
	public final static int UPLOAD_FILE_WRITE                   = 0x00030206;
	/** */
	public final static int UPLOAD_FILE_WRITE_OK                = 0x00030207;
	/** */
	public final static int UPLOAD_FILE_EXISTS                  = 0xF00302F0;
	/** */
	public final static int UPLOAD_FILE_NAME_FAILED             = 0xF00302F1;
	/** */
	public final static int UPLOAD_FILE_VERSION_IO_ERROR        = 0xF00302F2;
	/** */
	public final static int UPLOAD_FILE_IO_ERROR                = 0xF00302F3;
	/** */
	public final static int UPLOAD_FILE_NOT_EXPECTED            = 0xF00302F4;
	/** */
	public final static int UPLOAD_FILE_UNKNOWN_ERROR           = 0xF00302FF;
	//}}}
	//{{{ Check out file (303xx)
	/** */
	public final static int CHECK_OUT_FILE                      = 0x00030300;
	/** */
	// public final static int CHECK_OUT_START                     = 0x00030301;
	/** */
	// public final static int CHECK_OUT_STOP                      = 0x00030302;
	/** */
	public final static int CHECK_OUT_ALREADY_CHECKED_OUT       = 0xF00303F0;
	/** */
	public final static int CHECK_OUT_FILE_NOT_FOUND            = 0xF00303FE;
	/** */
	public final static int CHECK_OUT_UNKNOWN_ERROR             = 0xF00303FF;

	//}}}
	//{{{ Check in file (304xx)
	/**  check in file only, don't change version or file data */
	public final static int CHECK_IN_FILE                       = 0x00030402;
	/** */
	public final static int CHECK_IN_FILE_OK                    = 0x00030403;
	/** */
	public final static int CHECK_IN_FILE_INFO                  = 0x00030404;
	/** */
	public final static int CHECK_IN_FILE_INFO_OK               = 0x00030405;
	/** */
	public final static int CHECK_IN_FILE_WRITE                 = 0x00030406;
	/** */
	public final static int CHECK_IN_FILE_WRITE_OK              = 0x00030407;
	/** */
	public final static int CHECK_IN_ALREADY_CHECKED_IN         = 0xF00304F0;
	/** */
	public final static int CHECK_IN_FILE_NAME_FAILED           = 0xF00304F1;
	/** */
	public final static int CHECK_IN_FILE_VERSION_NO_OVERWRITE  = 0xF00304F2;
	/** */
	public final static int CHECK_IN_FILE_VERSION_OLD           = 0xF00304F3;
	/** */
	public final static int CHECK_IN_FILE_VERSION_IO_ERROR      = 0xF00304F4;
	/** */
	public final static int CHECK_IN_FILE_NOT_FOUND             = 0xF00304F5;
	/** */
	public final static int CHECK_IN_FILE_IO_ERROR              = 0xF00304F6;
	/** */
	public final static int CHECK_IN_FILE_NOT_EXPECTED          = 0xF00304F7;
	/** */
	public final static int CHECK_IN_FILE_UNKNOWN_ERROR         = 0xF00304FF;
	//}}}
	//{{{ Server-side file operations (305xx)
	//{{{ Delete file (3050x)
	/** */
	public final static int DELETE_FILE                         = 0x00030500;
	/** */
	public final static int DELETE_FILE_OK                      = 0x00030501;
	/** */
	public final static int DELETE_FILE_IO_ERROR                = 0xF0030502;
	/** */
	public final static int DELETE_FILE_NOT_ALLOWED             = 0xF0030503;
	/** */
	public final static int DELETE_FILE_UNKNOWN_ERROR           = 0xF003050F;
	//}}}
	//{{{ Rename file (3051x)
	/** */
	public final static int RENAME_FILE                         = 0x00030510;
	/** */
	public final static int RENAME_FILE_OK                      = 0x00030511;
	/** */
	public final static int RENAME_FILE_EXISTS                  = 0xF0030512;
	/** */
	public final static int RENAME_FILE_IO_ERROR                = 0xF0030513;
	/** */
	public final static int RENAME_FILE_NOT_ALLOWED             = 0xF0030514;
	/** */
	public final static int RENAME_FILE_UNKNOWN_ERROR           = 0xF003051F;
	//}}}
	//{{{ Move file (3052x)
	/** */
	public final static int MOVE_FILE                           = 0x00030520;
	/** */
	public final static int MOVE_FILE_OK                        = 0x00030521;
	/** */
	public final static int MOVE_FILE_EXISTS                    = 0x00030522;
	/** */
	public final static int MOVE_FILE_IO_ERROR                  = 0xF0030523;
	/** */
	public final static int MOVE_FILE_NOT_ALLOWED               = 0xF0030524;
	/** */
	public final static int MOVE_FILE_UNKNOWN_ERROR             = 0xF003052F;
	//}}}
	//{{{ New file (3053x)
	/** */
	public final static int NEW_FILE                            = 0x00030530;
	/** */
	public final static int NEW_DIRECTORY                       = 0x00030531;
	/** */
	public final static int NEW_FILE_OK                         = 0x00030532;
	/** */
	public final static int NEW_FILE_EXISTS                     = 0x00030533;
	/** */
	public final static int NEW_FILE_IO_ERROR                   = 0x00030534;
	/** */
	public final static int NEW_FILE_NOT_ALLOWED                = 0x00030535;
	/** */
	public final static int NEW_FILE_UNKNOWN_ERROR              = 0x0003053F;
	//}}}
	//}}}

	//{{{ File history codes (306xx)
	/** */
	public final static int GET_FILE_HISTORY                    = 0x00030602;
	/** */
	public final static int FILE_HISTORY                        = 0x00030603;
	//}}}

	//{{{ Generic file operation result codes (30Fxx)
	/** */
	public final static int FILE_OK                             = 0x00030F01;
	/** */
	public final static int FILE_INFO_OK                        = 0x00030F02;
	/** */
	public final static int FILE_WRITE                          = 0x00030F03;
	/** */
	public final static int FILE_WRITE_OK                       = 0x00030F04;
	/** */
	public final static int FILE_NAME_FAILED                    = 0xF0030FA0;
	/** */
	public final static int FILE_CHECKED_OUT                    = 0xF0030FA1;
	/** */
	public final static int FILE_NOT_ALLOWED                    = 0xF0030FA2;
	/** */
	public final static int FILE_VERSION_NO_OVERWRITE           = 0xF0030FB0;
	/** */
	public final static int FILE_VERSION_OLD                    = 0xF0030FB1;
	/** */
	public final static int FILE_VERSION_IO_ERROR               = 0xF0030FB2;
	/** */
	public final static int FILE_NOT_FOUND                      = 0xF0030FB3;
	/** */
	public final static int FILE_EXISTS                         = 0xF0030FB4;
	/** */
	public final static int FILE_IO_ERROR                       = 0xF0030FB5;
	/** */
	public final static int FILE_NOT_EXPECTED                   = 0xF0030FC0;
	/** */
	public final static int FILE_UNKNOWN_ERROR                  = 0xF0030FFF;

	//}}}

	//}}}

	//{{{ Communication codes (0004xxxx)
	//{{{ Private messages (000400xx)
	/** */
	public final static int NEW_PRIVATE_MESSAGE                 = 0x00040000;
	/** */
	public final static int GET_PRIVATE_MESSAGE_LIST            = 0x00040001;
	/** */
	public final static int PRIVATE_MESSAGE_LIST                = 0x00040002;
	/** */
	public final static int GET_PRIVATE_MESSAGE                 = 0x00040003;
	/** */
	public final static int PRIVATE_MESSAGE                     = 0x00040004;
	/** */
	public final static int PRIVATE_MESSAGE_ADD                 = 0x00040005;
	/** */
	public final static int PRIVATE_MESSAGE_DELETE              = 0x00040006;
	/** */
	public final static int PRIVATE_MESSAGE_OK                  = 0x00040007;
	/** */
	public final static int PRIVATE_MESSAGE_USER_NOT_EXIST      = 0xF00400F0;
	/** */
	public final static int PRIVATE_MESSAGE_ADD_FAILED          = 0xF00400F1;
	/** */
	public final static int PRIVATE_MESSAGE_DELETE_FAILED       = 0xF00400F2;
	//}}}
	//{{{ Public messages (000401xx)
	/** */
	public final static int NEW_PUBLIC_MESSAGE                  = 0x00040100;
	/** */
	public final static int GET_PUBLIC_MESSAGE_LIST             = 0x00040101;
	/** */
	public final static int PUBLIC_MESSAGE_LIST                 = 0x00040102;
	/** */
	public final static int GET_PUBLIC_MESSAGE                  = 0x00040103;
	/** */
	public final static int PUBLIC_MESSAGE                      = 0x00040104;
	/** */
	public final static int PUBLIC_MESSAGE_ADD                  = 0x00040105;
	/** */
	public final static int PUBLIC_MESSAGE_DELETE               = 0x00040106;
	/** */
	public final static int PUBLIC_MESSAGE_OK                   = 0x00040107;
	/** */
	public final static int PUBLIC_MESSAGE_ADD_FAILED           = 0xF00401F1;
	/** */
	public final static int PUBLIC_MESSAGE_DELETE_FAILED        = 0xF00401F2;
	//}}}
	//}}}

	//{{{ Task codes (0005xxxx)
	//{{{ Todo list (000500xx)
	/** */
	public final static int NEW_TODO_ITEM                       = 0x00050000;
	/** */
	public final static int GET_TODO_ITEM_LIST                  = 0x00050001;
	/** */
	public final static int TODO_ITEM_LIST                      = 0x00050002;
	/** */
	public final static int GET_TODO_ITEM                       = 0x00050003;
	/** */
	public final static int TODO_ITEM                           = 0x00050004;
	/** */
	public final static int TODO_ITEM_ADD                       = 0x00050005;
	/** */
	public final static int TODO_ITEM_DELETE                    = 0x00050006;
	/** */
	public final static int TODO_ITEM_OK                        = 0x00050007;
	/** */
	public final static int TODO_ITEM_UPDATE                    = 0x00050008;
	/** */
	public final static int TODO_ITEM_ADD_FAILED                = 0xF00500F1;
	/** */
	public final static int TODO_ITEM_DELETE_FAILED             = 0xF00500F2;
	/** */
	public final static int TODO_ITEM_UPDATE_FAILED             = 0xF00500F3;
	//}}}
	//{{{ Bug list (000501xx)
	/** */
	public final static int NEW_BUG_ITEM                        = 0x00050100;
	/** */
	public final static int GET_BUG_ITEM_LIST                   = 0x00050101;
	/** */
	public final static int BUG_ITEM_LIST                       = 0x00050102;
	/** */
	public final static int GET_BUG_ITEM                        = 0x00050103;
	/** */
	public final static int BUG_ITEM                            = 0x00050104;
	/** */
	public final static int BUG_ITEM_ADD                        = 0x00050105;
	/** */
	public final static int BUG_ITEM_DELETE                     = 0x00050106;
	/** */
	public final static int BUG_ITEM_OK                         = 0x00050107;
	/** */
	public final static int BUG_ITEM_UPDATE                     = 0x00050108;
	/** */
	public final static int BUG_ITEM_ADD_FAILED                 = 0xF00501F1;
	/** */
	public final static int BUG_ITEM_DELETE_FAILED              = 0xF00501F2;
	/** */
	public final static int BUG_ITEM_UPDATE_FAILED              = 0xF00501F3;
	//}}}
	//{{{ Calendar (000502xx)

	/** */
	public final static int NEW_CALENDAR_ITEM                   = 0x00050200;
	/** */
	public final static int GET_CALENDAR_ITEM_LIST              = 0x00050201;
	/** */
	public final static int CALENDAR_ITEM_LIST                  = 0x00050202;
	/** */
	public final static int GET_CALENDAR_ITEM                   = 0x00050203;
	/** */
	public final static int CALENDAR_ITEM                       = 0x00050204;
	/** */
	public final static int CALENDAR_ITEM_ADD                   = 0x00050205;
	/** */
	public final static int CALENDAR_ITEM_DELETE                = 0x00050206;
	/** */
	public final static int CALENDAR_ITEM_OK                    = 0x00050207;
	/** */
	public final static int CALENDAR_ITEM_UPDATE                = 0x00050208;
	/** */
	public final static int CALENDAR_ITEM_ADD_FAILED            = 0xF00502F1;
	/** */
	public final static int CALENDAR_ITEM_DELETE_FAILED         = 0xF00502F2;
	/** */
	public final static int CALENDAR_ITEM_UPDATE_FAILED         = 0xF00502F3;

	//}}}
	//}}}

	//{{{ Admin codes (FFFFxxxx)
	/**  Description of the Field */
	public final static int ADD_PROJECT                         = 0x000F0000;
	/**  Description of the Field */
	public final static int DEL_PROJECT                         = 0x000F0001;
	/**  Description of the Field */
	public final static int ADD_USER                            = 0x000F0002;
	/**  Description of the Field */
	public final static int DEL_USER                            = 0x000F0003;
	/**  Description of the Field */
	public final static int ADD_USER_TO_PROJECT                 = 0x000F0004;
	/**  Description of the Field */
	public final static int DEL_USER_FROM_PROJECT               = 0x000F0005;
	/**  Description of the Field */
	public final static int KILL_SERVER                         = 0x000FFFE0;
	//}}}

	//{{{ Invalid Codes (FFFFFFFx)
	/**
	 *  Code to signify that a client or server has received a method it doesn't
	 *  know what to do with. Clients and server should display and/or log an error
	 *  message when received. May indicate incompatible ProCol protocol versions
	 *  between the client and the server.
	 */
	public final static int INVALID                             = 0xFFFFFFFE;
	/**
	 *  Null request code, used to set a variable when a method that would normally
	 *  respond to messages should not respond to anything. This code should never
	 *  be sent by either the client or the server, and if ever received, should be
	 *  ignored.
	 */
	public final static int NULL                                = 0xFFFFFFFF;
	//}}}
}
