//{{{ GPL Notice
/*
 *  SSLCommon.java
 *  :tabSize=4:indentSize=4:noTabs=false:
 *  :folding=explicit:collapseFolds=1:
 *
 *  part of the ProCol plugin for the jEdit text editor
 *  Copyright (C) 2003-2004 Justin Dieters
 *  enderak@yahoo.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//}}}
package com.enderak.procol.common.net;

import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;

/**
 *  Class which provides some standard operations on SSLSocket's
 *
 *@author    Justin Dieters
 */
public class SSLCommon {
	/**
	 *@param  sslSocket  The socket to enable anonymous cipher suites for. This is
	 *      not guarenteed to work for non-Sun JRE's, which may not follow Sun's
	 *      naming conventions for cipher suites
	 */
	public static void enableAnonymousCipherSuites(SSLSocket sslSocket) {
		String supportedSuites[]      = sslSocket.getSupportedCipherSuites();
		String tempSupportedSuites[]  = new String[supportedSuites.length];
		int i                       = 0;
		for (int j = 0; j < supportedSuites.length; j++) {
			if (supportedSuites[j].indexOf("_anon_") > 0) {
				tempSupportedSuites[i++] = supportedSuites[j];
			}
		}
		String enabledSuites[]        = sslSocket.getEnabledCipherSuites();
		String tempEnabledSuites[]    = new String[enabledSuites.length + i];
		System.arraycopy(enabledSuites, 0, tempEnabledSuites, 0, enabledSuites.length);
		System.arraycopy(tempSupportedSuites, 0, tempEnabledSuites, enabledSuites.length, i);
		sslSocket.setEnabledCipherSuites(tempEnabledSuites);
	}


	/**
	 *@param  sslserversocket  The server socket to enable anonymous cipher suites
	 *      for. This is not guarenteed to work for non-Sun JRE's, which may not
	 *      follow Sun's naming conventions for cipher suites
	 */
	public static void enableAnonymousCipherSuites(SSLServerSocket sslserversocket) {
		String supportedSuites[]      = sslserversocket.getSupportedCipherSuites();
		String tempSupportedSuites[]  = new String[supportedSuites.length];
		int i                       = 0;
		for (int j = 0; j < supportedSuites.length; j++) {
			if (supportedSuites[j].indexOf("_anon_") > 0) {
				tempSupportedSuites[i++] = supportedSuites[j];
			}
		}
		String enabledSuites[]        = sslserversocket.getEnabledCipherSuites();
		String tempEnabledSuites[]    = new String[enabledSuites.length + i];
		System.arraycopy(enabledSuites, 0, tempEnabledSuites, 0, enabledSuites.length);
		System.arraycopy(tempSupportedSuites, 0, tempEnabledSuites, enabledSuites.length, i);
		sslserversocket.setEnabledCipherSuites(tempEnabledSuites);
	}
}
