//{{{ GPL Notice
/*
 *  DownloadFile.java
 *  :tabSize=4:indentSize=4:noTabs=false:
 *  :folding=explicit:collapseFolds=1:
 *
 *  part of the ProCol plugin for the jEdit text editor
 *  Copyright (C) 2003-2004 Justin Dieters
 *  enderak@yahoo.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//}}}
package com.enderak.procol.common.util;

//{{{ Imports
import com.enderak.procol.common.model.ProColFile;
import java.net.URI;
//}}}

/**
 *  Container class for a file that is being transfered. Just serves to hold the
 *  file and associated information until the file data is received. Name is
 *  rather misleading, as it pulls double-duty as both a file being downloaded
 *  and a file being uploaded, depending on which end of the transfer it's at
 *
 *@author    Justin Dieters
 */
public class DownloadFile {
	//{{{ Data members
	/** */
	public ProColFile file;
	/** */
	public String version;
	/** */
	public String changeLog;
	/** */
	public URI destURI;
	//}}}

	//{{{ Constructors
	/**
	 *  Creates a new, DownloadFile with a destination URI
	 *
	 *@param  destURIIn  URI of destination
	 */
	public DownloadFile(URI destURIIn) {
		destURI = destURIIn;
	}


	/**
	 *  Creates a new DownloadFile with a ProColFile and destination URI
	 *
	 *@param  fileIn     The File
	 *@param  destURIIn  URI of destination
	 */
	public DownloadFile(ProColFile fileIn, URI destURIIn) {
		destURI = destURIIn;
		file = fileIn;
	}


	/**
	 *  Creates a DownloadFile with a file, new version, and changelog
	 *
	 *@param  fileIn       The File
	 *@param  versionIn    The File Version
	 *@param  changeLogIn  The Changelog
	 */
	public DownloadFile(ProColFile fileIn, String versionIn, String changeLogIn) {
		file = fileIn;
		version = versionIn;
		changeLog = changeLogIn;
	}
	//}}}

	/**
	 *@return    The DownloadFile in String form
	 */
	public String toString() {
		if (file != null) {
			return file.getName();
		} else if (destURI != null) {
			return destURI.getPath();
		} else {
			return super.toString();
		}
	}
}

