//{{{ GPL Notice
/*
 *  EnhancedObservable.java
 *  :tabSize=4:indentSize=4:noTabs=false:
 *  :folding=explicit:collapseFolds=1:
 *
 *  part of the ProCol plugin for the jEdit text editor
 *  Copyright (C) 2003-2004 Justin Dieters
 *  enderak@yahoo.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//}}}
package com.enderak.procol.common.util;

//{{{ Imports
import java.util.*;
//}}}

/**
 *  Extends Observable to add forced notifications
 *
 *@author    Justin Dieters
 */
public class EnhancedObservable extends Observable {
	//{{{ forceNotify
	/**
	 *  Forces this object's changed flag to be set and notification to be sent to
	 *  all Observers
	 */
	public void forceNotify() {
		this.setChanged();
		this.notifyObservers();
	}
	//}}}

	//{{{ forceNotify(Object arg)
	/**
	 *  Forces this object's changed flag to be set and notification to be sent to
	 *  all Observers, with an Object argument
	 *
	 *@param  arg  Object argument to pass to notifyObservers
	 */
	public void forceNotify(Object arg) {
		this.setChanged();
		this.notifyObservers(arg);
	}
	//}}}

	/**
	 *@param  o
	 */
	/*
	 *  public void addObserver(Observer o) {
	 *  super.addObserver(o);
	 *  System.out.println("Adding in " + this + " numObservers: " + this.countObservers());
	 *  }
	 */

	/**
	 *@param  o  Description of the Parameter
	 */
	/*
	 *  public void deleteObserver(Observer o) {
	 *  super.deleteObserver(o);
	 *  System.out.println("Delete in " + this + " numObservers: " + this.countObservers());
	 *  }
	 */
}
