//{{{ GPL Notice
/*
 *  ErrorHandler.java
 *  :tabSize=4:indentSize=4:noTabs=false:
 *  :folding=explicit:collapseFolds=1:
 *
 *  part of the ProCol plugin for the jEdit text editor
 *  Copyright (C) 2003-2004 Justin Dieters
 *  enderak@yahoo.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//}}}
package com.enderak.procol.common.util;
import com.enderak.procol.common.net.*;

//{{{ Imports
import com.enderak.procol.common.util.*;
import java.util.Vector;
//}}}

/**
 *  Handles error messages
 *
 *@author    Justin Dieters
 */
public class ErrorHandler implements Runnable {
	//{{{ Data members
	Vector errorQueue              = new Vector();
	ProColIncomingMessage message;
	//}}}

	//{{{ ErrorHandler
	/**  Creates a new error handler */
	public ErrorHandler() { }
	//}}}

	//{{{ addErrorMessage
	/**
	 *  Adds and error message to the queue and tells handler there is a message
	 *  waiting
	 *
	 *@param  message  The message
	 */
	public void addErrorMessage(ProColIncomingMessage message) {
		errorQueue.add(message);
		synchronized (errorQueue) {
			errorQueue.notifyAll();
		}
	}
	//}}}

	//{{{ run
	/**  Main processing method for the ErrorHandler object */
	public void run() {
		while (true) {
			try {
				synchronized (errorQueue) {
					errorQueue.wait();
					while (!errorQueue.isEmpty()) {
						message = (ProColIncomingMessage)errorQueue.remove(0);
						handleMessage(message);
					}
				}
			} catch (InterruptedException ie) {
				System.err.println(ie);
			}
		}
	}
	//}}}

	//{{{ handleMessage
	/**
	 *  Empty, should be overridden by subclasses to actually do something with the
	 *  error messages
	 *
	 *@param  message  The message to handle
	 */
	public void handleMessage(ProColIncomingMessage message) { }
	//}}}
}
