//{{{ GPL Notice
/*
 *  ProColFileComparator.java
 *  :tabSize=4:indentSize=4:noTabs=false:
 *  :folding=explicit:collapseFolds=1:
 *
 *  part of the ProCol plugin for the jEdit text editor
 *  Copyright (C) 2003-2004 Justin Dieters
 *  enderak@yahoo.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//}}}
package com.enderak.procol.common.util;
import java.io.*;

//{{{ Imports
import java.util.*;
//}}}

/**
 *  ProColFileComparator compares two ProCol files for sorting purposes
 *
 *@author    Justin Dieters
 */
public class ProColFileComparator implements Comparator {

	/**
	 *  Compare two ProColFiles
	 *
	 *@param  o1  File 1
	 *@param  o2  File 2
	 *@return     1 if o1 is a file and o2 is a Directory, -1 if o1 is a directory
	 *      and o2 is a file, or the output of comparing the names of the files as
	 *      lowercase strings (i.e. not case-sensitive)
	 */
	public int compare(Object o1, Object o2) {
		File fo1;
		File fo2;

		if (o1 == null || o2 == null) {
			throw new NullPointerException();
		}

		if (o1 instanceof DownloadFile) {
			fo1 = ((DownloadFile)o1).file;
		} else {
			fo1 = (File)o1;
		}

		if (o2 instanceof DownloadFile) {
			fo2 = ((DownloadFile)o2).file;
		} else {
			fo2 = (File)o2;
		}

		if (fo1.isFile() && fo2.isDirectory()) {
			return 1;
		} else if (fo1.isDirectory() && fo2.isFile()) {
			return -1;
		} else {
			return fo1.getName().toLowerCase().compareTo(fo2.getName().toLowerCase());
		}
	}


	/**
	 *  required by Comparator interface, just compares this Compator to the input
	 *  object
	 *
	 *@param  obj  the object to test
	 *@return      True if equal, false otherwise
	 */
	public boolean equals(Object obj) {
		return (compare(this, obj) == 0);
	}
}
