//{{{ GPL Notice
/*
 *  ProColUtils.java
 *  :tabSize=4:indentSize=4:noTabs=false:
 *  :folding=explicit:collapseFolds=1:
 *
 *  part of the ProCol plugin for the jEdit text editor
 *  Copyright (C) 2003-2004 Justin Dieters
 *  enderak@yahoo.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//}}}
package com.enderak.procol.common.util;

//{{{ Imports
import java.util.*;
//}}}

/**
 *  Some misc utility functions used by ProCol
 *
 *@author    Justin Dieters
 */
public class ProColUtils {
	//{{{ dataStringToVector
	/**
	 *  Converts a byte array representing a String into a vector, split based on
	 *  newlines
	 *
	 *@param  dataIn  The byte array
	 *@return         The Vector
	 */
	public static Vector dataStringToVector(byte[] dataIn) {
		StringTokenizer tokenizer  = new StringTokenizer(new String(dataIn), "\n");
		Vector tempVector          = new Vector();
		while (tokenizer.hasMoreTokens()) {
			tempVector.add(tokenizer.nextToken());
		}
		return tempVector;
	}
	//}}}

	//{{{ vectorToString
	/**
	 *  Converts a vector into a newline-delimited String list
	 *
	 *@param  vectorIn  The vector to convert
	 *@return           The string, with vector elements delimited by newlines
	 */
	public static String vectorToString(Vector vectorIn) {
		StringBuffer tempBuffer  = new StringBuffer(getOptimalStringBufferSize(vectorIn));
		for (int i = 0; i < vectorIn.size(); i++) {
			tempBuffer.append(vectorIn.elementAt(i)).append("\n");
		}
		return tempBuffer.toString();
	}
	//}}}

	//{{{ intToByteArray
	/**
	 *  Breaks an int down into a array of bytes
	 *
	 *@param  intIn  The int
	 *@return        The array of bytes ( byte[4] )
	 */
	public static byte[] intToByteArray(int intIn) {
		byte[] temp  = new byte[4];
		temp[0] = (byte)((intIn >> 24));
		temp[1] = (byte)((intIn >> 16));
		temp[2] = (byte)((intIn >> 8));
		temp[3] = (byte)(intIn);
		return temp;
	}
	//}}}

	//{{{ getOptimalStringBufferSize
	private static int getOptimalStringBufferSize(Vector vectorIn) {
		int tempSize  = 0;
		for (int i = 0; i < vectorIn.size(); i++) {
			tempSize += ((String)(vectorIn.elementAt(i))).length();
		}
		return tempSize;
	}
	//}}}
}
