//{{{ GPL Notice
/*
 *  RunProColServer.java
 *  :tabSize=4:indentSize=4:noTabs=false:
 *  :folding=explicit:collapseFolds=1:
 *
 *  part of the ProCol plugin for the jEdit text editor
 *  Copyright (C) 2003-2004 Justin Dieters
 *  enderak@yahoo.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//}}}
package com.enderak.procol.server;
import com.enderak.procol.common.net.*;

import com.enderak.procol.server.net.*;

//{{{ Imports
import java.io.*;
import java.net.*;
import java.util.*;
import org.gjt.sp.jedit.jEdit;
//}}}

/**
 *  Starts the ProCol Server
 *
 *@author    Justin Dieters
 */
public final class RunProColServer {
	//{{{ Data members
	private static ProColServer proColServer  = null;
	private static Thread serverThread;
	//}}}

	//{{{ Main
	/**
	 *  The main program for the RunProColServer class, for starting the Server
	 *  standalone
	 *
	 *@param  args  The command line arguments
	 */
	public static void main(String[] args) {
		checkArgs(args);
		startServer(false); // start server standalone
	}
	//}}}

	//{{{ Server control methods
	/**  Creates a new ProColServer */
	public static void initServer() {
		proColServer = new ProColServer();
	}


	/**
	 *  Starts the ProCol server
	 *
	 *@param  withinJEdit  true if started within jEdit, false if standalone
	 */
	public static void startServer(boolean withinJEdit) {
		if (proColServer == null) {
			initServer();
		}

		if (!proColServer.isRunning()) {
			proColServer.setWithinJEdit(withinJEdit);
			if (withinJEdit) {
				jEdit.getActiveView().getDockableWindowManager().showDockableWindow("procol.server.dockable.log");
			}
			serverThread = new Thread(proColServer);
			serverThread.start();
		}
	}


	/**  Stops the server */
	public static void stopServer() {
		proColServer.stopServer();
	}


	/**
	 *  Starts the server if it is stopped, or stops the server if it is started
	 *
	 *@param  withinJEdit  true if started within jEdit, false if standalone
	 */
	public static void startStopServer(boolean withinJEdit) {
		if (proColServer == null) {
			initServer();
		}
		if (!proColServer.isRunning()) {
			startServer(withinJEdit);
		} else {
			stopServer();
		}
	}
	//}}}

	//{{{ Accessor methods
	/**
	 *  Gets the ProColServer
	 *
	 *@return    The ProColServer
	 */
	public static ProColServer getServer() {
		return proColServer;
	}
	//}}}

	//{{{ Misc methods
	/**
	 *  Handles the command-line arguments, currently does nothing
	 *
	 *@param  args  The arguments
	 */
	private static void checkArgs(String[] args) {
		// TODO: check command-line arguments here
	}
	//}}}
}

