//{{{ GPL Notice
/*
 *  ProCol.java
 *  :tabSize=4:indentSize=4:noTabs=false:
 *  :folding=explicit:collapseFolds=1:
 *
 *  part of the ProCol plugin for the jEdit text editor
 *  Copyright (C) 2003-2004 Justin Dieters
 *  enderak@yahoo.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//}}}
package com.enderak.procol.server.gui;

//{{{ Imports
import com.enderak.procol.*;
import com.enderak.procol.server.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import org.gjt.sp.jedit.*;
import org.gjt.sp.jedit.gui.*;
import org.gjt.sp.jedit.io.*;
//}}}

/**
 *  Main ProColServer Dockcable class. Extended by the various Server windows
 *
 *@author    Justin Dieters
 */
public class ProColServerDockable extends JPanel implements EBComponent, Observer {
	//{{{ Data Members
	View view;
	String position;
	boolean floating;
	boolean isVerticalAlign;
	//}}}

	//{{{ Constructors
	/**
	 *  Constructor for the ProColServerDockable object, called by jEdit using the
	 *  command definition in dockables.xml
	 *
	 *@param  view      Automatically passed by jEdit when dockable plugin window
	 *      is created
	 *@param  position  Automatically passed by jEdit when dockable plugin window
	 *      is created; this contains the docking position of this panel. This is
	 *      used by this class to determine whether to set up interface with a
	 *      horizonal or vertical layout.
	 */
	public ProColServerDockable(View view, String position) {
		super();

		this.view = view;
		this.position = position;
		this.floating = position.equals(DockableWindowManager.FLOATING);
		this.setLayout(new BorderLayout());

		// define size, if floating
		if (floating) {
			this.setPreferredSize(new Dimension(600, 400));
		}

		// determine if panels should have a vertical or horizontal layout
		if (position.equals(DockableWindowManager.TOP) || position.equals(DockableWindowManager.BOTTOM)) {
			this.isVerticalAlign = false;
		} else {
			this.isVerticalAlign = true;
		}
	}
	//}}}

	//{{{ Message display methods
	/**
	 *  Displays an error message box
	 *
	 *@param  titleIn  Title of error box
	 *@param  errorIn  Error message to display
	 */
	public static void displayError(String titleIn, String errorIn) {
		JOptionPane.showMessageDialog(null, errorIn, titleIn, JOptionPane.ERROR_MESSAGE);
	}


	/**
	 *  Displays an informational message box
	 *
	 *@param  titleIn    Title of message box
	 *@param  messageIn  Informational message to display
	 */
	public static void displayInfo(String titleIn, String messageIn) {
		JOptionPane.showMessageDialog(null, messageIn, titleIn, JOptionPane.INFORMATION_MESSAGE);
	}
	//}}}

	//{{{ EditBus methods
	/**  Adds this dockable to the EditBus notification list */
	public void addNotify() {
		super.addNotify();
		EditBus.addToBus(this);
		if (RunProColServer.getServer() != null) {
			RunProColServer.getServer().addObserver(this);
			RunProColServer.getServer().forceNotify();
		} else {
			displayError("No Server!", "RunProColServer.getServer() is null!");
		}
	}


	/**  Removes this dockable from the EditBus notification list */
	public void removeNotify() {
		super.removeNotify();
		EditBus.removeFromBus(this);
		RunProColServer.getServer().deleteObserver(this);
	}


	/**
	 *  Handles EBMessages (EditBus Messages) from jEdit
	 *
	 *@param  message  Message from jEdit's EditBus to handle
	 */
	public void handleMessage(EBMessage message) {
	}
	//}}}

	//{{{ Observer methods
	/**
	 *  Invoked whenever a class that is being observed changes.
	 *
	 *@param  o    the observable object
	 *@param  arg  an argument passed to the notifyObservers method<br>
	 *
	 */
	public void update(Observable o, Object arg) {
	}
	//}}}
}

