//{{{ GPL Notice
/*
 *  ProCol.java
 *  :tabSize=4:indentSize=4:noTabs=false:
 *  :folding=explicit:collapseFolds=1:
 *
 *  part of the ProCol plugin for the jEdit text editor
 *  Copyright (C) 2003-2004 Justin Dieters
 *  enderak@yahoo.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//}}}
package com.enderak.procol.server.gui;

//{{{ Imports
// from ProCol
import com.enderak.procol.*;
import com.enderak.procol.server.*;

// from Java:
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;

// from Swing:
import javax.swing.*;
import javax.swing.event.*;

// from jEdit:
import org.gjt.sp.jedit.*;
import org.gjt.sp.jedit.gui.*;
import org.gjt.sp.jedit.io.*;
//}}}

/**
 *  Admin window for the ProColServer
 *
 *@author    Justin Dieters
 */
public class ProColServerDockableAdmin extends ProColServerDockable {
	//{{{ Data Members
	private ServerAdminPanel serverAdminPanel  = new ServerAdminPanel();
	//}}}

	//{{{ Constructors
	/**
	 *  Constructor for the ProColServerDockableAdmin object, called by jEdit using
	 *  the command definition in dockables.xml
	 *
	 *@param  view      Automatically passed by jEdit when dockable plugin window
	 *      is created
	 *@param  position  Automatically passed by jEdit when dockable plugin window
	 *      is created; this contains the docking position of this panel. This is
	 *      used by this class to determine whether to set up interface with a
	 *      horizonal or vertical layout.
	 */
	public ProColServerDockableAdmin(View view, String position) {
		super(view, position);

		if (this.isVerticalAlign) {
			this.add(serverAdminPanel);
		} else {
			this.add(serverAdminPanel);
		}
	}
	//}}}

	//{{{ EditBus methods
	/**
	 *  Adds this dockable to the EditBus notification list
	 *
	 *@param  message  Description of the Parameter
	 */
	/*
	 *  public void addNotify() {
	 *  super.addNotify();
	 *  }
	 *  **
	 *  Removes this dockable from the EditBus notification list
	 */
	/*
	 *  public void removeNotify() {
	 *  super.removeNotify();
	 *  EditBus.removeFromBus(this);
	 *  /RunProColServer.getServer().deleteObserver(this);
	 *  }
	 */
	/**
	 *  Handles EBMessages (EditBus Messages) from jEdit
	 *
	 *@param  message  Message from jEdit's EditBus to handle
	 */
	public void handleMessage(EBMessage message) {
		//printInfo("got EBMessage");
	}
	//}}}

	//{{{ Observer methods
	/**
	 *  Invoked whenever a class that is being observed changes.
	 *
	 *@param  o    the observable object
	 *@param  arg  an argument passed to the notifyObservers method<br>
	 *
	 */
	public void update(Observable o, Object arg) {
	}
	//}}}
}

