//{{{ GPL Notice
/*
 *  ServerTabbedPane.java
 *  :tabSize=4:indentSize=4:noTabs=false:
 *  :folding=explicit:collapseFolds=1:
 *
 *  part of the ProCol plugin for the jEdit text editor
 *  Copyright (C) 2003-2004 Justin Dieters
 *  enderak@yahoo.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//}}}
package com.enderak.procol.server.gui;

//{{{ Imports
// from ProCol
import com.enderak.procol.*;
import com.enderak.procol.server.*;

// from Java:
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;

// from Swing:
import javax.swing.*;
import javax.swing.event.*;

// from jEdit:
import org.gjt.sp.jedit.*;
import org.gjt.sp.jedit.gui.*;
import org.gjt.sp.jedit.io.*;
//}}}

/**
 *  Admin panel for the ProColServer, currently doesn't do anything
 *
 *@author    Justin Dieters
 */
public class ServerAdminPanel extends JPanel {
	//{{{ Data Members
	JTextArea adminTextArea              = new JTextArea();
	private JScrollPane adminScrollPane  = new JScrollPane(adminTextArea);
	//}}}

	//{{{ Constructors

	/**  Create the panel */
	public ServerAdminPanel() {
		setLayout(new java.awt.BorderLayout());
		this.setAlignmentX(Component.CENTER_ALIGNMENT);
		this.setBorder(new javax.swing.border.TitledBorder(jEdit.getProperty("procol.server.admin.toplabel")));
		this.add(adminScrollPane, BorderLayout.CENTER);
	}
	//}}}
}

