//{{{ GPL Notice
/*
 *  ServerTabbedPane.java
 *  :tabSize=4:indentSize=4:noTabs=false:
 *  :folding=explicit:collapseFolds=1:
 *
 *  part of the ProCol plugin for the jEdit text editor
 *  Copyright (C) 2003-2004 Justin Dieters
 *  enderak@yahoo.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//}}}
package com.enderak.procol.server.gui;

//{{{ Imports
import com.enderak.procol.*;
import com.enderak.procol.server.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import org.gjt.sp.jedit.*;
import org.gjt.sp.jedit.gui.*;
import org.gjt.sp.jedit.io.*;
//}}}

/**
 *  Log panel for the ProColServer, currently just displays output in a textArea
 *
 *@author    Justin Dieters
 */
public class ServerLogPanel extends JPanel {
	//{{{ Data Members
	JTextArea logTextArea              = new JTextArea();
	private JScrollPane logScrollPane  = new JScrollPane(logTextArea);
	//}}}

	//{{{ Constructors

	/**  Create the panel */
	public ServerLogPanel() {
		setLayout(new java.awt.BorderLayout());
		this.setAlignmentX(Component.CENTER_ALIGNMENT);

		logTextArea.setLineWrap(true);
		logTextArea.setWrapStyleWord(true);
		logTextArea.setEditable(false);

		this.setBorder(new javax.swing.border.TitledBorder(jEdit.getProperty("procol.server.log.toplabel")));
		this.add(logScrollPane, BorderLayout.CENTER);
	}
	//}}}

	//{{{ Print
	/**
	 *@param  printIn  Description of the Parameter
	 */
	public void println(String printIn) {
		logTextArea.append("\n" + printIn);
		logTextArea.setCaretPosition(logTextArea.getDocument().getLength());
	}
	//}}}
}

