//{{{ GPL Notice
/*
 *  ProColServerFileFilter.java
 *  :tabSize=4:indentSize=4:noTabs=false:
 *  :folding=explicit:collapseFolds=1:
 *
 *  part of the ProCol plugin for the jEdit text editor
 *  Copyright (C) 2003-2004 Justin Dieters
 *  enderak@yahoo.com
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//}}}
package com.enderak.procol.server.util;

import com.enderak.procol.server.net.ProColServer;

//{{{ Imports
import java.io.*;
//}}}

/**
 *  Filter to determine if a file is a ProCol project directory
 *
 *@author    Justin Dieters
 */
public class ProjectFileFilter implements FileFilter {
	/**
	 *  Tests for pathname/pathname.props file to determine if pathname is a
	 *  project directory
	 *
	 *@param  pathname  The file to test
	 *@return           True if pathname/pathname.props exists, indicating the file
	 *      is a project directory
	 */
	public boolean accept(File pathname) {
		boolean accepted  = new File(pathname.getPath() + File.separator + pathname.getName() + ".props").exists();
		if (!accepted) {
			ProColServer.printErr("Invalid project: " + pathname.getName() + " (" + pathname.getPath() + File.separator + pathname.getName() + ".props not found)");
		}
		return (accepted);
	}
}

