/*
 * Decompiled with CFR 0.152.
 */
package com.enderak.procol.client.gui;

import com.enderak.procol.ProColPlugin;
import com.enderak.procol.client.gui.GenericUploadPanel;
import com.enderak.procol.client.gui.ProColClientDockable;
import com.enderak.procol.common.gui.ButtonPanel;
import com.enderak.procol.common.model.ProColFile;
import com.enderak.procol.common.net.ProColIncomingMessage;
import com.enderak.procol.common.util.DownloadFile;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.util.Hashtable;
import java.util.Observable;
import javax.swing.DefaultListModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;

public class CheckInPanel
extends GenericUploadPanel {
    protected static Hashtable waitingFiles = new Hashtable();
    protected static DefaultListModel listModel = new DefaultListModel();
    private RolloverButton checkinButton;

    public CheckInPanel(View view, String string) {
        super(view, string, "checkin");
        this.fileList.setModel(listModel);
        ButtonPanel buttonPanel = new ButtonPanel(this.isVerticalAlign);
        this.checkinButton = buttonPanel.createRolloverButton("checkin.file");
        this.checkinButton.addActionListener((ActionListener)this);
        if (this.isVerticalAlign) {
            this.add((Component)buttonPanel, "North");
        } else {
            this.add((Component)buttonPanel, "West");
        }
    }

    public void addFile(ProColFile proColFile, URI uRI) {
        listModel.addElement(new DownloadFile(proColFile, uRI));
        this.fileList.setModel(listModel);
        this.fileList.setSelectedIndex(0);
    }

    public void removeFile(DownloadFile downloadFile) {
        listModel.removeElement(downloadFile);
        if (listModel.isEmpty()) {
            ProColPlugin.getClient().getIMH().deleteObserver(this);
            jEdit.getActiveView().getDockableWindowManager().hideDockableWindow("procol.client.dockable.checkin");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("checkin.file")) {
            this.newMajor = (Integer)this.major.getValue();
            this.newMinor = (Integer)this.minor.getValue();
            this.newRevision = (Integer)this.revision.getValue();
            this.changeLog = this.changeLogTextArea.getText();
            ProColPlugin.getClient().getIMH().addObserver(this);
            for (int i = 0; i < this.selectedFiles.length; ++i) {
                DownloadFile downloadFile = (DownloadFile)this.selectedFiles[i];
                ProColFile proColFile = downloadFile.file;
                int[] nArray = proColFile.getVersionAsArray();
                URI uRI = downloadFile.destURI;
                System.out.println("||||| " + uRI);
                waitingFiles.put(uRI, downloadFile);
                if (this.incrementRadioButton.isSelected()) {
                    ProColPlugin.getClient().getPacketFactory().addToQueue(197636, uRI + "\n" + (this.newMajor + nArray[0]) + "." + (this.newMinor + nArray[1]) + "." + (this.newRevision + nArray[2]) + "\n" + this.changeLog, 1);
                    continue;
                }
                if (this.absoluteRadioButton.isSelected()) {
                    ProColPlugin.getClient().getPacketFactory().addToQueue(197636, uRI + "\n" + this.newMajor + "." + this.newMinor + "." + this.newRevision + "\n" + this.changeLog, 1);
                    continue;
                }
                if (!this.noChangeRadioButton.isSelected()) continue;
                ProColPlugin.getClient().getPacketFactory().addToQueue(197636, uRI + "\n" + nArray[0] + "." + nArray[1] + "." + nArray[2] + "\n" + this.changeLog, 1);
            }
        }
        this.validateVersionSpinners();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.selectedFiles = this.fileList.getSelectedValues();
        if (this.selectedFiles.length == 1) {
            this.checkinButton.setEnabled(true);
            this.newInfoPanel.setBorder(new TitledBorder(((DownloadFile)this.selectedFiles[0]).file.getName() + " v." + ((DownloadFile)this.selectedFiles[0]).file.getVersion()));
        } else if (this.selectedFiles.length > 1) {
            this.checkinButton.setEnabled(true);
            this.newInfoPanel.setBorder(new TitledBorder("(" + this.selectedFiles.length + " " + jEdit.getProperty((String)"procol.label.multiplefilesselected")));
        } else {
            this.checkinButton.setEnabled(false);
            this.newInfoPanel.setBorder(new TitledBorder("(" + jEdit.getProperty((String)"procol.label.nofilesselected") + ")"));
        }
        this.validateVersionSpinners();
    }

    public void update(Observable observable, Object object) {
        if (object instanceof ProColIncomingMessage) {
            ProColIncomingMessage proColIncomingMessage = (ProColIncomingMessage)object;
            switch (proColIncomingMessage.requestCode) {
                case 197637: {
                    URI uRI = URI.create(new String(proColIncomingMessage.data));
                    DownloadFile downloadFile = (DownloadFile)waitingFiles.get(uRI);
                    ProColPlugin.getClient().getPacketFactory().addToQueue(197638, uRI, (File)downloadFile.file, 0);
                    break;
                }
                case 197639: {
                    URI uRI = URI.create(new String(proColIncomingMessage.data));
                    DownloadFile downloadFile = (DownloadFile)waitingFiles.get(uRI);
                    waitingFiles.remove(downloadFile);
                    this.removeFile(downloadFile);
                    break;
                }
                case -268237584: {
                    ProColPlugin.getClient().getIMH().deleteObserver(this);
                    ProColClientDockable.displayError(jEdit.getProperty((String)"procol.client.error.checkin.title"), jEdit.getProperty((String)"procol.client.error.alreadycheckedin"));
                    break;
                }
                case -268237583: {
                    ProColPlugin.getClient().getIMH().deleteObserver(this);
                    ProColClientDockable.displayError(jEdit.getProperty((String)"procol.client.error.checkin.title"), jEdit.getProperty((String)"procol.client.error.filename"));
                    break;
                }
                case -268237582: {
                    ProColPlugin.getClient().getIMH().deleteObserver(this);
                    ProColClientDockable.displayError(jEdit.getProperty((String)"procol.client.error.checkin.title"), jEdit.getProperty((String)"procol.client.error.versionoverwrite"));
                    break;
                }
                case -268237581: {
                    ProColPlugin.getClient().getIMH().deleteObserver(this);
                    ProColClientDockable.displayError(jEdit.getProperty((String)"procol.client.error.checkin.title"), jEdit.getProperty((String)"procol.client.error.versionold"));
                    break;
                }
                case -268237580: {
                    ProColPlugin.getClient().getIMH().deleteObserver(this);
                    ProColClientDockable.displayError(jEdit.getProperty((String)"procol.client.error.checkin.title"), jEdit.getProperty((String)"procol.client.error.versionioerror"));
                    break;
                }
                case -268237579: {
                    ProColPlugin.getClient().getIMH().deleteObserver(this);
                    ProColClientDockable.displayError(jEdit.getProperty((String)"procol.client.error.checkin.title"), jEdit.getProperty((String)"procol.client.error.filenotfound"));
                    break;
                }
                case -268237578: {
                    ProColPlugin.getClient().getIMH().deleteObserver(this);
                    ProColClientDockable.displayError(jEdit.getProperty((String)"procol.client.error.upload.title"), jEdit.getProperty((String)"procol.client.error.fileioerror"));
                    break;
                }
                case -268237569: {
                    ProColPlugin.getClient().getIMH().deleteObserver(this);
                    ProColClientDockable.displayError(jEdit.getProperty((String)"procol.client.error.checkin.title"), jEdit.getProperty((String)"procol.client.error.undefined"));
                    break;
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        ProColPlugin.getClient().getIMH().deleteObserver(this);
    }
}

