/*
 * Decompiled with CFR 0.152.
 */
package com.enderak.procol.client.gui;

import com.enderak.procol.ProColPlugin;
import com.enderak.procol.client.gui.JoinProjectFrame;
import com.enderak.procol.client.gui.ProColClientDockable;
import com.enderak.procol.client.model.ProColClientUser;
import com.enderak.procol.client.net.ProColClient;
import com.enderak.procol.common.net.ProColIncomingMessage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.gjt.sp.jedit.jEdit;

public class LoginFrame
extends JFrame {
    private LoginPanel panel;

    public LoginFrame(String string) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        this.setTitle(jEdit.getProperty((String)"procol.client.login.title"));
        this.panel = new LoginPanel(this, string);
        this.getContentPane().add(this.panel);
        this.setSize(400, 300);
        this.setLocation(dimension.width / 2 - this.getWidth() / 2, dimension.height / 2 - this.getHeight() / 2);
        this.setVisible(true);
    }

    public void dispose() {
        super.dispose();
        ProColPlugin.getClient().getIMH().deleteObserver(this.panel);
    }

    private class LoginPanel
    extends JPanel
    implements Observer {
        private JEditorPane projectInfo;
        private JScrollPane scrollPane;
        private LoginFrame parentFrame;
        private JTextField userField = new JTextField(jEdit.getProperty((String)"options.procol.client.default.user"), 8);
        private JPasswordField passwordField = new JPasswordField("", 7);

        public LoginPanel(LoginFrame loginFrame2, String string) {
            this.parentFrame = loginFrame2;
            ProColPlugin.getClient().getIMH().addObserver(this);
            this.setLayout(new BorderLayout());
            this.setBorder(new TitledBorder(jEdit.getProperty((String)"procol.client.login.title")));
            this.projectInfo = new JEditorPane("text/html", string);
            this.projectInfo.setEditable(false);
            this.scrollPane = new JScrollPane(this.projectInfo);
            JButton jButton = new JButton("OK");
            jButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ LoginPanel this$1;
                {
                    this.this$1 = loginPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ProColPlugin.getClient().authenticateUser(LoginPanel.access$000(this.this$1).getText(), new String(LoginPanel.access$100(this.this$1).getPassword()));
                }
            });
            JButton jButton2 = new JButton("Cancel");
            jButton2.addActionListener(new ActionListener(this){
                private final /* synthetic */ LoginPanel this$1;
                {
                    this.this$1 = loginPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ProColPlugin.getClient().disconnect();
                    LoginPanel.access$200(this.this$1).dispose();
                }
            });
            Box box = Box.createHorizontalBox();
            Box box2 = Box.createVerticalBox();
            Box box3 = Box.createVerticalBox();
            Box box4 = Box.createVerticalBox();
            box2.add(new JLabel("Username"));
            box3.add(new JLabel("Password"));
            box2.add(this.userField);
            box3.add(this.passwordField);
            box.add(box2);
            box.add(box3);
            JPanel jPanel = new JPanel();
            jPanel.add(jButton);
            jPanel.add(jButton2);
            box4.add(box);
            box4.add(jPanel);
            this.add((Component)this.scrollPane, "Center");
            this.add((Component)box4, "South");
            this.userField.selectAll();
        }

        public void update(Observable observable, Object object) {
            if (object instanceof ProColIncomingMessage) {
                ProColClient proColClient = ProColPlugin.getClient();
                ProColIncomingMessage proColIncomingMessage = (ProColIncomingMessage)object;
                switch (proColIncomingMessage.requestCode) {
                    case 257: {
                        String string = new String(proColIncomingMessage.data);
                        proColClient.setUser(new ProColClientUser(string));
                        jEdit.setProperty((String)"options.procol.client.default.user", (String)string);
                        proColClient.getUser().setAuthenticated(true);
                        new JoinProjectFrame();
                        ProColClientDockable.proColPanel.stopProgress();
                        this.parentFrame.dispose();
                        break;
                    }
                    case -268435198: {
                        ProColClientDockable.displayError(jEdit.getProperty((String)"procol.client.error.authentication.title"), new String(proColIncomingMessage.data) + " " + jEdit.getProperty((String)"procol.client.error.authentication.userloggedin"));
                        ProColClientDockable.proColPanel.stopProgress();
                        break;
                    }
                    case -268435197: {
                        ProColClientDockable.displayError(jEdit.getProperty((String)"procol.client.error.authentication.title"), new String(proColIncomingMessage.data) + " " + jEdit.getProperty((String)"procol.client.error.authentication.userdoesnotexist"));
                        ProColClientDockable.proColPanel.stopProgress();
                        break;
                    }
                    case -268435196: {
                        ProColClientDockable.displayError(jEdit.getProperty((String)"procol.client.error.authentication.title"), jEdit.getProperty((String)"procol.client.error.authentication.password"));
                        ProColClientDockable.proColPanel.stopProgress();
                        break;
                    }
                    case -268435195: {
                        ProColClientDockable.displayError(jEdit.getProperty((String)"procol.client.error.authentication.title"), jEdit.getProperty((String)"procol.client.error.undefined"));
                        ProColClientDockable.proColPanel.stopProgress();
                        break;
                    }
                }
            }
        }

        static /* synthetic */ JTextField access$000(LoginPanel loginPanel) {
            return loginPanel.userField;
        }

        static /* synthetic */ JPasswordField access$100(LoginPanel loginPanel) {
            return loginPanel.passwordField;
        }

        static /* synthetic */ LoginFrame access$200(LoginPanel loginPanel) {
            return loginPanel.parentFrame;
        }
    }
}

