/*
 * Decompiled with CFR 0.152.
 */
package com.enderak.procol.client.gui;

import com.enderak.procol.ProColPlugin;
import com.enderak.procol.client.gui.CheckInPanel;
import com.enderak.procol.client.gui.ProColPanel;
import com.enderak.procol.client.model.ProColClientProject;
import com.enderak.procol.common.model.ProColFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.net.URI;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;

public class ProColClientDockable
extends JPanel
implements EBComponent {
    public static ProColPanel proColPanel;
    private View view;
    private String position;
    private String currentlySavingBuffer;
    private boolean floating;
    private boolean isVerticalAlign;

    public ProColClientDockable(View view, String string) {
        this.view = view;
        this.position = string;
        this.floating = string.equals("floating");
        this.setLayout(new BorderLayout());
        if (this.floating) {
            this.setPreferredSize(new Dimension(250, 500));
        }
        this.isVerticalAlign = !string.equals("top") && !string.equals("bottom");
        proColPanel = new ProColPanel(this.isVerticalAlign);
        this.add((Component)proColPanel, "Center");
    }

    public static void displayError(String string, String string2) {
        JOptionPane.showMessageDialog(null, string2, string, 0);
    }

    public static void displayInfo(String string, String string2) {
        JOptionPane.showMessageDialog(null, string2, string, 1);
    }

    public void addNotify() {
        super.addNotify();
        EditBus.addToBus((EBComponent)this);
        ProColPlugin.getClient().addObserver(proColPanel);
        ProColPlugin.getClient().getMessageFactory().addObserver(proColPanel);
        ProColPlugin.getClient().forceNotify();
    }

    public void removeNotify() {
        super.removeNotify();
        EditBus.removeFromBus((EBComponent)this);
        ProColPlugin.getClient().deleteObserver(proColPanel);
        ProColPlugin.getClient().getMessageFactory().deleteObserver(proColPanel);
        ProColPlugin.getClient().forceNotify();
    }

    public void handleMessage(EBMessage eBMessage) {
        if (ProColPlugin.getClient().isConnected() && eBMessage instanceof BufferUpdate) {
            Buffer buffer = ((BufferUpdate)eBMessage).getBuffer();
            if (ProColPlugin.getClient().getProject().isOpenBuffer(buffer)) {
                Object object = ((BufferUpdate)eBMessage).getWhat();
                if (object == BufferUpdate.CLOSED) {
                    this.handleClosedBuffer(((BufferUpdate)eBMessage).getBuffer());
                } else if (object == BufferUpdate.SAVING) {
                    this.currentlySavingBuffer = ((BufferUpdate)eBMessage).getBuffer().getPath();
                } else if (object == BufferUpdate.SAVED) {
                    if (buffer.getPath().equals(this.currentlySavingBuffer)) {
                        this.handleSavedBuffer(((BufferUpdate)eBMessage).getBuffer());
                    } else {
                        ProColClientDockable.displayInfo("File saved to alternate location", new File(this.currentlySavingBuffer).getName() + " was saved to alternate location,\nChecking original back with server.");
                    }
                }
            }
        }
    }

    public void openProject(String string) {
        ProColClientDockable.proColPanel.projectPanel.setBorder(new TitledBorder(string));
    }

    private void handleClosedBuffer(Buffer buffer) {
        ProColClientProject proColClientProject = ProColPlugin.getClient().getProject();
        ProColFile proColFile = proColClientProject.getFileForBuffer(buffer);
        URI uRI = proColClientProject.getProjectFilesURI();
        String string = jEdit.getProperty((String)"options.procol.client.checkinonclose", (String)"modified");
        if (string.equals("yes")) {
            DockableWindowManager dockableWindowManager = jEdit.getActiveView().getDockableWindowManager();
            dockableWindowManager.showDockableWindow("procol.client.dockable.checkin");
            ((CheckInPanel)dockableWindowManager.getDockableWindow("procol.client.dockable.checkin")).addFile(proColFile, uRI.relativize(uRI.resolve(proColFile.toURI())));
        } else if (string.equals("modified") && proColClientProject.isModifiedBuffer(buffer)) {
            DockableWindowManager dockableWindowManager = jEdit.getActiveView().getDockableWindowManager();
            dockableWindowManager.showDockableWindow("procol.client.dockable.checkin");
            ((CheckInPanel)dockableWindowManager.getDockableWindow("procol.client.dockable.checkin")).addFile(proColFile, uRI.relativize(uRI.resolve(proColFile.toURI())));
        } else if (string.equals("modified") && !proColClientProject.isModifiedBuffer(buffer)) {
            ProColPlugin.getClient().getPacketFactory().addToQueue(197634, uRI.relativize(uRI.resolve(proColFile.toURI())).toString(), 1);
        } else if (string.equals("ask") && JOptionPane.showConfirmDialog(null, "Check in " + buffer.getName() + "?", "Buffer Closed", 0, 3) == 0) {
            DockableWindowManager dockableWindowManager = jEdit.getActiveView().getDockableWindowManager();
            dockableWindowManager.showDockableWindow("procol.client.dockable.checkin");
            ((CheckInPanel)dockableWindowManager.getDockableWindow("procol.client.dockable.checkin")).addFile(proColFile, uRI.relativize(uRI.resolve(proColFile.toURI())));
        }
        proColClientProject.removeBuffer(buffer);
    }

    private void handleSavedBuffer(Buffer buffer) {
        ProColClientProject proColClientProject = ProColPlugin.getClient().getProject();
        URI uRI = proColClientProject.getProjectFilesURI();
        proColClientProject.addModifiedBuffer(buffer);
        String string = jEdit.getProperty((String)"options.procol.client.updateonsave", (String)"no");
        String string2 = jEdit.getProperty((String)"options.procol.client.updateonsave", (String)"no");
        ProColFile proColFile = proColClientProject.getFileForBuffer(buffer);
        if (string.equals("yes")) {
            ProColPlugin.getClient().updateFile(proColFile);
        } else if (string.equals("ask") && JOptionPane.showConfirmDialog(null, "Upload changes to " + buffer.getName() + "?", "Buffer Saved", 0, 3) == 0) {
            ProColPlugin.getClient().updateFile(proColFile);
        }
        if (string2.equals("yes")) {
            DockableWindowManager dockableWindowManager = jEdit.getActiveView().getDockableWindowManager();
            dockableWindowManager.showDockableWindow("procol.client.dockable.checkin");
            ((CheckInPanel)dockableWindowManager.getDockableWindow("procol.client.dockable.checkin")).addFile(proColFile, uRI.relativize(uRI.resolve(proColFile.toURI())));
        } else if (string2.equals("ask") && JOptionPane.showConfirmDialog(null, "Check in " + buffer.getName() + "?", "Buffer Saved", 0, 3) == 0) {
            DockableWindowManager dockableWindowManager = jEdit.getActiveView().getDockableWindowManager();
            dockableWindowManager.showDockableWindow("procol.client.dockable.checkin");
            ((CheckInPanel)dockableWindowManager.getDockableWindow("procol.client.dockable.checkin")).addFile(proColFile, uRI.relativize(uRI.resolve(proColFile.toURI())));
        }
    }
}

