/*
 * Decompiled with CFR 0.152.
 */
package com.enderak.procol.client.gui;

import com.enderak.procol.ProColPlugin;
import com.enderak.procol.client.gui.FileInfoFrame;
import com.enderak.procol.client.gui.ProColClientDockable;
import com.enderak.procol.client.gui.ProColTree;
import com.enderak.procol.client.model.ProColClientProject;
import com.enderak.procol.common.gui.ButtonPanel;
import com.enderak.procol.common.model.ProColFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;

public class ProjectPanel
extends JPanel {
    private ButtonPanel projectButtonPanel;
    private JScrollPane projectScrollPane;
    private ProColTree projectTree;
    private DefaultMutableTreeNode projectFilesRootNode;
    private DefaultTreeModel treeModel;
    private RolloverButton snapshotButton;
    private RolloverButton newFileButton;
    private RolloverButton newDirButton;
    private RolloverButton uploadFileButton;
    private RolloverButton uploadDirButton;

    public ProjectPanel(boolean bl) {
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder(jEdit.getProperty((String)"procol.client.project.toplabel")));
        this.projectButtonPanel = new ButtonPanel(bl);
        this.projectScrollPane = new JScrollPane();
        this.projectTree = new ProColTree();
        this.projectTree.setRootVisible(false);
        this.projectTree.setShowsRootHandles(true);
        this.projectTree.setDragEnabled(true);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (ProColPlugin.getClient().isConnected() && ProColPlugin.getClient().isAuthenticated()) {
                    TreePath treePath = ProjectPanel.this.projectTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (mouseEvent.getButton() == 3) {
                        if (!ProjectPanel.this.projectTree.isPathSelected(treePath) && treePath != null) {
                            ProjectPanel.this.projectTree.setSelectionPath(treePath);
                        }
                        if (treePath != null) {
                            new ProjectPopupMenu(ProjectPanel.this.projectTree.getSelectionPaths()).show((JComponent)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
                        } else {
                            new ProjectPopupMenu(null).show((JComponent)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
                        }
                    } else if (mouseEvent.getButton() == 2) {
                        ProjectPanel.this.projectTree.setSelectionPath(treePath);
                        ProColClientDockable.displayInfo("File Info", treePath.toString());
                    } else if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2 && ((ProColFile)((DefaultMutableTreeNode)ProjectPanel.this.projectTree.getSelectionPath().getLastPathComponent()).getUserObject()).isFile()) {
                        ProColPlugin.getClient().checkOutFile(ProjectPanel.this.projectTree.getSelectionPaths());
                    }
                }
            }
        };
        this.projectTree.addMouseListener(mouseAdapter);
        this.projectScrollPane.setViewportView(this.projectTree);
        this.add((Component)this.projectScrollPane, "Center");
        this.snapshotButton = this.projectButtonPanel.createButton("snapshot");
        this.snapshotButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProColPlugin.getClient().downloadSnapshot();
            }
        });
        this.newFileButton = this.projectButtonPanel.createButton("create.file");
        this.newFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProColPlugin.getClient().newFile(ProjectPanel.this.projectTree.getSelectionPaths());
            }
        });
        this.newDirButton = this.projectButtonPanel.createButton("create.dir");
        this.newDirButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProColPlugin.getClient().newDir(ProjectPanel.this.projectTree.getSelectionPaths());
            }
        });
        this.uploadFileButton = this.projectButtonPanel.createButton("upload.file");
        this.uploadFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProColPlugin.getClient().uploadFiles();
            }
        });
        this.uploadDirButton = this.projectButtonPanel.createButton("upload.dir");
        this.uploadDirButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProColPlugin.getClient().uploadDirs();
            }
        });
        if (bl) {
            this.add((Component)this.projectButtonPanel, "South");
        } else {
            this.add((Component)this.projectButtonPanel, "East");
        }
    }

    public void setConnected(boolean bl) {
        this.snapshotButton.setEnabled(bl);
        this.newFileButton.setEnabled(bl);
        this.newDirButton.setEnabled(bl);
        this.uploadFileButton.setEnabled(bl);
        this.uploadDirButton.setEnabled(bl);
        this.setProject(ProColPlugin.getClient().getProject());
        this.projectTree.setModel(this.treeModel);
    }

    public void setProject(ProColClientProject proColClientProject) {
        if (proColClientProject != null) {
            this.setBorder(new TitledBorder(proColClientProject.getName()));
            this.projectFilesRootNode = proColClientProject.getProjectFilesRootNode();
            this.treeModel = new DefaultTreeModel(this.projectFilesRootNode);
        } else {
            this.setBorder(new TitledBorder(jEdit.getProperty((String)"procol.client.project.toplabel")));
            this.projectFilesRootNode = null;
            this.treeModel = null;
        }
        this.projectTree.setModel(this.treeModel);
    }

    public void nodeChanged(TreeNode treeNode) {
        this.treeModel.nodeChanged(treeNode);
        this.treeModel.reload();
    }

    public void nodesWereInserted(TreeNode treeNode, int[] nArray) {
        this.treeModel.nodesWereInserted(treeNode, nArray);
        this.treeModel.reload();
    }

    public URI getCurrentDirectoryURI() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.projectFilesRootNode;
        TreePath treePath = this.projectTree.getSelectionPath();
        if (treePath != null) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        }
        ProColFile proColFile = (ProColFile)defaultMutableTreeNode.getUserObject();
        while (!proColFile.isDirectory()) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            proColFile = (ProColFile)defaultMutableTreeNode.getUserObject();
        }
        return ((ProColFile)this.projectFilesRootNode.getUserObject()).toURI().relativize(proColFile.toURI());
    }

    private class ProjectPopupMenu
    extends JPopupMenu {
        private MenuHandler menuHandler = new MenuHandler();
        private TreePath[] selectedPaths;
        private DefaultMutableTreeNode tempNode;
        private ProColFile tempFile;

        public ProjectPopupMenu(TreePath[] treePathArray) {
            try {
                boolean bl = false;
                boolean bl2 = true;
                boolean bl3 = true;
                this.selectedPaths = treePathArray;
                if (this.selectedPaths != null) {
                    bl = this.selectedPaths.length == 1;
                    for (int i = 0; i < this.selectedPaths.length && (bl3 || bl2); ++i) {
                        this.tempNode = (DefaultMutableTreeNode)this.selectedPaths[i].getLastPathComponent();
                        this.tempFile = (ProColFile)this.tempNode.getUserObject();
                        if (this.tempFile.isCheckedOut()) {
                            bl3 = false;
                        }
                        if (this.tempFile.isCheckedOutBy(ProColPlugin.getClient().getUser().getName())) continue;
                        bl2 = false;
                    }
                    if (bl3) {
                        this.add(this.createMenuItem("checkout"));
                    } else if (bl2) {
                        this.add(this.createMenuItem("checkin"));
                    }
                    this.add(this.createMenuItem("download"));
                    if (bl && bl3) {
                        this.add(this.createMenuItem("rename"));
                    }
                    if (bl3) {
                        this.add(this.createMenuItem("delete"));
                    }
                    this.addSeparator();
                }
                this.add(this.createMenuItem("create.file"));
                this.add(this.createMenuItem("create.dir"));
                this.add(this.createMenuItem("upload.file"));
                this.add(this.createMenuItem("upload.dir"));
                if (this.selectedPaths != null && bl) {
                    this.addSeparator();
                    this.add(this.createMenuItem("fileinfo"));
                }
            }
            catch (NullPointerException nullPointerException) {
                return;
            }
        }

        private JMenuItem createMenuItem(String string) {
            JMenuItem jMenuItem = new JMenuItem(jEdit.getProperty((String)("procol.client." + string + ".label")));
            jMenuItem.setActionCommand(string);
            jMenuItem.addActionListener(this.menuHandler);
            return jMenuItem;
        }

        private class MenuHandler
        implements ActionListener {
            private MenuHandler() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("checkout")) {
                    ProColPlugin.getClient().checkOutFile(ProjectPopupMenu.this.selectedPaths);
                } else if (string.equals("download")) {
                    ProColPlugin.getClient().downloadFile(ProjectPopupMenu.this.selectedPaths);
                } else if (string.equals("rename")) {
                    ProColPlugin.getClient().renameFile(ProjectPopupMenu.this.selectedPaths);
                } else if (string.equals("delete")) {
                    ProColPlugin.getClient().deleteFile(ProjectPopupMenu.this.selectedPaths);
                } else if (string.equals("upload.file")) {
                    ProColPlugin.getClient().uploadFiles();
                } else if (string.equals("upload.dir")) {
                    ProColPlugin.getClient().uploadDirs();
                } else if (string.equals("create.file")) {
                    ProColPlugin.getClient().newFile(ProjectPopupMenu.this.selectedPaths);
                } else if (string.equals("create.dir")) {
                    ProColPlugin.getClient().newDir(ProjectPopupMenu.this.selectedPaths);
                } else if (string.equals("fileinfo")) {
                    ProjectPopupMenu.this.tempNode = (DefaultMutableTreeNode)ProjectPopupMenu.this.selectedPaths[0].getLastPathComponent();
                    ProjectPopupMenu.this.tempFile = (ProColFile)ProjectPopupMenu.this.tempNode.getUserObject();
                    new FileInfoFrame(ProjectPopupMenu.this.tempFile);
                }
            }
        }
    }
}

