/*
 * Decompiled with CFR 0.152.
 */
package com.enderak.procol.client.gui;

import com.enderak.procol.ProColPlugin;
import com.enderak.procol.client.gui.GenericListPanel;
import com.enderak.procol.client.gui.PublicMessageComposer;
import com.enderak.procol.client.model.PublicMessage;
import com.enderak.procol.common.gui.ButtonPanel;
import com.enderak.procol.common.net.ProColIncomingMessage;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Observable;
import java.util.Properties;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ListSelectionEvent;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;

public class PublicMessagePanel
extends GenericListPanel {
    protected static DefaultListModel listModel = new DefaultListModel();
    private RolloverButton newButton;
    private RolloverButton replyButton;
    private RolloverButton deleteButton;

    public PublicMessagePanel(View view, String string) {
        super(view, string, "publicmessages");
        listModel.clear();
        this.itemList.setModel(listModel);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = PublicMessagePanel.this.itemList.locationToIndex(mouseEvent.getPoint());
                PublicMessagePanel.this.itemList.setSelectedIndex(n);
                if (mouseEvent.getButton() == 3) {
                    new PublicMessagePopupMenu((PublicMessage)PublicMessagePanel.this.itemList.getModel().getElementAt(n)).show((JComponent)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        };
        this.itemList.addMouseListener(mouseAdapter);
        ButtonPanel buttonPanel = new ButtonPanel(this.isVerticalAlign);
        this.newButton = buttonPanel.createRolloverButton("publicmessages.new");
        this.newButton.addActionListener((ActionListener)this);
        this.replyButton = buttonPanel.createRolloverButton("publicmessages.reply");
        this.replyButton.addActionListener((ActionListener)this);
        buttonPanel.createRigidSpace();
        this.deleteButton = buttonPanel.createRolloverButton("publicmessages.delete");
        this.deleteButton.addActionListener((ActionListener)this);
        if (this.isVerticalAlign) {
            this.add((Component)buttonPanel, "North");
        } else {
            this.add((Component)buttonPanel, "West");
        }
        this.initNetworkCommunication();
    }

    public final void initNetworkCommunication() {
        if (ProColPlugin.getClient() != null && ProColPlugin.getClient().isConnected()) {
            ProColPlugin.getClient().getIMH().addObserver(this);
            listModel.addElement(jEdit.getProperty((String)"procol.client.publicmessages.gettinglistinfo"));
            ProColPlugin.getClient().getPacketFactory().addToQueue(262401, 2);
            this.newButton.setEnabled(true);
        }
    }

    public void stopNetworkCommunication() {
        if (ProColPlugin.getClient() != null && !ProColPlugin.getClient().isConnected()) {
            ProColPlugin.getClient().getIMH().deleteObserver(this);
            listModel.clear();
            this.newButton.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        this.selectedItems = this.itemList.getSelectedValues();
        if (string.equals("publicmessages.new")) {
            new PublicMessageComposer("null", "(No Subject)");
        } else if (string.equals("publicmessages.reply")) {
            new PublicMessageComposer(((PublicMessage)this.selectedItems[0]).index, "(No Subject)");
        } else if (string.equals("publicmessages.delete")) {
            ProColPlugin.getClient().getPacketFactory().addToQueue(262406, ((PublicMessage)this.selectedItems[0]).index, 2);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.selectedItems = this.itemList.getSelectedValues();
            if (this.selectedItems.length == 1) {
                ProColPlugin.getClient().getPacketFactory().addToQueue(262403, ((PublicMessage)this.selectedItems[0]).index, 2);
                this.replyButton.setEnabled(true);
                this.deleteButton.setEnabled(true);
            } else if (this.selectedItems.length == 0) {
                this.replyButton.setEnabled(false);
                this.deleteButton.setEnabled(false);
            }
        }
    }

    public void update(Observable observable, Object object) {
        if (object instanceof ProColIncomingMessage) {
            ProColIncomingMessage proColIncomingMessage = (ProColIncomingMessage)object;
            switch (proColIncomingMessage.requestCode) {
                case 262400: {
                    ProColPlugin.getClient().getPacketFactory().addToQueue(262401, 2);
                    break;
                }
                case 262402: {
                    Properties properties = new Properties();
                    try {
                        properties.load(new ByteArrayInputStream(proColIncomingMessage.data));
                    }
                    catch (IOException iOException) {
                        System.out.println(iOException);
                    }
                    String string = properties.getProperty("current", "0");
                    listModel.clear();
                    while (!string.equals("0")) {
                        listModel.addElement(new PublicMessage(string, properties.getProperty(string + ".date", "(No Date)"), properties.getProperty(string + ".subject", "(No Subject)"), properties.getProperty(string + ".sender", "(No Sender)")));
                        string = properties.getProperty(string + ".previous", "0");
                    }
                    if (!listModel.isEmpty()) break;
                    this.messageDisplayEditorPane.setText(jEdit.getProperty((String)"procol.client.publicmessages.nomessages"));
                    break;
                }
                case 262404: {
                    if (this.selectedItems.length != 1) break;
                    PublicMessage publicMessage = (PublicMessage)this.selectedItems[0];
                    this.messageDisplayEditorPane.setText("<font size=\"+1\"><b>" + publicMessage.subject + "</b></font><br><b>From: " + publicMessage.sender + "<br>" + publicMessage.date + "</b><hr>" + new String(proColIncomingMessage.data));
                    break;
                }
                case -268172815: {
                    break;
                }
                case -268172814: {
                    break;
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        ProColPlugin.getClient().getIMH().deleteObserver(this);
    }

    private class PublicMessagePopupMenu
    extends JPopupMenu {
        private MenuHandler menuHandler = new MenuHandler();
        private PublicMessage itemSelected;

        public PublicMessagePopupMenu(PublicMessage publicMessage) {
            this.itemSelected = publicMessage;
            this.add(this.createMenuItem("new"));
            this.add(this.createMenuItem("reply"));
            this.add(this.createMenuItem("delete"));
        }

        private JMenuItem createMenuItem(String string) {
            JMenuItem jMenuItem = new JMenuItem(jEdit.getProperty((String)("procol.client." + string + ".label")));
            jMenuItem.setActionCommand(string);
            jMenuItem.addActionListener(this.menuHandler);
            return jMenuItem;
        }

        private class MenuHandler
        implements ActionListener {
            private MenuHandler() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("new")) {
                    new PublicMessageComposer("null", "(No Subject)");
                } else if (string.equals("reply")) {
                    new PublicMessageComposer(((PublicMessage)((PublicMessagePopupMenu)PublicMessagePopupMenu.this).PublicMessagePanel.this.selectedItems[0]).index, "Re: " + ((PublicMessage)((PublicMessagePopupMenu)PublicMessagePopupMenu.this).PublicMessagePanel.this.selectedItems[0]).subject);
                } else if (string.equals("delete")) {
                    ProColPlugin.getClient().getPacketFactory().addToQueue(262406, ((PublicMessage)((PublicMessagePopupMenu)PublicMessagePopupMenu.this).PublicMessagePanel.this.selectedItems[0]).index, 2);
                }
            }
        }
    }
}

