/*
 * Decompiled with CFR 0.152.
 */
package com.enderak.procol.client.model;

import com.enderak.procol.ProColPlugin;
import com.enderak.procol.client.gui.ProColClientDockable;
import com.enderak.procol.common.model.ProColFile;
import com.enderak.procol.common.model.ProColProject;
import com.enderak.procol.common.util.DownloadFile;
import java.io.File;
import java.net.URI;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;

public class ProColClientProject
extends ProColProject {
    private LinkedList openBuffers = new LinkedList();
    private LinkedList modifiedBuffers = new LinkedList();
    private LinkedList waitingFiles = new LinkedList();

    public ProColClientProject(URI uRI, String string) {
        super(uRI, string);
        this.projectDir = new ProColFile(uRI);
        if (!this.projectDir.exists()) {
            this.projectDir.mkdirs();
            System.out.println("Empty project directory created for project " + string + ": " + this.projectDir.getPath());
        }
        this.projectFilesDir = new ProColFile(this.projectURI.getPath(), ProColPlugin.getClient().getProperty("options.procol.client.files.dir", "files"));
        if (!this.projectFilesDir.exists()) {
            this.projectFilesDir.mkdirs();
            System.out.println("Empty project files directory created for project " + string + ": " + this.projectFilesDir.getPath());
        }
        this.projectFilesURI = this.projectFilesDir.toURI();
        this.projectFilesRootNode = new DefaultMutableTreeNode(this.projectFilesDir);
    }

    public boolean isOpenBuffer(Buffer buffer) {
        return this.openBuffers.contains(buffer);
    }

    public boolean isModifiedBuffer(Buffer buffer) {
        return this.modifiedBuffers.contains(buffer);
    }

    public void addTree(byte[] byArray) {
        this.projectFilesRootNode.removeAllChildren();
        StringTokenizer stringTokenizer = new StringTokenizer(new String(byArray), "\n");
        while (stringTokenizer.hasMoreTokens()) {
            this.addToTree(stringTokenizer.nextToken(), stringTokenizer.nextToken(), stringTokenizer.nextToken(), stringTokenizer.nextToken());
        }
    }

    public void addBuffer(Buffer buffer) {
        this.openBuffers.add(buffer);
    }

    public void addModifiedBuffer(Buffer buffer) {
        this.modifiedBuffers.add(buffer);
    }

    public void updateFileInfo(byte[] byArray) {
        StringTokenizer stringTokenizer = new StringTokenizer(new String(byArray), "\n");
        URI uRI = URI.create(stringTokenizer.nextToken());
        String string = stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken();
        DefaultMutableTreeNode defaultMutableTreeNode = this.getNodeForFile(uRI);
        if (defaultMutableTreeNode != null) {
            ProColFile proColFile = (ProColFile)defaultMutableTreeNode.getUserObject();
            proColFile.setOwner(string);
            proColFile.setVersion(string2);
            ProColClientDockable.proColPanel.projectPanel.nodeChanged(defaultMutableTreeNode);
        } else {
            this.addToTree(byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LinkedList linkedList = this.openBuffers;
        synchronized (linkedList) {
            ListIterator listIterator = this.openBuffers.listIterator(0);
            while (listIterator.hasNext()) {
                Buffer buffer = (Buffer)listIterator.next();
                jEdit.closeBuffer((View)jEdit.getActiveView(), (Buffer)buffer);
            }
        }
    }

    public ProColFile getFileForBuffer(Buffer buffer) {
        URI uRI = this.projectFilesURI.relativize(this.projectFilesURI.resolve(new File(buffer.getPath()).toURI()));
        return this.getFileInTree(uRI.getPath());
    }

    public void removeBuffer(Buffer buffer) {
        this.openBuffers.remove(buffer);
        this.modifiedBuffers.remove(buffer);
    }

    public void readyForDownload(URI uRI, URI uRI2) {
        System.out.println("READYING " + uRI + " FOR DOWNLOAD TO " + uRI2);
        this.downloadingFiles.put(uRI, new DownloadFile(uRI2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAndOpenFile(String string, byte[] byArray) {
        URI uRI = URI.create(string);
        string = uRI.toString();
        this.writeFile(string, byArray);
        LinkedList linkedList = this.waitingFiles;
        synchronized (linkedList) {
            this.waitingFiles.add(this.getFileInTree(uRI.getPath()));
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                LinkedList linkedList = ProColClientProject.this.waitingFiles;
                synchronized (linkedList) {
                    while (!ProColClientProject.this.waitingFiles.isEmpty()) {
                        ProColClientProject.this.openBuffers.add(jEdit.openFile((View)jEdit.getActiveView(), (String)((ProColFile)ProColClientProject.this.waitingFiles.removeFirst()).getPath()));
                    }
                }
            }
        });
        System.out.println("*** Opened buffer for " + string);
    }

    public void addToTree(byte[] byArray) {
        StringTokenizer stringTokenizer = new StringTokenizer(new String(byArray), "\n");
        this.addToTree(stringTokenizer.nextToken(), stringTokenizer.nextToken(), stringTokenizer.nextToken(), stringTokenizer.nextToken());
    }

    private void addToTree(String string, String string2, String string3, String string4) {
        File file;
        ProColFile proColFile = new ProColFile(this.projectFilesURI.resolve(string));
        proColFile.setOwner(string2);
        proColFile.setVersion(string3);
        if (string4.equals("true") && !proColFile.exists()) {
            proColFile.mkdirs();
        }
        Stack<File> stack = new Stack<File>();
        DefaultMutableTreeNode defaultMutableTreeNode = this.projectFilesRootNode;
        for (file = proColFile.getParentFile(); file != null && !file.toURI().equals(this.projectFilesURI); file = file.getParentFile()) {
            stack.push(file);
        }
        while (!stack.isEmpty()) {
            boolean bl = false;
            file = (File)stack.pop();
            for (int i = defaultMutableTreeNode.getChildCount() - 1; i >= 0; --i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                ProColFile proColFile2 = (ProColFile)defaultMutableTreeNode2.getUserObject();
                if (!proColFile2.toURI().equals(file.toURI())) continue;
                bl = true;
                defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                break;
            }
            if (bl) continue;
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new ProColFile(file.toURI()));
            defaultMutableTreeNode.add(defaultMutableTreeNode3);
            defaultMutableTreeNode = defaultMutableTreeNode3;
        }
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(proColFile, proColFile.isFile()));
    }
}

