/*
 * Decompiled with CFR 0.152.
 */
package com.enderak.procol.client.net;

import com.enderak.procol.client.gui.ProColClientDockable;
import com.enderak.procol.client.gui.UploadPanel;
import com.enderak.procol.client.model.ProColClientProject;
import com.enderak.procol.client.model.ProColClientUser;
import com.enderak.procol.client.net.IncomingMessageHandler;
import com.enderak.procol.common.model.ProColFile;
import com.enderak.procol.common.net.MessageFactory;
import com.enderak.procol.common.net.OutgoingMessageHandler;
import com.enderak.procol.common.net.PacketFactory;
import com.enderak.procol.common.net.ProColPacket;
import com.enderak.procol.common.net.SSLCommon;
import com.enderak.procol.common.util.EnhancedObservable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.Enumeration;
import java.util.Vector;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;

public class ProColClient
extends EnhancedObservable
implements Runnable {
    private static final String DEFAULT_PROCOL_DIR_NAME = ".procol" + System.getProperty("file.separator") + "client";
    private static final String DEFAULT_PROJECTS_DIR_NAME = "projects";
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final int MAX_FILES_TO_DISPLAY = 10;
    protected boolean isRunning = false;
    protected Vector userList = new Vector();
    private ProColClientUser user;
    private String host;
    private int port;
    private SSLSocket server;
    private PacketFactory packetFactory = new PacketFactory();
    private MessageFactory messageFactory = new MessageFactory();
    private DataInputStream in;
    private IncomingMessageHandler imh;
    private OutgoingMessageHandler omh;
    private ProColClientProject project;
    private File projectDir;
    private File proColDir;
    private Thread thisThread;
    private URI snapshotURI = null;
    private URI downloadURI = null;

    public ProColClient() {
        this.loadProperties();
    }

    private final void loadProperties() {
        this.proColDir = new ProColFile(this.getProperty("options.procol.client.directory", System.getProperty("user.home") + FILE_SEPARATOR + DEFAULT_PROCOL_DIR_NAME));
        if (!this.proColDir.exists()) {
            this.proColDir.mkdirs();
            System.out.println("Empty procol client directory created: " + this.proColDir.getPath());
        }
        this.projectDir = new ProColFile(this.getProperty("options.procol.client.directory.projects", this.proColDir.getPath() + FILE_SEPARATOR + DEFAULT_PROJECTS_DIR_NAME));
        if (!this.projectDir.exists()) {
            this.projectDir.mkdirs();
            System.out.println("Empty procol project directory created: " + this.projectDir.getPath());
        }
    }

    public void run() {
        this.isRunning = true;
        while (this.isRunning) {
            this.receive();
        }
        this.close();
    }

    public void receive() {
        try {
            int n = this.in.readInt();
            int n2 = this.in.readInt();
            int n3 = this.in.readInt();
            int n4 = this.in.readInt();
            byte[] byArray = new byte[n4];
            this.in.readFully(byArray);
            this.messageFactory.addPacket(new ProColPacket(n, n2, n3, n4, byArray));
        }
        catch (EOFException eOFException) {
            if (this.isRunning) {
                ProColClientDockable.displayError(jEdit.getProperty((String)"procol.client.error.connection.title"), jEdit.getProperty((String)"procol.client.error.connection.unexpecteddisconnect"));
                this.isRunning = false;
            }
        }
        catch (IOException iOException) {
            System.err.println("IOException reading from server in ProColClient! " + iOException);
            this.isRunning = false;
        }
    }

    public boolean connectToServer(String string, int n) {
        ProColClientDockable.proColPanel.startProgress("Connecting to " + string + ":" + n);
        this.host = string;
        this.port = n;
        this.packetFactory.resetMessageNum();
        SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        try {
            this.server = (SSLSocket)sSLSocketFactory.createSocket(this.host, this.port);
        }
        catch (IOException iOException) {
            ProColClientDockable.displayError("Network Error", "Unable to open network socket from server!");
            ProColClientDockable.proColPanel.stopProgress();
            return false;
        }
        SSLCommon.enableAnonymousCipherSuites(this.server);
        try {
            this.in = new DataInputStream(this.server.getInputStream());
        }
        catch (IOException iOException) {
            ProColClientDockable.displayError("Network Error", "Unable to open input stream from server!");
            ProColClientDockable.proColPanel.stopProgress();
            return false;
        }
        this.isRunning = true;
        this.forceNotify("CONNECTION");
        this.imh = new IncomingMessageHandler(this);
        new Thread((Runnable)this.imh, "IMH").start();
        this.omh = new OutgoingMessageHandler(this.server, this.packetFactory);
        this.omh.start();
        this.thisThread = new Thread((Runnable)this, "ProColClient");
        this.thisThread.start();
        this.sendHello();
        ProColClientDockable.proColPanel.stopProgress();
        return true;
    }

    public void close() {
        System.out.println("closing client");
        try {
            this.isRunning = false;
            this.project = null;
            this.imh.close();
            this.omh.close();
            this.server.close();
            this.forceNotify("CONNECTION");
        }
        catch (IOException iOException) {
            ProColClientDockable.displayError("Unable to disconnect!", "An error occured while disconnecting from server!");
        }
        System.out.println("Done closing client");
    }

    public void sendHello() {
        this.packetFactory.addToQueue(0, "0.1", 1);
    }

    public void authenticateUser(String string, String string2) {
        ProColClientDockable.proColPanel.startProgress("Authenticating");
        this.packetFactory.addToQueue(256, "" + string + "\n" + string2 + "\n", 1);
    }

    public void getProjectList() {
        this.packetFactory.addToQueue(131072, 1);
    }

    public void getProjectInfo() {
        this.getProjectInfo(this.project.getName());
    }

    public void getProjectInfo(String string) {
        if (string != null) {
            this.packetFactory.addToQueue(131077, string, 1);
        }
    }

    public void getUserInfo(String string) {
        this.packetFactory.addToQueue(65540, string, 1);
    }

    public void getFileHistory(String string) {
        this.packetFactory.addToQueue(198146, string, 1);
    }

    public void downloadSnapshot() {
        if (this.snapshotURI == null) {
            this.snapshotURI = this.project.getProjectFilesURI();
        }
        String[] stringArray = GUIUtilities.showVFSFileDialog((View)jEdit.getActiveView(), (String)this.snapshotURI.getPath(), (int)3, (boolean)false);
        this.snapshotURI = new File(stringArray[0]).toURI();
        this.packetFactory.addToQueue(196864, 0);
    }

    public void checkOutFile(TreePath[] treePathArray) {
        URI uRI = this.project.getProjectFilesURI();
        for (int i = 0; i < treePathArray.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
            ProColFile proColFile = (ProColFile)defaultMutableTreeNode.getUserObject();
            URI uRI2 = uRI.relativize(proColFile.toURI());
            System.out.println("1: " + uRI);
            System.out.println("2: " + uRI.relativize(uRI2));
            System.out.println("3: " + new File(uRI.getPath() + File.separator + uRI2.getPath()).toURI());
            this.sendFileRequest(uRI2, new File(uRI.getPath() + File.separator + uRI2.getPath()).toURI(), 197376);
        }
    }

    public void updateFile(ProColFile proColFile) {
        this.upload(proColFile);
    }

    public void downloadFile(TreePath[] treePathArray) {
        String[] stringArray;
        Comparable<URI> comparable;
        Serializable serializable;
        Serializable serializable2;
        if (this.downloadURI == null) {
            this.downloadURI = this.project.getProjectFilesURI();
        }
        if (treePathArray.length == 1) {
            serializable2 = (DefaultMutableTreeNode)treePathArray[0].getLastPathComponent();
            serializable = (ProColFile)((DefaultMutableTreeNode)serializable2).getUserObject();
            comparable = ((File)serializable).getParentFile().toURI().relativize(((File)serializable).toURI());
            if (((File)serializable).isDirectory()) {
                stringArray = GUIUtilities.showVFSFileDialog((View)jEdit.getActiveView(), (String)this.downloadURI.getPath(), (int)3, (boolean)false);
                this.downloadURI = new File(stringArray[0]).toURI();
            } else {
                stringArray = GUIUtilities.showVFSFileDialog((View)jEdit.getActiveView(), (String)this.downloadURI.resolve((URI)comparable).getPath(), (int)3, (boolean)false);
                this.downloadURI = new File(stringArray[0]).toURI();
            }
        } else {
            stringArray = GUIUtilities.showVFSFileDialog((View)jEdit.getActiveView(), (String)this.downloadURI.getPath(), (int)3, (boolean)false);
            this.downloadURI = new File(stringArray[0]).toURI();
        }
        serializable2 = this.project.getProjectFilesURI();
        for (int i = 0; i < treePathArray.length; ++i) {
            serializable = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
            comparable = (ProColFile)((DefaultMutableTreeNode)serializable).getUserObject();
            URI uRI = ((URI)serializable2).relativize(((File)comparable).toURI());
            this.sendFileRequest(uRI, new File(this.downloadURI.getPath() + File.separator + ((File)comparable).getName()).toURI(), 196865);
        }
    }

    public void uploadFiles() {
        this.upload(GUIUtilities.showVFSFileDialog((View)jEdit.getActiveView(), null, (int)0, (boolean)true));
    }

    public void uploadDirs() {
        this.upload(GUIUtilities.showVFSFileDialog((View)jEdit.getActiveView(), null, (int)3, (boolean)true));
    }

    public void deleteFile(TreePath[] treePathArray) {
        ProColFile proColFile;
        DefaultMutableTreeNode defaultMutableTreeNode;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        URI uRI = this.project.getProjectFilesURI();
        for (n = 0; n < treePathArray.length && n < 10; ++n) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[n].getLastPathComponent();
            proColFile = (ProColFile)defaultMutableTreeNode.getUserObject();
            stringBuffer.append("\n").append(uRI.relativize(proColFile.toURI()).getPath());
        }
        if (treePathArray.length > 10) {
            stringBuffer.append("\n... (").append(treePathArray.length - 10).append(" more files)");
        }
        if (JOptionPane.showConfirmDialog(null, "Are you sure you want to delete the following file(s)?\n" + stringBuffer.toString(), "Delete File Confirmation", 0, 3) == 0) {
            for (n = 0; n < treePathArray.length; ++n) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[n].getLastPathComponent();
                proColFile = (ProColFile)defaultMutableTreeNode.getUserObject();
                this.packetFactory.addToQueue(197888, uRI.relativize(proColFile.toURI()), 1);
            }
        }
    }

    public void renameFile(TreePath[] treePathArray) {
        if (treePathArray.length != 1) {
            return;
        }
        String string = JOptionPane.showInputDialog(null, "Enter a new name for " + ((ProColFile)((DefaultMutableTreeNode)treePathArray[0].getLastPathComponent()).getUserObject()).getName(), "Rename File", 3);
        if (string != null && !string.equals("")) {
            URI uRI = this.project.getProjectFilesURI();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[0].getLastPathComponent();
            ProColFile proColFile = (ProColFile)defaultMutableTreeNode.getUserObject();
            String string2 = proColFile.isDirectory() ? proColFile.getPath() : proColFile.getParent();
            ProColFile proColFile2 = new ProColFile(string2 + File.separator + string);
            URI uRI2 = uRI.relativize(proColFile.toURI());
            URI uRI3 = uRI.relativize(uRI.resolve(proColFile2.toURI()));
            this.packetFactory.addToQueue(197904, uRI2.toString() + "\n" + uRI3.toString(), 1);
        }
    }

    public void newFile(TreePath[] treePathArray) {
        String string = JOptionPane.showInputDialog(null, "Enter name of file to create.", "Create File", 3);
        if (string != null && !string.equals("")) {
            URI uRI = this.project.getProjectFilesURI();
            DefaultMutableTreeNode defaultMutableTreeNode = treePathArray != null ? (DefaultMutableTreeNode)treePathArray[0].getLastPathComponent() : this.project.getProjectFilesRootNode();
            ProColFile proColFile = (ProColFile)defaultMutableTreeNode.getUserObject();
            String string2 = proColFile.isDirectory() ? proColFile.getPath() : proColFile.getParent();
            ProColFile proColFile2 = new ProColFile(string2 + File.separator + string);
            URI uRI2 = uRI.relativize(uRI.resolve(proColFile2.toURI()));
            this.packetFactory.addToQueue(197936, uRI2.toString(), 1);
        }
    }

    public void newDir(TreePath[] treePathArray) {
        String string = JOptionPane.showInputDialog(null, "Enter name of directory to create.", "Create Directory", 3);
        if (string != null && !string.equals("")) {
            URI uRI = this.project.getProjectFilesURI();
            DefaultMutableTreeNode defaultMutableTreeNode = treePathArray != null ? (DefaultMutableTreeNode)treePathArray[0].getLastPathComponent() : this.project.getProjectFilesRootNode();
            ProColFile proColFile = (ProColFile)defaultMutableTreeNode.getUserObject();
            String string2 = proColFile.isDirectory() ? proColFile.getPath() : proColFile.getParent();
            ProColFile proColFile2 = new ProColFile(string2 + File.separator + string);
            URI uRI2 = uRI.relativize(uRI.resolve(proColFile2.toURI()));
            this.packetFactory.addToQueue(197937, uRI2.toString(), 1);
        }
    }

    public void closeProject() {
        this.packetFactory.addToQueue(131076, 1);
        this.project = null;
    }

    public void joinProject(String string) {
        if (this.project != null) {
            this.closeProject();
        }
        File file = new File(this.projectDir.getPath() + FILE_SEPARATOR + string);
        this.project = new ProColClientProject(file.toURI(), string);
        this.forceNotify("PROJECT");
        ProColClientDockable.proColPanel.startProgress("Opening Project");
        this.packetFactory.addToQueue(131075, string, 1);
    }

    public void addPrivateMessage(String string, String string2, String string3) {
        this.packetFactory.addToQueue(262149, string + "\n" + string2 + "\n" + string3, 1);
    }

    public void disconnect() {
        this.project.close();
        this.packetFactory.addToQueue(512, 2);
    }

    public void killServerRemotely() {
        this.packetFactory.addToQueue(1048544, 2);
    }

    public void sendFileRequest(URI uRI, URI uRI2, int n) {
        ProColFile proColFile;
        DefaultMutableTreeNode defaultMutableTreeNode;
        System.out.println("SENDING FILE REQUEST FOR " + uRI + " TO " + uRI2);
        if (uRI == null) {
            defaultMutableTreeNode = this.project.getProjectFilesRootNode();
            proColFile = null;
        } else {
            defaultMutableTreeNode = this.project.getNodeForFile(uRI);
            proColFile = (ProColFile)defaultMutableTreeNode.getUserObject();
        }
        if (!defaultMutableTreeNode.isLeaf()) {
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                proColFile = (ProColFile)defaultMutableTreeNode2.getUserObject();
                URI uRI3 = new File(uRI2.getPath() + File.separator + proColFile.getName()).toURI();
                this.sendFileRequest(this.project.getProjectFilesURI().relativize(proColFile.toURI()), uRI3, n);
            }
        } else if (proColFile != null) {
            if (new File(uRI2).isDirectory()) {
                uRI2 = new File(uRI2.getPath() + File.separator + proColFile.getName()).toURI();
            }
            this.project.readyForDownload(uRI, uRI2);
            this.packetFactory.addToQueue(n, uRI, 1);
        }
    }

    public void setUserList(Vector vector) {
        this.userList = vector;
        this.forceNotify("USERLIST");
    }

    public void addTree(byte[] byArray) {
        this.project.addTree(byArray);
        ProColClientDockable.proColPanel.stopProgress();
        this.forceNotify("CONNECTION");
    }

    public ProColClientProject getProject() {
        return this.project;
    }

    public boolean isConnected() {
        return this.isRunning;
    }

    public boolean isAuthenticated() {
        if (this.user == null) {
            return false;
        }
        return this.user.isAuthenticated();
    }

    public String getServer() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public ProColClientUser getUser() {
        return this.user;
    }

    public Vector getUserList() {
        return this.userList;
    }

    public SSLSocket getServerSocket() {
        return this.server;
    }

    public PacketFactory getPacketFactory() {
        return this.packetFactory;
    }

    public MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public IncomingMessageHandler getIMH() {
        return this.imh;
    }

    public OutgoingMessageHandler getOMH() {
        return this.omh;
    }

    public URI getSnapshotURI() {
        return this.snapshotURI;
    }

    public void setUser(ProColClientUser proColClientUser) {
        this.user = proColClientUser;
    }

    public String getProperty(String string) {
        return jEdit.getProperty((String)string);
    }

    public String getProperty(String string, String string2) {
        return jEdit.getProperty((String)string, (String)string2);
    }

    private void upload(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.upload(new ProColFile(stringArray[i]));
        }
    }

    private void upload(ProColFile proColFile) {
        if (proColFile == null) {
            System.err.println("ERROR! fileIn is null in ProColClient.upload(ProColFile)");
            return;
        }
        if (proColFile.isDirectory()) {
            ProColFile[] proColFileArray = proColFile.listProColFiles();
            for (int i = 0; i < proColFileArray.length; ++i) {
                this.upload(proColFileArray[i]);
            }
        } else if (proColFile.isFile()) {
            jEdit.getActiveView().getDockableWindowManager().showDockableWindow("procol.client.dockable.upload");
            URI uRI = proColFile.getParentFile().toURI().relativize(proColFile.toURI());
            ((UploadPanel)jEdit.getActiveView().getDockableWindowManager().getDockableWindow("procol.client.dockable.upload")).addFile(proColFile, uRI);
        }
    }
}

