/*
 * Decompiled with CFR 0.152.
 */
package com.enderak.procol.common.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;

public class ProColFile
extends File {
    private static final int NUM_VERSIONS = 3;
    private Properties versions = new Properties();
    private String owner;
    private File versionsFile;

    public ProColFile(String string) {
        super(string);
    }

    public ProColFile(String string, String string2) {
        super(string, string2);
    }

    public ProColFile(URI uRI) {
        super(uRI);
    }

    public void setVersionsFile(URI uRI) {
        if (!this.isDirectory()) {
            this.versionsFile = new File(uRI);
            try {
                this.versions.load(new FileInputStream(this.versionsFile));
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    this.versionsFile.getParentFile().mkdirs();
                    this.versionsFile.createNewFile();
                    this.createNewVersion("0.0.0", "Versions file created by ProCol server", null);
                    System.out.println("Versions file created: " + this.versionsFile.getPath());
                }
                catch (IOException iOException) {
                    System.err.println("IOException creating new versions file: " + this.versionsFile.getPath());
                }
            }
            catch (IOException iOException) {
                System.err.println("IOException loading server properties: " + iOException);
            }
        }
    }

    public URI getVersionsURI() {
        if (this.versionsFile == null) {
            return null;
        }
        return this.versionsFile.toURI();
    }

    public File getVersionsFile() {
        if (this.versionsFile == null) {
            return null;
        }
        return this.versionsFile;
    }

    public boolean checkOut(String string) {
        if (this.owner != null) {
            return false;
        }
        this.setOwner(string);
        return true;
    }

    public boolean checkIn(String string) {
        if (string.equals(this.owner)) {
            return this.setOwner(null);
        }
        return false;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getVersion() {
        return this.versions.getProperty("current", "null");
    }

    public int[] getVersionAsArray() {
        int[] nArray = new int[3];
        if (this.getVersion().equals("null")) {
            for (int i = 0; i < 3; ++i) {
                nArray[i] = 0;
            }
            return nArray;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.getVersion(), ".");
        for (int i = 0; i < 3; ++i) {
            nArray[i] = new Integer(stringTokenizer.nextToken());
        }
        return nArray;
    }

    public void setVersion(String string) {
        this.versions.setProperty("current", string);
    }

    public boolean createNewVersion(String string, String string2, String string3) {
        this.versions.setProperty(string + ".previous", this.getVersion());
        if (string2 == null) {
            this.versions.setProperty(string + ".changelog", "");
        } else {
            this.versions.setProperty(string + ".changelog", string2);
        }
        if (string3 == null) {
            this.versions.setProperty(string + ".user", "");
        } else {
            this.versions.setProperty(string + ".user", string3);
        }
        this.versions.setProperty(string + ".date", new Date().toString());
        this.versions.setProperty("current", string);
        try {
            this.versions.store(new FileOutputStream(this.versionsFile), "Version information for " + this.getPath());
        }
        catch (IOException iOException) {
            System.err.println("IOException versions file: " + this.versionsFile.getPath());
            return false;
        }
        return true;
    }

    public boolean setOwner(String string) {
        if (string == null || string.equals("null")) {
            this.owner = null;
        } else if (this.owner == null) {
            this.owner = string;
        } else {
            return false;
        }
        return true;
    }

    public boolean isCheckedOut() {
        return this.owner != null;
    }

    public boolean isCheckedOutBy(String string) {
        return this.owner != null && this.owner.equals(string);
    }

    public String toString() {
        return this.getName();
    }

    public String getFileInfo(URI uRI) {
        return uRI.relativize(this.toURI()) + "\n" + this.getOwner() + "\n" + this.getVersion() + "\n" + this.isDirectory() + "\n";
    }

    public ProColFile[] listProColFiles() {
        File[] fileArray = this.listFiles();
        if (fileArray == null) {
            return null;
        }
        ProColFile[] proColFileArray = new ProColFile[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            proColFileArray[i] = new ProColFile(fileArray[i].getPath());
        }
        return proColFileArray;
    }
}

