/*
 * Decompiled with CFR 0.152.
 */
package com.enderak.procol.server.model;

import com.enderak.procol.common.model.ProColFile;
import com.enderak.procol.common.model.ProColProject;
import com.enderak.procol.common.model.ProColUser;
import com.enderak.procol.common.util.DownloadFile;
import com.enderak.procol.common.util.ProColFileComparator;
import com.enderak.procol.server.net.ProColServer;
import com.enderak.procol.server.net.ServerConnection;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

public class ProColServerProject
extends ProColProject {
    public Vector connectionList = new Vector();
    private URI versionsURI;
    private URI backupURI;
    private URI privateMessagesURI;
    private URI publicMessagesURI;
    private URI todoListURI;
    private URI bugListURI;
    private URI calendarURI;
    private int numBackups;
    private boolean makeBackups;
    private boolean versionsAllowNoChange;
    private boolean allowAnonymousLogin;
    private String backupSuffix;
    private String versionsSuffix;
    private Properties projectProps = new Properties();
    private Vector allowedUsers = new Vector();

    public ProColServerProject(URI uRI, String string, boolean bl) {
        super(uRI, string);
        try {
            this.projectProps.load(new FileInputStream(new File(this.projectURI.getPath() + File.separator + string + ".props")));
        }
        catch (FileNotFoundException fileNotFoundException) {
            ProColServer.printErr("FileNotFoundException loading server properties: " + fileNotFoundException);
        }
        catch (IOException iOException) {
            ProColServer.printErr("IOException loading server properties: " + iOException);
        }
        this.initOptions();
        if (bl) {
            this.loadFiles();
        }
    }

    public final void loadFiles() {
        ProColServer.printInfo("Loading files for " + this.name + " project.");
        this.loadFiles(this.projectFilesURI);
    }

    public int checkIn(URI uRI, ProColUser proColUser) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getNodeForFile(uRI);
        if (defaultMutableTreeNode == null) {
            return -268237579;
        }
        ProColFile proColFile = (ProColFile)defaultMutableTreeNode.getUserObject();
        if (proColFile.checkIn(proColUser.getName())) {
            this.forceNotify(proColFile);
            return 197635;
        }
        return -268237584;
    }

    public void addConnection(ServerConnection serverConnection) {
        this.connectionList.add(serverConnection);
        this.addObserver(serverConnection);
        if (this.projectFilesRootNode == null) {
            this.loadFiles();
        }
        this.forceNotify("CONNECTIONS");
    }

    public void removeConnection(ServerConnection serverConnection) {
        this.connectionList.remove(serverConnection);
        this.deleteObserver(serverConnection);
        serverConnection = null;
        ProColServer.printInfo("Removed connection from " + this.name + ", # connections = " + this.connectionList.size());
        if (this.connectionList.isEmpty()) {
            this.unloadFiles();
        }
        this.forceNotify("CONNECTIONS");
    }

    public void closeAllConnections() {
        while (this.connectionList.size() > 0) {
            ((ServerConnection)this.connectionList.get(0)).close();
        }
    }

    public Vector getUserList() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.connectionList.size(); ++i) {
            ServerConnection serverConnection = (ServerConnection)this.connectionList.elementAt(i);
            vector.add(serverConnection.getUser().getName());
        }
        return vector;
    }

    public String getProjectDescription() {
        return this.projectProps.getProperty("description", "<none>");
    }

    public int getOptimalStringBufferSize(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n = 0;
        for (DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode.getFirstLeaf(); defaultMutableTreeNode2 != null; defaultMutableTreeNode2 = defaultMutableTreeNode2.getNextLeaf()) {
            n += ((ProColFile)defaultMutableTreeNode2.getUserObject()).getFileInfo(((ProColFile)defaultMutableTreeNode.getUserObject()).toURI()).length();
        }
        return n;
    }

    public ServerConnection getConnectionFor(String string) {
        Enumeration enumeration = this.connectionList.elements();
        while (enumeration.hasMoreElements()) {
            ServerConnection serverConnection = (ServerConnection)enumeration.nextElement();
            if (!serverConnection.getUser().getName().equals(string)) continue;
            return serverConnection;
        }
        return null;
    }

    public Vector getConnections() {
        return this.connectionList;
    }

    public Vector getAllowedUsers() {
        return this.allowedUsers;
    }

    public URI getPrivateMessagesURI() {
        return this.privateMessagesURI;
    }

    public URI getPublicMessagesURI() {
        return this.publicMessagesURI;
    }

    public URI getTodoListURI() {
        return this.todoListURI;
    }

    public URI getBugListURI() {
        return this.bugListURI;
    }

    public URI getCalendarURI() {
        return this.calendarURI;
    }

    public int addDownloadFile(byte[] byArray, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(new String(byArray), "\n");
        String string2 = stringTokenizer.nextToken();
        URI uRI = URI.create(string2);
        System.out.println("1");
        ProColFile proColFile = this.getFileInTree(uRI);
        System.out.println("2");
        String string3 = new String();
        StringBuffer stringBuffer = new StringBuffer();
        if (proColFile == null) {
            proColFile = new ProColFile(this.projectFilesURI.resolve(uRI));
            proColFile.setVersionsFile(this.versionsURI.resolve(this.projectFilesURI.relativize(proColFile.toURI()).toString() + this.versionsSuffix));
        }
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append(stringTokenizer.nextToken());
                if (!stringTokenizer.hasMoreTokens()) continue;
                stringBuffer.append("\n");
            }
            stringTokenizer = new StringTokenizer(string3, ".");
            int[] nArray = new int[3];
            for (int i = 0; i < 3; ++i) {
                nArray[i] = new Integer(stringTokenizer.nextToken());
            }
            int[] nArray2 = proColFile.getVersionAsArray();
            if (string3.equals(proColFile.getVersion()) && !this.versionsAllowNoChange) {
                proColFile = null;
                return -268234832;
            }
            for (int i = 0; i < 3 && nArray[i] <= nArray2[i]; ++i) {
                if (nArray[i] >= nArray2[i]) continue;
                proColFile = null;
                return -268234831;
            }
        }
        this.downloadingFiles.put(string2, new DownloadFile(proColFile, string3, stringBuffer.toString()));
        return 200450;
    }

    public int writeFile(String string, byte[] byArray, String string2) {
        DownloadFile downloadFile = (DownloadFile)this.downloadingFiles.remove(string);
        if (downloadFile != null) {
            Object object;
            ProColFile proColFile = downloadFile.file;
            String string3 = downloadFile.version;
            String string4 = downloadFile.changeLog;
            if (this.makeBackups) {
                object = this.backupURI.resolve(this.projectFilesURI.relativize(this.projectFilesURI.resolve(new File(proColFile.getPath() + this.backupSuffix).toURI())));
                File file = new File(((URI)object).getPath() + "0");
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                for (int i = this.numBackups - 2; i >= 0; --i) {
                    File file2 = new File(((URI)object).getPath() + i);
                    File file3 = new File(((URI)object).getPath() + (i + 1));
                    if (!file2.exists()) continue;
                    if (file3.exists()) {
                        file3.delete();
                    }
                    if (file2.renameTo(file3)) continue;
                    ProColServer.printErr("Error backing up local file " + file2.getPath());
                }
                if (file.exists()) {
                    file.delete();
                }
                proColFile.renameTo(file);
            }
            try {
                proColFile.getParentFile().mkdirs();
                proColFile.createNewFile();
            }
            catch (IOException iOException) {
                ProColServer.printErr(iOException.toString());
                proColFile = null;
                return -268234848;
            }
            if (string3 != null && string4 != null && !proColFile.createNewVersion(string3, string4, proColFile.getOwner())) {
                proColFile = null;
                return -268234830;
            }
            try {
                object = new FileOutputStream(proColFile);
                ((FileOutputStream)object).write(byArray, string.getBytes().length + 1, byArray.length - string.getBytes().length - 1);
                ((FileOutputStream)object).close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                ProColServer.printErr(fileNotFoundException.toString());
                proColFile = null;
                return -268234829;
            }
            catch (IOException iOException) {
                ProColServer.printErr(iOException.toString());
                proColFile = null;
                return -268234827;
            }
            if (this.getNodeForFile(this.projectFilesURI.relativize(this.projectFilesURI.resolve(proColFile.toURI()))) == null) {
                object = this.getNodeForFile(this.projectFilesURI.relativize(this.projectFilesURI.resolve(proColFile.getParentFile().toURI())));
                ((DefaultMutableTreeNode)object).add(new DefaultMutableTreeNode(proColFile));
            }
            proColFile.checkIn(string2);
            this.forceNotify(proColFile);
            this.forceNotify("FILE_LIST");
            return 200452;
        }
        return -268234816;
    }

    public int deleteFile(URI uRI) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getNodeForFile(uRI);
        ProColFile proColFile = this.getFileInTree(uRI);
        if (proColFile.isCheckedOut()) {
            return -268234847;
        }
        boolean bl = proColFile.delete();
        if (bl) {
            defaultMutableTreeNode.removeFromParent();
            this.forceNotify("FILE_LIST");
            return 200449;
        }
        return -268234827;
    }

    public int moveFile(URI uRI, URI uRI2) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getNodeForFile(uRI);
        ProColFile proColFile = this.getFileInTree(uRI);
        ProColFile proColFile2 = new ProColFile(this.projectFilesURI.resolve(uRI2));
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.getNodeForFile(this.projectFilesURI.relativize(this.projectFilesURI.resolve(proColFile2.getParentFile().toURI())));
        proColFile2.getParentFile().mkdirs();
        if (!proColFile2.exists()) {
            boolean bl = proColFile.renameTo(proColFile2);
            if (bl) {
                URI uRI3 = this.versionsURI.resolve(this.projectFilesURI.relativize(new File(proColFile2.getPath() + this.versionsSuffix).toURI()));
                proColFile.getVersionsFile().renameTo(new File(uRI3));
                proColFile2.setVersionsFile(uRI3);
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(proColFile2));
                defaultMutableTreeNode.removeFromParent();
                this.forceNotify("FILE_LIST");
                return 200449;
            }
            return -268234827;
        }
        return -268234828;
    }

    public int newFile(URI uRI, boolean bl) {
        ProColFile proColFile = new ProColFile(this.projectFilesURI.resolve(uRI));
        DefaultMutableTreeNode defaultMutableTreeNode = this.getNodeForFile(this.projectFilesURI.relativize(this.projectFilesURI.resolve(proColFile.getParentFile().toURI())));
        if (!proColFile.exists()) {
            boolean bl2 = false;
            if (bl) {
                bl2 = proColFile.mkdirs();
            } else {
                try {
                    bl2 = proColFile.createNewFile();
                    if (bl2) {
                        URI uRI2 = this.versionsURI.resolve(this.projectFilesURI.relativize(new File(proColFile.getPath() + this.versionsSuffix).toURI()));
                        proColFile.setVersionsFile(uRI2);
                    }
                }
                catch (IOException iOException) {
                    return -268234827;
                }
            }
            if (!bl2) {
                return -268234827;
            }
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(proColFile));
            this.forceNotify("FILE_LIST");
            return 200449;
        }
        return -268234828;
    }

    public void unloadFiles() {
        ProColServer.printInfo("Unloading files for " + this.name + " project.");
        this.projectFilesRootNode = null;
    }

    private void initOptions() {
        this.projectFilesURI = this.getRootURI("files.dir", "files", true);
        this.versionsURI = this.getRootURI("versions.dir", "versions", true);
        this.backupURI = this.getRootURI("backup.dir", "backup", true);
        this.privateMessagesURI = this.getRootURI("privatemessages.dir", "privmsg", true);
        this.publicMessagesURI = this.getRootURI("publicmessages.dir", "publicmsg", false);
        this.todoListURI = this.getRootURI("todolist.dir", "todo", false);
        this.bugListURI = this.getRootURI("buglist.dir", "bugs", false);
        this.calendarURI = this.getRootURI("calendar.dir", "calendar", false);
        this.versionsSuffix = this.projectProps.getProperty("versions.suffix", ".versions");
        this.versionsAllowNoChange = this.projectProps.getProperty("versions.allownochange", "false").equals("true");
        this.numBackups = Integer.parseInt(this.projectProps.getProperty("backup.number", "3"));
        this.backupSuffix = this.projectProps.getProperty("backup.suffix", "~");
        this.makeBackups = this.projectProps.getProperty("backup.enabled", "true").equals("true");
        this.allowAnonymousLogin = this.projectProps.getProperty("users.anonymous", "deny").equals("allow");
        String string = this.projectProps.getProperty("users.allow", "");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            this.allowedUsers.add(string2);
        }
    }

    private URI getRootURI(String string, String string2, boolean bl) {
        File file = new File(this.projectURI.getPath() + File.separator + this.projectProps.getProperty(string, string2));
        if (!file.exists() && bl) {
            file.mkdirs();
            ProColServer.printInfo("Empty project directory created: " + file.getPath());
        }
        return file.toURI();
    }

    private void loadFiles(URI uRI) {
        ProColFile proColFile = new ProColFile(uRI);
        this.projectFilesRootNode = new DefaultMutableTreeNode(proColFile);
        this.loadFile(this.projectFilesRootNode);
        this.forceNotify("FILE_LIST");
    }

    private void loadFile(DefaultMutableTreeNode defaultMutableTreeNode) {
        File[] fileArray = ((File)defaultMutableTreeNode.getUserObject()).listFiles();
        if (fileArray != null) {
            Arrays.sort(fileArray, new ProColFileComparator());
            for (int i = 0; i < fileArray.length; ++i) {
                ProColFile proColFile = new ProColFile(fileArray[i].getPath());
                proColFile.setVersionsFile(this.versionsURI.resolve(this.projectFilesURI.relativize(new File(proColFile.getPath() + this.versionsSuffix).toURI())));
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(proColFile);
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                this.loadFile(defaultMutableTreeNode2);
            }
        }
    }
}

