/*
 * Decompiled with CFR 0.152.
 */
package com.enderak.procol.server.net;

import com.enderak.procol.common.model.ProColFile;
import com.enderak.procol.common.model.ProColUser;
import com.enderak.procol.common.net.SSLCommon;
import com.enderak.procol.common.util.EnhancedObservable;
import com.enderak.procol.server.RunProColServer;
import com.enderak.procol.server.gui.ProColServerDockable;
import com.enderak.procol.server.gui.ProColServerDockableLog;
import com.enderak.procol.server.model.ProColServerProject;
import com.enderak.procol.server.net.ServerConnection;
import com.enderak.procol.server.util.ProjectFileFilter;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.Security;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Vector;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import org.gjt.sp.jedit.jEdit;

public final class ProColServer
extends EnhancedObservable
implements Runnable {
    private static final String DEFAULT_PROPS_FILE_NAME = "/com/enderak/procol/server/server.props";
    private static final String DEFAULT_PROCOL_DIR_NAME = ".procol" + System.getProperty("file.separator") + "server";
    private static final String DEFAULT_PROJECTS_DIR_NAME = "projects";
    private static final String DEFAULT_USER_PROPS_NAME = "users.props";
    private static final String DEFAULT_CUSTOM_PROPS_NAME = "server.props";
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static SSLServerSocket serverSocket = null;
    private static Vector connections = new Vector();
    private boolean serverRunning = false;
    private Properties serverProps;
    private Properties userProps;
    private boolean withinJEdit = false;
    private Vector projectList = new Vector();
    private File projectDir;
    private File proColDir;
    private File customServerPropsFile;
    private File userPropsFile;
    private File[] projectDirs;
    static /* synthetic */ Class class$com$enderak$procol$server$net$ProColServer;

    public static void printErr(String string) {
        String string2 = "[" + new SimpleDateFormat(RunProColServer.getServer().getProperty("options.procol.server.logtimeformat", "MM/dd/yy HH:mm:ss")).format(new Date()) + "] ERROR: " + string;
        if (RunProColServer.getServer().isWithinJEdit()) {
            ((ProColServerDockableLog)jEdit.getLastView().getDockableWindowManager().getDockable("procol.server.dockable.log")).printErr(string2);
        } else {
            System.err.println(string2);
        }
    }

    public static void printInfo(String string) {
        String string2 = "[" + new SimpleDateFormat(RunProColServer.getServer().getProperty("options.procol.server.logtimeformat", "MM/dd/yy HH:mm:ss")).format(new Date()) + "] " + string;
        if (RunProColServer.getServer().isWithinJEdit()) {
            ((ProColServerDockableLog)jEdit.getLastView().getDockableWindowManager().getDockable("procol.server.dockable.log")).printInfo(string2);
        } else {
            System.out.println(string2);
        }
    }

    public void run() {
        Object object;
        this.loadProperties();
        ProColServer.printInfo("Starting ProCol Server...");
        this.initProjects();
        if (this.withinJEdit && jEdit.getEditServer().getPort() == this.getPort()) {
            this.setProperty("options.procol.server.port", "" + (this.getPort() + 1));
            ProColServerDockable.displayError("Port in Use", "jEdit has reserved port jEdit.getEditServer().getPort() for use with EditServer.\nThe ProCol server will use port " + this.getPort() + " instead.\nRestarting jEdit should allow the ProCol server to start normally.");
        }
        try {
            Security.addProvider((java.security.Provider)new Provider());
            object = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
            serverSocket = (SSLServerSocket)((ServerSocketFactory)object).createServerSocket(this.getPort());
            SSLCommon.enableAnonymousCipherSuites(serverSocket);
        }
        catch (IOException iOException) {
            ProColServer.printErr("IOException opening server socket channel!");
            return;
        }
        this.serverRunning = true;
        ProColServer.printInfo("ProCol Server running on port " + this.getPort());
        while (this.serverRunning) {
            try {
                object = new ServerConnection((SSLSocket)serverSocket.accept());
                connections.add(object);
            }
            catch (IOException iOException) {
                ProColServer.printErr("IOException opening socket! " + iOException);
            }
        }
        ProColServer.printInfo("Stopping ProCol Server...");
        this.closeAllConnections();
        ProColServer.printInfo("ProCol Server Stopped");
    }

    public void stopServer() {
        this.serverRunning = false;
        try {
            serverSocket.close();
        }
        catch (IOException iOException) {
            ProColServer.printErr("Could not close socket");
        }
        for (int i = 0; i < connections.size(); ++i) {
            this.closeConnection((ServerConnection)connections.elementAt(i));
        }
        connections.removeAllElements();
    }

    public void closeConnection(ServerConnection serverConnection) {
        serverConnection.close();
    }

    public void closeAllConnections() {
        ListIterator listIterator = this.projectList.listIterator();
        while (listIterator.hasNext()) {
            ((ProColServerProject)listIterator.next()).closeAllConnections();
            listIterator.remove();
        }
    }

    public Object setProperty(String string, String string2) {
        return this.serverProps.setProperty(string, string2);
    }

    public String getProperty(String string) {
        return this.serverProps.getProperty(string);
    }

    public String getProperty(String string, String string2) {
        return this.serverProps.getProperty(string, string2);
    }

    public String getUserProperty(String string) {
        return this.userProps.getProperty(string);
    }

    public String getUserProperty(String string, String string2) {
        return this.userProps.getProperty(string, string2);
    }

    public boolean isWithinJEdit() {
        return this.withinJEdit;
    }

    public boolean isRunning() {
        return this.serverRunning;
    }

    public int getPort() {
        return Integer.parseInt(this.getProperty("options.procol.server.port", "4937"));
    }

    public int authenticateUser(String string, String string2) {
        if (this.isUserLoggedIn(string)) {
            return -268435198;
        }
        if (string2.equals(this.getUserProperty(string + ".password"))) {
            return 257;
        }
        if (this.getUserProperty(string + ".password") == null) {
            return -268435197;
        }
        return -268435196;
    }

    public boolean isUserLoggedIn(String string) {
        for (int i = 0; i < this.projectList.size(); ++i) {
            Vector vector = ((ProColServerProject)this.projectList.elementAt(i)).getUserList();
            for (int j = 0; j < vector.size(); ++j) {
                if (!string.equals(vector.elementAt(j))) continue;
                return true;
            }
        }
        return false;
    }

    public Vector getProjectList() {
        return this.projectList;
    }

    public Vector getAllowedProjects(ProColUser proColUser) {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.projectList.elements();
        while (enumeration.hasMoreElements()) {
            ProColServerProject proColServerProject = (ProColServerProject)enumeration.nextElement();
            if (!proColServerProject.getAllowedUsers().contains(proColUser.getName())) continue;
            vector.add(proColServerProject.getName());
        }
        return vector;
    }

    public ProColServerProject getProject(String string) {
        int n;
        for (n = 0; n < this.projectList.size(); ++n) {
            if (!string.equals(((ProColServerProject)this.projectList.elementAt(n)).getName())) continue;
            return (ProColServerProject)this.projectList.elementAt(n);
        }
        if (this.getProperty("options.procol.server.projects.dynamicload", "false").equals("true")) {
            this.reloadProjectDirs();
            for (n = 0; n < this.projectDirs.length; ++n) {
                if (!this.projectDirs[n].getName().equals(string)) continue;
                ProColServerProject proColServerProject = new ProColServerProject(this.projectDirs[n].toURI(), string, true);
                this.projectList.add(proColServerProject);
                return proColServerProject;
            }
        }
        return null;
    }

    public void setWithinJEdit(boolean bl) {
        this.withinJEdit = bl;
    }

    protected void finalize() {
        try {
            serverSocket.close();
        }
        catch (IOException iOException) {
            ProColServer.printErr("Could not close socket");
        }
    }

    private void loadProperties() {
        this.serverProps = new Properties();
        this.userProps = new Properties();
        try {
            this.serverProps.load((class$com$enderak$procol$server$net$ProColServer == null ? (class$com$enderak$procol$server$net$ProColServer = ProColServer.class$("com.enderak.procol.server.net.ProColServer")) : class$com$enderak$procol$server$net$ProColServer).getResourceAsStream(DEFAULT_PROPS_FILE_NAME));
        }
        catch (IOException iOException) {
            ProColServer.printErr("Error loading default server properties: " + iOException);
        }
        this.proColDir = new File(System.getProperty("user.home") + FILE_SEPARATOR + DEFAULT_PROCOL_DIR_NAME);
        if (!this.proColDir.exists()) {
            this.proColDir.mkdirs();
            ProColServer.printInfo("Empty procol server directory created: " + this.proColDir.getPath());
        }
        this.customServerPropsFile = new File(this.proColDir.getPath() + FILE_SEPARATOR + this.getProperty("options.procol.server.customprops", DEFAULT_CUSTOM_PROPS_NAME));
        try {
            this.serverProps.load(new FileInputStream(this.customServerPropsFile));
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                this.customServerPropsFile.createNewFile();
                ProColServer.printInfo("Empty server properties file created: " + this.customServerPropsFile.getPath());
            }
            catch (IOException iOException) {
                ProColServer.printErr("IOException creating empty server properties file: " + this.customServerPropsFile.getPath());
            }
        }
        catch (IOException iOException) {
            ProColServer.printErr("IOException loading server properties: " + iOException);
        }
        this.userPropsFile = new File(this.proColDir.getPath() + FILE_SEPARATOR + this.getProperty("options.procol.server.users.list", DEFAULT_USER_PROPS_NAME));
        try {
            this.userProps.load(new FileInputStream(this.userPropsFile));
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                this.userPropsFile.createNewFile();
                ProColServer.printInfo("Empty user properties file created: " + this.userPropsFile.getPath());
            }
            catch (IOException iOException) {
                ProColServer.printErr("IOException creating empty user properties file: " + this.userPropsFile.getPath());
            }
        }
        catch (IOException iOException) {
            ProColServer.printErr("IOException loading server properties: " + iOException);
        }
    }

    private void initProjects() {
        this.projectDir = new ProColFile(this.proColDir.getPath() + FILE_SEPARATOR + this.getProperty("options.procol.server.projects.dir", DEFAULT_PROJECTS_DIR_NAME));
        if (!this.projectDir.exists()) {
            this.projectDir.mkdirs();
            ProColServer.printInfo("Empty procol project directory created: " + this.projectDir.getPath());
        }
        this.reloadProjectDirs();
        this.projectList = new Vector();
        for (int i = 0; i < this.projectDirs.length; ++i) {
            ProColServerProject proColServerProject = new ProColServerProject(this.projectDirs[i].toURI(), this.projectDirs[i].getName(), this.getProperty("options.procol.server.projects.dynamicload", "false").equals("false"));
            ProColServer.printInfo("Project loaded: " + proColServerProject.getName());
            this.projectList.add(proColServerProject);
        }
    }

    private void reloadProjectDirs() {
        this.projectDirs = this.projectDir.listFiles(new ProjectFileFilter());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

