/*
 * Decompiled with CFR 0.152.
 */
package com.enderak.procol.server.net;

import com.enderak.procol.common.model.ProColFile;
import com.enderak.procol.common.model.ProColUser;
import com.enderak.procol.common.net.MessageFactory;
import com.enderak.procol.common.net.OutgoingMessageHandler;
import com.enderak.procol.common.net.PacketFactory;
import com.enderak.procol.common.net.ProColIncomingMessage;
import com.enderak.procol.common.net.ProColPacket;
import com.enderak.procol.common.net.SSLCommon;
import com.enderak.procol.common.util.ProColUtils;
import com.enderak.procol.server.RunProColServer;
import com.enderak.procol.server.model.ProColServerProject;
import com.enderak.procol.server.net.IncomingMessageHandler;
import com.enderak.procol.server.net.ProColServer;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.net.ssl.SSLSocket;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class ServerConnection
extends Thread
implements Observer {
    private SSLSocket client;
    private IncomingMessageHandler imh;
    private OutgoingMessageHandler omh;
    private DataInputStream in;
    private PacketFactory packetFactory = new PacketFactory();
    private MessageFactory messageFactory = new MessageFactory();
    private ProColUser user;
    private ProColServerProject project;
    private boolean isRunning = false;
    private int clientMajorVersion;
    private int clientMinorVersion;
    private int serverMajorVersion;
    private int serverMinorVersion = 0;

    public ServerConnection(SSLSocket sSLSocket) {
        if (sSLSocket == null) {
            ProColServer.printErr("NULL SSLSocket in ServerConnection constructor");
            return;
        }
        this.client = sSLSocket;
        SSLCommon.enableAnonymousCipherSuites(this.client);
        this.imh = new IncomingMessageHandler(this);
        this.imh.start();
        this.omh = new OutgoingMessageHandler(this.client, this.packetFactory);
        this.omh.start();
        this.start();
    }

    public void run() {
        try {
            this.in = new DataInputStream(this.client.getInputStream());
        }
        catch (IOException iOException) {
            ProColServer.printErr("getInputStream failed");
            return;
        }
        this.isRunning = true;
        while (this.isRunning) {
            this.receive();
        }
        this.close();
    }

    public void receive() {
        try {
            int n = this.in.readInt();
            int n2 = this.in.readInt();
            int n3 = this.in.readInt();
            int n4 = this.in.readInt();
            byte[] byArray = new byte[n4];
            this.in.readFully(byArray);
            this.messageFactory.addPacket(new ProColPacket(n, n2, n3, n4, byArray));
        }
        catch (IOException iOException) {
            ProColServer.printErr("IOException reading from client in ServerConnection! " + iOException);
            this.isRunning = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ProColServer.printInfo("ServerConnection closing!");
        try {
            this.packetFactory.addToQueue(513, 2);
            this.user = null;
            this.closeProject();
            OutgoingMessageHandler outgoingMessageHandler = this.omh;
            synchronized (outgoingMessageHandler) {
                try {
                    this.omh.wait(5000L);
                    this.in.close();
                    this.imh.close();
                    this.omh.close();
                }
                catch (InterruptedException interruptedException) {
                    ProColServer.printErr(interruptedException.toString());
                }
            }
        }
        catch (IOException iOException) {
            ProColServer.printErr("Error in ServerConnection " + iOException);
        }
        ProColServer.printInfo("ServerConnection closed!");
    }

    public void closeProject() {
        if (this.project != null) {
            this.project.removeConnection(this);
            this.project = null;
        }
    }

    public void openProject(String string) {
        this.project = RunProColServer.getServer().getProject(string);
        this.project.addConnection(this);
    }

    public int checkProtocol(ProColIncomingMessage proColIncomingMessage) {
        StringTokenizer stringTokenizer = new StringTokenizer(new String(proColIncomingMessage.data), ".");
        this.clientMajorVersion = Integer.parseInt(stringTokenizer.nextToken());
        this.clientMinorVersion = Integer.parseInt(stringTokenizer.nextToken());
        stringTokenizer = new StringTokenizer(new String("0.1"), ".");
        this.serverMajorVersion = Integer.parseInt(stringTokenizer.nextToken());
        this.serverMinorVersion = Integer.parseInt(stringTokenizer.nextToken());
        if (this.clientMajorVersion == this.serverMajorVersion) {
            if (this.clientMinorVersion == this.serverMinorVersion) {
                return 1;
            }
            return 2;
        }
        if (this.clientMajorVersion > this.serverMajorVersion) {
            return -268435452;
        }
        return -268435453;
    }

    public SSLSocket getClientSocket() {
        return this.client;
    }

    public ProColUser getUser() {
        return this.user;
    }

    public void setUser(ProColUser proColUser) {
        this.user = proColUser;
    }

    public ProColServerProject getProject() {
        return this.project;
    }

    public PacketFactory getPacketFactory() {
        return this.packetFactory;
    }

    public MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public void update(Observable observable, Object object) {
        if (object == null || object instanceof String && ((String)object).equals("CONNECTIONS")) {
            this.packetFactory.addToQueue(65537, ProColUtils.vectorToString(this.project.getUserList()), 2);
        } else if (object == null || object instanceof String && ((String)object).equals("FILE_LIST")) {
            this.sendFileTree();
        } else if (object instanceof ProColFile) {
            this.packetFactory.addToQueue(196610, ((ProColFile)object).getFileInfo(this.project.getProjectFilesURI()), 2);
        }
    }

    public void sendFileTree() {
        StringBuffer stringBuffer = new StringBuffer(this.project.getOptimalStringBufferSize(this.project.getProjectFilesRootNode()));
        for (DefaultMutableTreeNode defaultMutableTreeNode = this.project.getProjectFilesRootNode().getFirstLeaf(); defaultMutableTreeNode != null; defaultMutableTreeNode = defaultMutableTreeNode.getNextLeaf()) {
            ProColFile proColFile = (ProColFile)defaultMutableTreeNode.getUserObject();
            stringBuffer.append(proColFile.getFileInfo(this.project.getProjectFilesURI()));
        }
        this.packetFactory.addToQueue(196609, stringBuffer.toString(), 1);
    }

    public void sendFileHistory(URI uRI) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.project.getNodeForFile(uRI);
        ProColFile proColFile = (ProColFile)defaultMutableTreeNode.getUserObject();
        this.packetFactory.addToQueue(198147, proColFile.getVersionsFile(), 1);
    }

    public void sendFiles(URI uRI, int n) {
        try {
            ProColFile proColFile;
            DefaultMutableTreeNode defaultMutableTreeNode;
            if (uRI == null) {
                defaultMutableTreeNode = this.project.getProjectFilesRootNode();
                proColFile = null;
            } else {
                defaultMutableTreeNode = this.project.getNodeForFile(uRI);
                proColFile = (ProColFile)defaultMutableTreeNode.getUserObject();
            }
            if (!defaultMutableTreeNode.isLeaf()) {
                Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
                while (enumeration.hasMoreElements()) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                    proColFile = (ProColFile)defaultMutableTreeNode2.getUserObject();
                    this.sendFiles(this.project.getProjectFilesURI().relativize(proColFile.toURI()), n);
                }
            } else if (proColFile != null) {
                this.packetFactory.addToQueue(n, uRI, (File)proColFile, 0);
            }
        }
        catch (NullPointerException nullPointerException) {
            this.packetFactory.addToQueue(-268234829, uRI, 1);
        }
    }

    public void sendFiles(int n) {
        this.sendFiles(null, n);
    }

    public void sendSnapshot() {
        this.sendFiles(null, 196868);
    }

    public void checkOutFiles(URI uRI) {
        try {
            DefaultMutableTreeNode defaultMutableTreeNode = this.project.getNodeForFile(uRI);
            ProColFile proColFile = (ProColFile)defaultMutableTreeNode.getUserObject();
            if (!defaultMutableTreeNode.isLeaf()) {
                Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
                while (enumeration.hasMoreElements()) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                    proColFile = (ProColFile)defaultMutableTreeNode2.getUserObject();
                    this.checkOutFiles(this.project.getProjectFilesURI().relativize(proColFile.toURI()));
                }
            } else if (proColFile.checkOut(this.user.getName())) {
                this.project.forceNotify(proColFile);
                this.packetFactory.addToQueue(197376, uRI, (File)proColFile, 0);
            } else {
                this.packetFactory.addToQueue(-268237840, uRI, 1);
            }
        }
        catch (NullPointerException nullPointerException) {
            this.packetFactory.addToQueue(-268237826, uRI, 1);
        }
    }

    public int addPrivateMessage(String string, String string2, String string3, String string4, String string5) {
        if (!this.project.getAllowedUsers().contains(string2)) {
            return -268173072;
        }
        Object object = new File(this.project.getPrivateMessagesURI().getPath() + File.separator + string2);
        Properties properties = new Properties();
        if (((File)object).exists()) {
            try {
                properties.load(new FileInputStream((File)object));
            }
            catch (IOException iOException) {
                ProColServer.printErr("IOException loading private message queue for " + string2);
                return -268173071;
            }
        }
        int n = Integer.parseInt(properties.getProperty("current", "0"));
        properties.setProperty("current", "" + ++n);
        properties.setProperty(n + ".sender", string);
        properties.setProperty(n + ".date", "" + new SimpleDateFormat(RunProColServer.getServer().getProperty("options.procol.server.logtimeformat", "MM/dd/yy HH:mm:ss")).format(new Date()));
        properties.setProperty(n + ".previous", "" + (n - 1));
        properties.setProperty(n - 1 + ".next", "" + n);
        properties.setProperty(n + ".subject", string4);
        properties.setProperty(n + ".message", string5);
        properties.setProperty(n + ".replyto", string3);
        try {
            properties.store(new FileOutputStream((File)object), "Private Messages for " + string2);
        }
        catch (IOException iOException) {
            ProColServer.printErr("IOException storing private message queue for " + string2);
            return -268173071;
        }
        object = this.project.getConnectionFor(string2);
        if (object != null) {
            ((ServerConnection)object).getPacketFactory().addToQueue(262144, 2);
        }
        return 262151;
    }

    public void getPrivateMessageList() {
        StringBuffer stringBuffer = new StringBuffer();
        File file = new File(this.project.getPrivateMessagesURI().getPath() + File.separator + this.user.getName());
        Properties properties = new Properties();
        if (file.exists()) {
            try {
                properties.load(new FileInputStream(file));
            }
            catch (IOException iOException) {
                ProColServer.printErr("IOException loading private message list for " + this.user.getName());
                return;
            }
        }
        String string = properties.getProperty("current", "0");
        stringBuffer.append("current=" + string);
        while (!string.equals("0")) {
            stringBuffer.append("\n" + string + ".date=" + properties.getProperty(string + ".date"));
            stringBuffer.append("\n" + string + ".subject=" + properties.getProperty(string + ".subject"));
            stringBuffer.append("\n" + string + ".sender=" + properties.getProperty(string + ".sender"));
            stringBuffer.append("\n" + string + ".previous=" + properties.getProperty(string + ".previous"));
            stringBuffer.append("\n" + string + ".replyto=" + properties.getProperty(string + ".replyto"));
            string = properties.getProperty(string + ".previous", "0");
        }
        this.packetFactory.addToQueue(262146, stringBuffer.toString(), 2);
    }

    public String getPrivateMessage(String string) {
        Properties properties = new Properties();
        File file = new File(this.project.getPrivateMessagesURI().getPath() + File.separator + this.user.getName());
        if (file.exists()) {
            try {
                properties.load(new FileInputStream(file));
            }
            catch (IOException iOException) {
                ProColServer.printErr("IOException loading private message list for " + this.user.getName());
                return "(Error loading private messages!)";
            }
        }
        return properties.getProperty(string + ".message", "(Error getting private message!)");
    }

    public int deletePrivateMessage(String string) {
        Properties properties = new Properties();
        File file = new File(this.project.getPrivateMessagesURI().getPath() + File.separator + this.user.getName());
        if (file.exists()) {
            try {
                properties.load(new FileInputStream(file));
            }
            catch (IOException iOException) {
                ProColServer.printErr("IOException loading private message list for " + this.user.getName());
                return -268173070;
            }
        }
        String string2 = properties.getProperty(string + ".next");
        String string3 = properties.getProperty(string + ".previous");
        if (properties.getProperty("current").equals(string)) {
            properties.setProperty("current", string3);
        }
        if (string2 != null) {
            properties.setProperty(string3 + ".next", string2);
            properties.setProperty(string2 + ".previous", string3);
        }
        properties.remove(string + ".sender");
        properties.remove(string + ".date");
        properties.remove(string + ".previous");
        properties.remove(string + ".next");
        properties.remove(string + ".subject");
        properties.remove(string + ".message");
        properties.remove(string + ".replyto");
        try {
            properties.store(new FileOutputStream(file), "Private Messages for " + this.user.getName());
        }
        catch (IOException iOException) {
            ProColServer.printErr("IOException storing private message queue for " + this.user.getName());
            return -268173070;
        }
        this.getPrivateMessageList();
        return 262151;
    }

    public int addPublicMessage(String string, String string2, String string3, String string4) {
        File file = new File(this.project.getPublicMessagesURI().getPath());
        Properties properties = new Properties();
        if (file.exists()) {
            try {
                properties.load(new FileInputStream(file));
            }
            catch (IOException iOException) {
                ProColServer.printErr("IOException loading public message queue");
                return -268172815;
            }
        }
        int n = Integer.parseInt(properties.getProperty("current", "0"));
        properties.setProperty("current", "" + ++n);
        properties.setProperty(n + ".sender", string);
        properties.setProperty(n + ".date", "" + new SimpleDateFormat(RunProColServer.getServer().getProperty("options.procol.server.logtimeformat", "MM/dd/yy HH:mm:ss")).format(new Date()));
        properties.setProperty(n + ".previous", "" + (n - 1));
        properties.setProperty(n - 1 + ".next", "" + n);
        properties.setProperty(n + ".subject", string3);
        properties.setProperty(n + ".message", string4);
        properties.setProperty(n + ".replyto", string2);
        try {
            properties.store(new FileOutputStream(file), "Public messages");
        }
        catch (IOException iOException) {
            ProColServer.printErr("IOException storing public messages");
            return -268172815;
        }
        Enumeration enumeration = this.project.getConnections().elements();
        while (enumeration.hasMoreElements()) {
            ServerConnection serverConnection = (ServerConnection)enumeration.nextElement();
            if (serverConnection == null) continue;
            serverConnection.getPacketFactory().addToQueue(262400, 2);
        }
        return 262407;
    }

    public void getPublicMessageList() {
        StringBuffer stringBuffer = new StringBuffer();
        File file = new File(this.project.getPublicMessagesURI().getPath());
        Properties properties = new Properties();
        if (file.exists()) {
            try {
                properties.load(new FileInputStream(file));
            }
            catch (IOException iOException) {
                ProColServer.printErr("IOException loading private message list for " + this.user.getName());
                return;
            }
        }
        String string = properties.getProperty("current", "0");
        stringBuffer.append("current=" + string);
        while (!string.equals("0")) {
            stringBuffer.append("\n" + string + ".date=" + properties.getProperty(string + ".date"));
            stringBuffer.append("\n" + string + ".subject=" + properties.getProperty(string + ".subject"));
            stringBuffer.append("\n" + string + ".sender=" + properties.getProperty(string + ".sender"));
            stringBuffer.append("\n" + string + ".previous=" + properties.getProperty(string + ".previous"));
            stringBuffer.append("\n" + string + ".replyto=" + properties.getProperty(string + ".replyto"));
            string = properties.getProperty(string + ".previous", "0");
        }
        this.packetFactory.addToQueue(262402, stringBuffer.toString(), 2);
    }

    public String getPublicMessage(String string) {
        Properties properties = new Properties();
        File file = new File(this.project.getPublicMessagesURI().getPath());
        if (file.exists()) {
            try {
                properties.load(new FileInputStream(file));
            }
            catch (IOException iOException) {
                ProColServer.printErr("IOException loading private message list for " + this.user.getName());
                return "(Error loading private messages!)";
            }
        }
        return properties.getProperty(string + ".message", "(Error getting private message!)");
    }

    public int deletePublicMessage(String string) {
        Properties properties = new Properties();
        File file = new File(this.project.getPublicMessagesURI().getPath());
        if (file.exists()) {
            try {
                properties.load(new FileInputStream(file));
            }
            catch (IOException iOException) {
                ProColServer.printErr("IOException loading public message list");
                return -268172814;
            }
        }
        String string2 = properties.getProperty(string + ".next");
        String string3 = properties.getProperty(string + ".previous");
        if (properties.getProperty("current").equals(string)) {
            properties.setProperty("current", string3);
        }
        if (string2 != null) {
            properties.setProperty(string3 + ".next", string2);
            properties.setProperty(string2 + ".previous", string3);
        }
        properties.remove(string + ".sender");
        properties.remove(string + ".date");
        properties.remove(string + ".previous");
        properties.remove(string + ".next");
        properties.remove(string + ".subject");
        properties.remove(string + ".message");
        properties.remove(string + ".replyto");
        try {
            properties.store(new FileOutputStream(file), "Public Messages");
        }
        catch (IOException iOException) {
            ProColServer.printErr("IOException storing public list");
            return -268172814;
        }
        Enumeration enumeration = this.project.getConnections().elements();
        while (enumeration.hasMoreElements()) {
            ServerConnection serverConnection = (ServerConnection)enumeration.nextElement();
            if (serverConnection == null) continue;
            serverConnection.getPublicMessageList();
        }
        return 262407;
    }

    public int addTodoItem(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        File file = new File(this.project.getTodoListURI().getPath());
        Properties properties = new Properties();
        if (file.exists()) {
            try {
                properties.load(new FileInputStream(file));
            }
            catch (IOException iOException) {
                ProColServer.printErr("IOException loading todo list");
                return -268107535;
            }
        }
        int n = Integer.parseInt(properties.getProperty("current", "0"));
        properties.setProperty("current", "" + ++n);
        properties.setProperty(n + ".sender", string);
        properties.setProperty(n + ".duedate", "" + string5);
        properties.setProperty(n + ".previous", "" + (n - 1));
        properties.setProperty(n - 1 + ".next", "" + n);
        properties.setProperty(n + ".subject", string2);
        properties.setProperty(n + ".priority", string3);
        properties.setProperty(n + ".assigned", string4);
        properties.setProperty(n + ".complete", string6);
        properties.setProperty(n + ".description", string7);
        try {
            properties.store(new FileOutputStream(file), "Todo list");
        }
        catch (IOException iOException) {
            ProColServer.printErr("IOException storing todo list");
            return -268107535;
        }
        Enumeration enumeration = this.project.getConnections().elements();
        while (enumeration.hasMoreElements()) {
            ServerConnection serverConnection = (ServerConnection)enumeration.nextElement();
            if (serverConnection == null) continue;
            serverConnection.getPacketFactory().addToQueue(327680, 2);
        }
        return 327687;
    }

    public int updateTodoItem(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        File file = new File(this.project.getTodoListURI().getPath());
        Properties properties = new Properties();
        if (file.exists()) {
            try {
                properties.load(new FileInputStream(file));
            }
            catch (IOException iOException) {
                ProColServer.printErr("IOException loading todo list");
                return -268107533;
            }
        }
        properties.setProperty(string2 + ".sender", string);
        properties.setProperty(string2 + ".duedate", string6);
        properties.setProperty(string2 + ".subject", string3);
        properties.setProperty(string2 + ".priority", string4);
        properties.setProperty(string2 + ".assigned", string5);
        properties.setProperty(string2 + ".complete", string7);
        properties.setProperty(string2 + ".description", string8);
        try {
            properties.store(new FileOutputStream(file), "Todo list");
        }
        catch (IOException iOException) {
            ProColServer.printErr("IOException storing todo list");
            return -268107533;
        }
        Enumeration enumeration = this.project.getConnections().elements();
        while (enumeration.hasMoreElements()) {
            ServerConnection serverConnection = (ServerConnection)enumeration.nextElement();
            if (serverConnection == null) continue;
            serverConnection.getPacketFactory().addToQueue(327680, 2);
        }
        return 327687;
    }

    public void getTodoItemList() {
        StringBuffer stringBuffer = new StringBuffer();
        File file = new File(this.project.getTodoListURI().getPath());
        Properties properties = new Properties();
        if (file.exists()) {
            try {
                properties.load(new FileInputStream(file));
            }
            catch (IOException iOException) {
                ProColServer.printErr("IOException loading todo item list");
                return;
            }
        }
        String string = properties.getProperty("current", "0");
        stringBuffer.append("current=" + string);
        while (!string.equals("0")) {
            stringBuffer.append("\n" + string + ".duedate=" + properties.getProperty(string + ".duedate"));
            stringBuffer.append("\n" + string + ".subject=" + properties.getProperty(string + ".subject"));
            stringBuffer.append("\n" + string + ".sender=" + properties.getProperty(string + ".sender"));
            stringBuffer.append("\n" + string + ".assigned=" + properties.getProperty(string + ".assigned"));
            stringBuffer.append("\n" + string + ".previous=" + properties.getProperty(string + ".previous"));
            stringBuffer.append("\n" + string + ".priority=" + properties.getProperty(string + ".priority"));
            stringBuffer.append("\n" + string + ".complete=" + properties.getProperty(string + ".complete"));
            string = properties.getProperty(string + ".previous", "0");
        }
        this.packetFactory.addToQueue(327682, stringBuffer.toString(), 2);
    }

    public String getTodoItem(String string) {
        Properties properties = new Properties();
        File file = new File(this.project.getTodoListURI().getPath());
        if (file.exists()) {
            try {
                properties.load(new FileInputStream(file));
            }
            catch (IOException iOException) {
                ProColServer.printErr("IOException loading private message list for " + this.user.getName());
                return "(Error loading private messages!)";
            }
        }
        return properties.getProperty(string + ".description", "(Error getting todo item description!)");
    }

    public int deleteTodoItem(String string) {
        Properties properties = new Properties();
        File file = new File(this.project.getTodoListURI().getPath());
        if (file.exists()) {
            try {
                properties.load(new FileInputStream(file));
            }
            catch (IOException iOException) {
                ProColServer.printErr("IOException loading private message list for " + this.user.getName());
                return -268107534;
            }
        }
        String string2 = properties.getProperty(string + ".next");
        String string3 = properties.getProperty(string + ".previous");
        if (properties.getProperty("current").equals(string)) {
            properties.setProperty("current", string3);
        }
        if (string2 != null) {
            properties.setProperty(string3 + ".next", string2);
            properties.setProperty(string2 + ".previous", string3);
        }
        properties.remove(string + ".sender");
        properties.remove(string + ".duedate");
        properties.remove(string + ".previous");
        properties.remove(string + ".next");
        properties.remove(string + ".subject");
        properties.remove(string + ".priority");
        properties.remove(string + ".assigned");
        properties.remove(string + ".complete");
        properties.remove(string + ".description");
        try {
            properties.store(new FileOutputStream(file), "Private Messages for " + this.user.getName());
        }
        catch (IOException iOException) {
            ProColServer.printErr("IOException storing private message queue for " + this.user.getName());
            return -268107534;
        }
        this.getTodoItemList();
        return 327687;
    }

    public int addBugItem(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        File file = new File(this.project.getBugListURI().getPath());
        Properties properties = new Properties();
        if (file.exists()) {
            try {
                properties.load(new FileInputStream(file));
            }
            catch (IOException iOException) {
                ProColServer.printErr("IOException loading public message queue");
                return -268107279;
            }
        }
        int n = Integer.parseInt(properties.getProperty("current", "0"));
        properties.setProperty("current", "" + ++n);
        properties.setProperty(n + ".sender", string);
        properties.setProperty(n + ".duedate", "" + string5);
        properties.setProperty(n + ".previous", "" + (n - 1));
        properties.setProperty(n - 1 + ".next", "" + n);
        properties.setProperty(n + ".subject", string2);
        properties.setProperty(n + ".priority", string3);
        properties.setProperty(n + ".assigned", string4);
        properties.setProperty(n + ".complete", string6);
        properties.setProperty(n + ".description", string7);
        try {
            properties.store(new FileOutputStream(file), "Public messages");
        }
        catch (IOException iOException) {
            ProColServer.printErr("IOException storing public messages");
            return -268107279;
        }
        Enumeration enumeration = this.project.getConnections().elements();
        while (enumeration.hasMoreElements()) {
            ServerConnection serverConnection = (ServerConnection)enumeration.nextElement();
            if (serverConnection == null) continue;
            serverConnection.getPacketFactory().addToQueue(327936, 2);
        }
        return 327943;
    }

    public int updateBugItem(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        File file = new File(this.project.getBugListURI().getPath());
        Properties properties = new Properties();
        if (file.exists()) {
            try {
                properties.load(new FileInputStream(file));
            }
            catch (IOException iOException) {
                ProColServer.printErr("IOException loading bug list");
                return -268107277;
            }
        }
        properties.setProperty(string2 + ".sender", string);
        properties.setProperty(string2 + ".duedate", string6);
        properties.setProperty(string2 + ".subject", string3);
        properties.setProperty(string2 + ".priority", string4);
        properties.setProperty(string2 + ".assigned", string5);
        properties.setProperty(string2 + ".complete", string7);
        properties.setProperty(string2 + ".description", string8);
        try {
            properties.store(new FileOutputStream(file), "Bug list");
        }
        catch (IOException iOException) {
            ProColServer.printErr("IOException storing bug list");
            return -268107277;
        }
        Enumeration enumeration = this.project.getConnections().elements();
        while (enumeration.hasMoreElements()) {
            ServerConnection serverConnection = (ServerConnection)enumeration.nextElement();
            if (serverConnection == null) continue;
            serverConnection.getPacketFactory().addToQueue(327936, 2);
        }
        return 327943;
    }

    public void getBugItemList() {
        StringBuffer stringBuffer = new StringBuffer();
        File file = new File(this.project.getBugListURI().getPath());
        Properties properties = new Properties();
        if (file.exists()) {
            try {
                properties.load(new FileInputStream(file));
            }
            catch (IOException iOException) {
                ProColServer.printErr("IOException loading bug item list");
                return;
            }
        }
        String string = properties.getProperty("current", "0");
        stringBuffer.append("current=" + string);
        while (!string.equals("0")) {
            stringBuffer.append("\n" + string + ".duedate=" + properties.getProperty(string + ".duedate"));
            stringBuffer.append("\n" + string + ".subject=" + properties.getProperty(string + ".subject"));
            stringBuffer.append("\n" + string + ".sender=" + properties.getProperty(string + ".sender"));
            stringBuffer.append("\n" + string + ".assigned=" + properties.getProperty(string + ".assigned"));
            stringBuffer.append("\n" + string + ".previous=" + properties.getProperty(string + ".previous"));
            stringBuffer.append("\n" + string + ".priority=" + properties.getProperty(string + ".priority"));
            stringBuffer.append("\n" + string + ".complete=" + properties.getProperty(string + ".complete"));
            string = properties.getProperty(string + ".previous", "0");
        }
        this.packetFactory.addToQueue(327938, stringBuffer.toString(), 2);
    }

    public String getBugItem(String string) {
        Properties properties = new Properties();
        File file = new File(this.project.getBugListURI().getPath());
        if (file.exists()) {
            try {
                properties.load(new FileInputStream(file));
            }
            catch (IOException iOException) {
                ProColServer.printErr("IOException loading private message list for " + this.user.getName());
                return "(Error loading private messages!)";
            }
        }
        return properties.getProperty(string + ".description", "(Error getting todo item description!)");
    }

    public int deleteBugItem(String string) {
        Properties properties = new Properties();
        File file = new File(this.project.getBugListURI().getPath());
        if (file.exists()) {
            try {
                properties.load(new FileInputStream(file));
            }
            catch (IOException iOException) {
                ProColServer.printErr("IOException loading public message list");
                return -268107278;
            }
        }
        String string2 = properties.getProperty(string + ".next");
        String string3 = properties.getProperty(string + ".previous");
        if (properties.getProperty("current").equals(string)) {
            properties.setProperty("current", string3);
        }
        if (string2 != null) {
            properties.setProperty(string3 + ".next", string2);
            properties.setProperty(string2 + ".previous", string3);
        }
        properties.remove(string + ".sender");
        properties.remove(string + ".duedate");
        properties.remove(string + ".previous");
        properties.remove(string + ".next");
        properties.remove(string + ".subject");
        properties.remove(string + ".priority");
        properties.remove(string + ".assigned");
        properties.remove(string + ".complete");
        properties.remove(string + ".description");
        try {
            properties.store(new FileOutputStream(file), "Public Messages");
        }
        catch (IOException iOException) {
            ProColServer.printErr("IOException storing public list");
            return -268107278;
        }
        Enumeration enumeration = this.project.getConnections().elements();
        while (enumeration.hasMoreElements()) {
            ServerConnection serverConnection = (ServerConnection)enumeration.nextElement();
            if (serverConnection == null) continue;
            serverConnection.getBugItemList();
        }
        return 327943;
    }
}

